/*author Guastella Marco*/

#include "SObject.h"
#include "Pdnet.h"
#include "Scheduler.h"
#include "Packet.h"
#include "hdr.h"
#include "config.h"
#include <string.h>
#include <stdio.h>

demux::demux(int c)
{
	cid_ = c;
	sport_ = DEFAULT_MAX_PORT ;
	tport_ = 0;	
	port_ = new int[sport_];
	
}
		
demux::~demux()
{
	delete port_;
}

int demux::addAgent(int s)
{
	if(tport_ == sport_)
	{
		int *tmp = port_;
		sport_ *= 2;
		port_ = new int[sport_];
		memcpy(port_,tmp,tport_*sizeof(int)); 
		delete [] tmp;
	}
	port_[tport_++] = s;
	return tport_-1;
}

		
void demux::handle(Event *e)
{
	
}
		
void demux::recv(Event *e)
{
	int dport=-1;
	unsigned char *h = (e->pack_) -> getHdr();
	hdr_cmn *cmn = (hdr_cmn *) h;
	Pdnet & pd = Pdnet::instance();
	if(cmn->htype_[LEVELTR] == HDRUDP)
	{
		hdr_udp *udp = (hdr_udp *) &h[Packet::hpos_[LEVELTR]];
		dport=udp->dport_;	
	}
	else if(cmn->htype_[LEVELTR] == HDRTCP)
	{
		hdr_tcp *tcp = (hdr_tcp *) &h[Packet::hpos_[LEVELTR]];
		dport=tcp->dport_;
	}
	if(dport < 0 || dport >= tport_)
		delete e;
	else
		pd.send(e,cid_,port_[dport]);
}
		
int demux::type()
{
	return TYPE_DEMUX;
}

void demux::supdate(CommBuffer *c)
{

}

void demux::rupdate(CommBuffer *)
{
}
