/*author Guastella Marco*/

#include "SObject.h"
#include "Scheduler.h"
#include "Pdnet.h"
#include "config.h"
#include "Object.h"
#include <string.h>
#include "hdr.h"
#include "Packet.h"
#include <stdlib.h>
#include <stdio.h>
#include "CommBuffer.h"

#define MAX_DEFAULT_LEVEL 5

/*SimplexLink::SimplexLink(double bw,double delay,int qtype,int size,int dcid,int dsid)
{
	nlevel_= 0;
	maxlevel_ = MAX_DEFAULT_LEVEL;
	key_ = new unsigned int[maxlevel_];
	ld_ = new LinkDelay(bw,delay,dcid,dsid);
	addObject(ld_);
	drop *dr = new drop();
	addObject(dr);
	if(qtype == DROPTAIL)
		queue_ = new DropTail();
	queue_ -> setMaxSize(size);
	queue_->setTarget(ld_);
	queue_->setDropTarget(dr);
	addObject(queue_);	
}		

SimplexLink::~SimplexLink()
{
	delete [] key_;
}
		
void SimplexLink::handle(Event *e)
{
	queue_->send(e);
}
		
void SimplexLink::recv(Event *e)
{
	queue_->recv(e);
}

int SimplexLink::type()
{
	return TYPE_SIMPLEXLINK;
}

void SimplexLink::addLevel(int k)
{
	if(nlevel_ == maxlevel_)
	{
		unsigned int *tmp = key_;
		maxlevel_ *= 2;
		key_ = new unsigned int[k];
		memcpy(key_,tmp,nlevel_*sizeof(int));
		delete [] tmp;
	}
	key_[nlevel_++] = k;
}

int SimplexLink::getLevel(unsigned int **k)
{
	(*k) = key_;
	return nlevel_;
}

int SimplexLink::getDstCid()
{
	return ld_->getDstCid();
}

double SimplexLink::bw()
{
	return ld_->bw();
}
		
double SimplexLink::delay()
{
	return ld_->delay();
}

void SimplexLink::supdate(CommBuffer *c)
{

}

void SimplexLink::rupdate(CommBuffer *c)
{

}*/

SimplexLink::SimplexLink(double bw,double delay,int qtype,int size,int dcid,int dsid)
{
	nlevel_= 0;
	maxlevel_ = MAX_DEFAULT_LEVEL;
	key_ = new unsigned int[maxlevel_];
	bw_ = bw;
	delay_ = delay;
	dcid_ = dcid;
	dsid_ = dsid;
	if(qtype == DROPTAIL)
	{
		qmaxsize_ = size;
		stime_ = 0.0;
		qsize_ = 0;
	}
	else
		exit (-1); 
}
		
SimplexLink::~SimplexLink()
{
	delete [] key_;
}

		
void SimplexLink::handle(Event *e)
{
	update_ = 1;
	qsize_--;
	delete e;
}

void SimplexLink::recv(Event *e)
{
	update_ = 1;
	Pdnet &pd = Pdnet::instance();
	if(qsize_ == qmaxsize_)
	{
		delete e;
		return;
	}
	unsigned char *h = (e->pack_) -> getHdr();
	hdr_cmn *cmn = (hdr_cmn *) h;
	double time= (8. * cmn->size_ / bw_);
	if(qsize_ == 0)
	{
		if(stime_ <= pd.clock())
			stime_ = pd.clock()+time;
		else
		{	
			Event *event = new Event();
			stime_ += time;
			qsize_++;
			pd.schedule(event,cid_,sid_,stime_-pd.clock());
		}
		pd.schedule(e,dcid_,dsid_,stime_-pd.clock()+delay_);		
	}
	else
	{
		if(stime_ < pd.clock())
			stime_ = pd.clock()+time;
		else
			stime_ += time;
		Event *event = new Event();
		qsize_++;
		pd.schedule(event,cid_,sid_,stime_- pd.clock());
		pd.schedule(e,dcid_,dsid_,stime_-pd.clock()+delay_);
		
	}
}
		
int SimplexLink::type()
{
	return TYPE_SIMPLEXLINK;
}
		
void SimplexLink::addLevel(int k)
{
	if(nlevel_ == maxlevel_)
	{
		unsigned int *tmp = key_;
		maxlevel_ *= 2;
		key_ = new unsigned int[k];
		memcpy(key_,tmp,nlevel_*sizeof(int));
		delete [] tmp;
	}
	key_[nlevel_++] = k;
}
		
int SimplexLink::getLevel(unsigned int **k)
{
	(*k) = key_;
	return nlevel_;
}
		
int SimplexLink::getDstCid()
{
	return dcid_;
}
		
double SimplexLink::bw()
{
	return bw_;
}
		
double SimplexLink::delay()
{
	return delay_;
}

void SimplexLink::setLocal(int c,int s)
{
	cid_ = c;
	sid_ = s;
}

void SimplexLink::supdate(CommBuffer *c)
{
	c->pack(qsize_);
	c->pack(stime_);
}

void SimplexLink::rupdate(CommBuffer *c)
{
	update_ = 0;
	c->unpack(&qsize_);
	c->unpack(&stime_);
}

void SimplexLink::qupdate(double v1,double v2)
{
	stime_=v1;
	qsize_=(int)v2;
}

int SimplexLink::control(CommBuffer *com)
{
	int tmpqsize = -1;
	double tmpstime = 0.0;
	com->unpack(&tmpqsize);
	com->unpack(&tmpstime);
	if(tmpqsize == qsize_ && tmpstime == stime_)
		return 1;
	return 0;
}

void SimplexLink::removeInput(CommBuffer *com)
{
	int tmp=0;
	double tmp2 = 0.0;
	com->unpack(&tmp);
	com->unpack(&tmp2);
}
