/*author Guastella Marco*/


class Packet;
class CommBuffer;

class Event
{
	public:
		double time_;
		int cid_;
		int sid_;
		int type_;
		double uid_;
		Packet *pack_;
		CommBuffer *input_;
		CommBuffer *output_;
		Event();
		~Event();
		
};


class Scheduler
{
	protected :
		double clock_;
		double tclock_;
	public:
		Scheduler();
		virtual ~Scheduler() {};
		virtual void run()=0;
		virtual void insert(Event *)=0;
		virtual Event *deque()=0;
		virtual Event *head()=0;
		virtual void cancel(double) = 0;
		void start(double tsimul);
		double clock() {return clock_;}
};

#define HEAP_DEFAULT_SIZE 32
class CommBuffer;

class Heap 
{
	private:
		struct Heap_Elem {
			double key1_;
			double key2_;
			Event *he_; 	
		} *helems;		
		
		unsigned int hsize_;
		unsigned int maxsize_;
		
		unsigned int	parent(unsigned int i)	{ return ((i - 1) / 2); }
		unsigned int	left(unsigned int i)	{ return ((i * 2) + 1); }
		unsigned int	right(unsigned int i)	{ return ((i * 2) + 2); }
		
		void swap(unsigned int i,unsigned int j)
		{
			Heap_Elem tmp = helems[i];
			helems[i] = helems[j];
			helems[j] = tmp;
		}
		
		int MIN_KEY(unsigned int i,unsigned int j)
		{
			return (helems[i].key1_ < helems[j].key1_) || ((helems[i].key1_ == helems[j].key1_) && (helems[i].key2_ < helems[j].key2_)); 
		}
		
		int MAX_KEY(unsigned int i,unsigned int j)
		{
			return (helems[i].key1_ > helems[j].key1_) || ((helems[i].key1_ == helems[j].key1_) && (helems[i].key2_ > helems[j].key2_));
		}

		void Heapify(unsigned int i);
		
	public:
		Heap();
		~Heap();
		Event *extract_first();
		double time_first() {return helems[0].key1_;};
		void insert(Event *);
		void print();
		int cancel(double);
		unsigned int getSize() {return hsize_;}
		void copy(CommBuffer *);
		Event *search(double uid);
		Event *head();
		int externOrder(Event *);
};

#include <stdio.h>

class HeapScheduler: public Scheduler
{
	protected :
		Heap *h_;
		FILE *fdebug;
	public:
		HeapScheduler() { h_= new Heap();}
		~HeapScheduler() {delete h_;}
		void run();
		void insert(Event *);
		void cancel(double);
		Event *deque();
		Event *head();
		
};

class ParScheduler: public HeapScheduler
{
	protected:
		Heap *hpar_;
		int idcluster_;
		int ncluster_;
	public:
		ParScheduler() {hpar_ = new Heap();}
		~ParScheduler(){delete hpar_;}
		void run();
		void cancel(double);
		Event *head();
		int Recv(CommBuffer *,int *);
		void Send(int cl,CommBuffer *);
		void stop(int cl);
};

class ParScheduler2: public ParScheduler
{
	public:
		void run();
}; 

