/*author Guastella Marco*/

#include <mpi.h>
#include <string.h>
#include <sys/time.h>
#include "Scheduler.h"
//#include <stdio.h>
#include "Pdnet.h"
#include <stdlib.h>
#include "Packet.h"
#include "CommBuffer.h"
#include "config.h"

Event::Event()
{
	pack_=0;
	input_=0;
	output_=0;
}
		

Event::~Event()
{
	if(pack_ != 0)
		Packet::free(pack_);
	if(input_ != 0)
	{
		input_->reset();
		delete input_;
		input_= 0;
	}
	if(output_ != 0)
	{
		output_->reset();
		delete output_;
		output_ = 0;
	}
}

Scheduler::Scheduler() 
{
	
		
}

void Scheduler::start(double tsimul)
{
	clock_=0.0;
	tclock_ = tsimul;
	run();
}



Heap::Heap()
{
	hsize_ = 0;
	maxsize_=HEAP_DEFAULT_SIZE;
	helems = new Heap_Elem[maxsize_];
	memset(helems,0,HEAP_DEFAULT_SIZE * sizeof(Heap_Elem));
}
		
Heap::~Heap()
{
	for(unsigned int i=0;i < hsize_;i++)
		delete helems[i].he_;
	delete [] helems;
}

void Heap::Heapify(unsigned int i)
{
	unsigned int min = i;
	unsigned int l = left(i);
	unsigned int r = right(i);
	if(l < hsize_ && MAX_KEY(min,l))
		min = l;
	if(r < hsize_ && MAX_KEY(min,r))
		min = r;
	if(min != i)
	{
		swap(i,min);
		Heapify(min);
	}
	print();
}

Event *Heap::extract_first()
{
	Event *e;
	if(hsize_ < 1)
		return 0;
	e = helems[0].he_;
	//printf("%d %d %f %f\n",e->cid_,e->sid_,e->time_,e->stime_);
	//printf("%f %f %d %d\n",helems[hsize_-1].key1_,helems[hsize_-1].key2_,helems[hsize_-1].key3_,helems[hsize_-1].key4_);
	helems[0] = helems[--hsize_];
	helems[hsize_].he_= 0;
	Heapify(0);
	return e;
}
		
void Heap::insert(Event *e)
{
	if(hsize_ == maxsize_)
	{
		Heap_Elem *tmp = helems;
		maxsize_ *= 2;
		helems = new Heap_Elem[maxsize_];
		memcpy(helems,tmp,hsize_*sizeof(Heap_Elem));
		memset(&helems[hsize_],0,((maxsize_- hsize_)*sizeof(Heap_Elem)));
		delete [] tmp;
	}
	unsigned int i = hsize_;
	unsigned int ipar = parent(i);
	helems[hsize_].key1_ = e->time_;
	helems[hsize_].key2_ = e->uid_;
	helems[hsize_++].he_ = e;
	while(i > 0 && MIN_KEY(i,ipar))
	{
		swap(ipar,i);
		i = ipar;
		ipar = parent(i);
	}  
}

int Heap::cancel(double uid)
{
	Event *e;
	for(unsigned int i=0;i<hsize_;i++)
	{
		e = helems[i].he_;
		if(e -> uid_ == uid)
		{
			helems[i] = helems[hsize_-1];
			helems[hsize_-1].he_= 0;
			hsize_--;
			Heapify(i);
			delete e;
			return 1;
		}
	}
	return 0;
}

void Heap::print()
{
	
}	

Event *Heap::head()
{
	if(hsize_ == 0)
		return 0;
	return helems[0].he_;
}

void Heap::copy(CommBuffer *c)
{
	c->pack(hsize_);
	for(unsigned int i=0;i<hsize_;i++)
	{
		Event *e = helems[i].he_;
		c->pack(e->cid_);
		c->pack(e->sid_);
		c->pack(e->time_);
		c->pack(e->type_);
		if(e-> pack_ == 0)
			c->pack(0,0);
		else
			c->pack((e->pack_)->getHdr(),(e->pack_)->hdrlen_);
		delete e;
	}
	hsize_=0;
}

Event *Heap::search(double uid)
{
	Event *e=0;
	for(unsigned int i=0;i<hsize_;i++)
	{
		if((helems[i].he_)->uid_ == uid)
		{
			e = helems[i].he_;
			break;
		}
	}
	return e;
}

int Heap::externOrder(Event *e)
{
	return (hsize_ == 0 ||(e->time_ < helems[0].key1_) || ((e->time_ == helems[0].key1_) && (e->uid_ < helems[0].key2_))); 
}

void HeapScheduler::run()
{
	Event *e;
	Pdnet &pd = Pdnet::instance();
	fdebug = fopen("ref.dbg","w+");
	int n = 0;
	while((e=deque()) != 0 && (clock_=e->time_) <= tclock_)
	{	
		n++;
		pd.exec(e);
	}
	fprintf(fdebug,"n eventi %d\n",n);
	fclose(fdebug);
	pd.stop();
}
		
void HeapScheduler::insert(Event *e)
{
	h_->insert(e);
	
}

Event *HeapScheduler::deque()
{
	if(h_->getSize() == 0)
		return 0;
	return h_->extract_first();
}

Event *HeapScheduler::head()
{
	return 0;
}

void HeapScheduler::cancel(double uid)
{
	h_->cancel(uid);
}

void ParScheduler::run()
{
	Pdnet &pd=Pdnet::instance();
	MPI_Comm_size(MPI_COMM_WORLD,&ncluster_);
	MPI_Comm_rank(MPI_COMM_WORLD,&idcluster_);
	char name[20];
	memset(name,'\0',20);
	sprintf(name,"%d.dbg",idcluster_);
	fdebug = fopen(name,"w+");
	double nevent=0;
	double nqueue = 0;
	double nqueue2 = 0;
	int pos=0;
	int neg=0;
	if(idcluster_ == 0)
	{
		/*cluster principale*/
		int rclust = ncluster_-1;//numero cluster remoti
		double veit[rclust];
		if(h_->getSize()==0)
		{
			/*se non ci sono eventi in coda esce*/
			for(int i=1;i<ncluster_;i++)
				stop(i);
			pd.stop();
			return;
		}	
		
		while(1)
		{
			//fprintf(fdebug,"nuovo ciclo\n");
			Event *e = head();
			/*se non ci sono pi eventi in coda esce dal ciclo*/
			if(e==0 && hpar_->getSize() == 0)
				break; 
			if(e != 0 && hpar_->externOrder(e))
			{
				/*Se l'evento da eseguire a tempo minore di quelli pendendi in coda hpar_ manda in parallelo l'esecuzione di eventi*/
				//fprintf(fdebug,"if esecuzione\n");
				clock_ = e->time_;
				if(clock_<=tclock_)
				{
					/*esegue il primo evento in coda  in base ai cluster e ai rimanenti
					  eventi li distribuisce nei vari cluster*/
					e=deque();
					int i=0;
					for(i=0;i<rclust;i++)
					{
						Event *e1 = head();
						if(e1 != 0 && e1->time_ <= tclock_ )
						{
							e1=deque();
							/*impacchetta un evento  l'aggiornamento del cid a cui
							appartiene e lo manda ad un federato*/
							CommBuffer *com = new CommBuffer();
							com->pack(e1->cid_);
							com->pack(e1->sid_);
							com->pack(e1->time_);
							com->pack(e1->type_);
							if(e1->pack_==0)
								com->pack(0);
							else
								com->pack((e1->pack_)->getHdr(),(e1->pack_)->hdrlen_);
							pd.supdate(e1->cid_,com);
							//fprintf(fdebug,"send cluster %d cid %d sid %d type %d uid %f time %f\n",i+1,e1->cid_,e1->sid_,e1->type_,e1->uid_,e1->time_);
							Send(i+1,com);
							veit[i] = e1->uid_;
							hpar_->insert(e1);
							e1->input_ = com;
						}
						else
							break;
					}
					
					//fprintf(fdebug,"exec cid %d sid %d type %d uid %f time  %f\n",e->cid_,e->sid_,e->type_,e->uid_,e->time_);
					nevent++;
					pd.exec(e);//esegue l'evento
					/*riceve le risposte dagli altri processi con i risultati degli 
					 eventi mandati*/
					for(int j=0;j<i;j++)
					{
						CommBuffer *com = new CommBuffer();
						Event *e1=0;
						int addr = -1;
						Recv(com,&addr);
						//fprintf(fdebug,"recv addr %d uid %f\n",addr,veit[addr-1]);
						e1 = hpar_-> search(veit[addr-1]);
						if(e1 != 0)
						{	
							//fprintf(fdebug,"find recv %d cid %d sid %d type %d uid %f time  %f\n",addr,e1->cid_,e1->sid_,e1->type_,e1->uid_,e1->time_);
							e1->output_=com;
						}
						else
						{
							/*questo  il caso in cui un evento viene cancellato 
							dalla lista da un evento precedente*/
							//fprintf(fdebug,"no found %d uid %f\n",addr,veit[addr-1]);
							com->reset();
							delete com;
						}
					}
				}
				else
					break;
				nqueue += h_->getSize();
				nqueue2 += hpar_->getSize();
			}
			else
			{
				/*ripristina risultati evento eseguito esternamente*/
				e = hpar_->extract_first();
				(e->input_)->unpack(&e->cid_);
				(e->input_)->unpack(&e->sid_);
				(e->input_)->unpack(&e->time_);
				(e->input_)->unpack(&e->type_);
				int p;
				(e->input_)->unpack(&p);
				if(p != 0)
					(e->input_)->unpack((e->pack_)->getHdr(),(e->pack_)->hdrlen_);
				
				//fprintf(fdebug,"if ripristino cid %d sid %d uid %f time %f\n",e->cid_,e->sid_,e->uid_,e->time_);
				/*controlla se le variabili modificate dall'evento eseguito in remoto
				sono state modificate da prima dell'esecuzione dell'evento*/
				clock_=e->time_;
				if(pd.control(e->cid_,e->input_,e->output_))
				{
					/*in questo caso ripristina lo stato dell'evento eseguito in remoto*/
					int size = 0;
					pos++;
					//fprintf(fdebug,"remote positiva cid %d sid %d type %d uid %f time %f\n",e->cid_,e->sid_,e->type_,e->uid_,e->time_);
					(e->output_)->unpack(&size);
					while(size > 0)
					{
						Event *e1=new Event();
						(e->output_)->unpack(&e1->cid_);
						(e->output_)->unpack(&e1->sid_);
						(e->output_)->unpack(&e1->time_);
						(e->output_)->unpack(&e1->type_);
						e1->uid_=pd.getUid();
						int p;
						(e->output_)->unpack(&p);
						if(p != 0)
						{	
							e1->pack_ = Packet::alloc();		
							(e->output_)->unpack((e1->pack_)->getHdr(),(e1->pack_)->hdrlen_);
						}
						insert(e1);
						size--;
					}
					/*(e->input_)->reset();
					e->input_= 0;
					(e->output_)->reset();
					e->output_= 0;
					delete e->input_;
					delete e->output_;*/
					delete e;
				}
				else
				{
					/*lo rimette nella coda di esecuzione*/
					//fprintf(fdebug,"remote negativa cid %d sid %d type %d uid %f time %f\n",e->cid_,e->sid_,e->type_,e->uid_,e->time_);
					neg++;
					(e->input_)->reset();
					(e->output_)->reset();
					delete (e->input_);
					e->input_= 0;
					delete (e->output_);
					e->output_ = 0;
					insert(e);
				}	
			}
		}
		for(int i=1;i<ncluster_;i++)
			stop(i);
		pd.stop();
		fprintf(fdebug,"dimenzione media code remota %f locale %f\n",nqueue2/nevent,nqueue/nevent);
		fprintf(fdebug,"positivi %d negativi %d\n",pos,neg);
	}
	else
	{
		Event *e;
		/*svuota la coda*/
		while((e=deque()))
			delete e;
		int flag = 0;
		CommBuffer com;
		do
		{
			/*riceve un evento aggiorna lo stato del sistema e lo rimanda i risultati al processo principale*/
			com.reset();
			int addr=-1;
			flag = Recv(&com,&addr);
			if(flag == 0)
			{
				/*spachetta l'evento */
				e = new Event();
				com.unpack(&e->cid_);
				int c = e->cid_;
				com.unpack(&e->sid_);
				com.unpack(&e->time_);
				com.unpack(&e->type_);
				e->uid_=pd.getUid();
				int p;
				com.unpack(&p);
				if(p != 0)
				{	
					e->pack_ = Packet::alloc();		
					com.unpack((e->pack_)->getHdr(),(e->pack_)->hdrlen_);
				}
				/*aggiorna le variabili che potrebbero interessare l'evento*/
				//fprintf(fdebug,"recv-remote cid %d sid %d type %d uid %f time %f\n",e->cid_,e->sid_,e->type_,e->uid_,e->time_);
				pd.rupdate(e->cid_,&com);
				clock_ = e->time_;
				nevent++;
				pd.exec(e);
				com.reset();
				pd.getUpdate(c,&com);
				h_->copy(&com);
				//fprintf(fdebug,"send response\n");
				Send(0,&com);
			}
		} 
		while(flag == 0);
	}
	//printf("%f\n",pd.getUid());
	fprintf(fdebug,"numero eventi eseguiti %f\n",nevent);
	fclose(fdebug);
}

void ParScheduler::cancel(double uid)
{
	if(h_->cancel(uid) == 0)
		hpar_->cancel(uid);
			
		
}

Event *ParScheduler::head()
{
	return h_->head();
}

int ParScheduler::Recv(CommBuffer *b,int *addr)
{
	MPI_Status status;
    	int msgsize,ret;
	if((ret=MPI_Probe(MPI_ANY_SOURCE, MPI_ANY_TAG, MPI_COMM_WORLD,&status)) != MPI_SUCCESS)
		MPI_Abort(MPI_COMM_WORLD,ret);
	if((ret=MPI_Get_count(&status, MPI_PACKED, &msgsize)) != MPI_SUCCESS)
		MPI_Abort(MPI_COMM_WORLD,ret);
	char str[msgsize];
	memset(str,'\0',msgsize);
	if((ret = MPI_Recv((void *)str,msgsize, MPI_PACKED, MPI_ANY_SOURCE, MPI_ANY_TAG, MPI_COMM_WORLD, &status)) != MPI_SUCCESS)
		MPI_Abort(MPI_COMM_WORLD,ret);
	b->setBuffer(str,msgsize);
	(*addr) = status.MPI_SOURCE;;
	return status.MPI_TAG;
}

void ParScheduler::Send(int cl,CommBuffer *com)
{	
	int ret;
	if((ret=MPI_Send((void *)com->getBuffer(),com->getBufferSize(), MPI_PACKED,cl,0, MPI_COMM_WORLD))	!= MPI_SUCCESS)
        	MPI_Abort(MPI_COMM_WORLD,ret);
}

void ParScheduler::stop(int cl)
{
	int ret;
	CommBuffer com;
	com.pack(cl);
	if((ret=MPI_Send((void *)com.getBuffer(),com.getBufferSize(), MPI_PACKED,cl,1, MPI_COMM_WORLD))	!= MPI_SUCCESS)
        	MPI_Abort(MPI_COMM_WORLD,ret);
}

void ParScheduler2::run()
{
	Pdnet &pd=Pdnet::instance();
	MPI_Comm_size(MPI_COMM_WORLD,&ncluster_);
	MPI_Comm_rank(MPI_COMM_WORLD,&idcluster_);
	char name[20];
	memset(name,'\0',20);
	sprintf(name,"%d.dbg",idcluster_);
	fdebug = fopen(name,"w+");
	double nevent=0;
	double nqueue = 0;
	double nqueue2 = 0;
	int pos=0;
	int neg=0;
	double **tab=pd.getRittab();
	double lookahead = tclock_;
	int tcont = pd.getTotContainer();
	for(int i=0;i<tcont;i++)
		for(int j=0;j<tcont;j++)
			if(i != j && tab[i][j] < lookahead)
				lookahead = tab[i][j];
	double interval = 0.0;
	if(idcluster_ == 0)
	{
		/*cluster principale*/
		int rclust = ncluster_-1;//numero cluster remoti
		double veit[rclust];
		if(h_->getSize()==0)
		{
			/*se non ci sono eventi in coda esce*/
			for(int i=1;i<ncluster_;i++)
				stop(i);
			pd.stop();
			return;
		}	
		
		while(1)
		{
			//fprintf(fdebug,"nuovo ciclo\n");
			Event *e = head();
			/*se non ci sono pi eventi in coda esce dal ciclo*/
			if(e==0 && hpar_->getSize() == 0)
				break; 
			if(e != 0 && hpar_->externOrder(e))
			{
				/*Se l'evento da eseguire a tempo minore di quelli pendendi in coda hpar_ manda in parallelo l'esecuzione di eventi*/
				//fprintf(fdebug,"if esecuzione\n");
				clock_ = e->time_;
				if(clock_<=tclock_)
				{
					/*esegue il primo evento in coda  in base ai cluster e ai rimanenti
					  eventi li distribuisce nei vari cluster*/
					e=deque();
					if (hpar_ -> getSize() > 0)
						interval = hpar_->  time_first();
					else
						interval = tclock_;
					int i=0;
					for(i=0;i<rclust;i++)
					{
						Event *e1 = head();
						if(e1 != 0 && e1->time_ <= tclock_ && e1->time_ <= interval )
						{
							e1=deque();
							/*impacchetta un evento  l'aggiornamento del cid a cui
							appartiene e lo manda ad un federato*/
							CommBuffer *com = new CommBuffer();
							com->pack(e1->cid_);
							com->pack(e1->sid_);
							com->pack(e1->time_);
							com->pack(e1->type_);
							if(e1->pack_==0)
								com->pack(0);
							else
								com->pack((e1->pack_)->getHdr(),(e1->pack_)->hdrlen_);
							pd.supdate(e1->cid_,com);
							//fprintf(fdebug,"send cluster %d cid %d sid %d type %d uid %f time %f\n",i+1,e1->cid_,e1->sid_,e1->type_,e1->uid_,e1->time_);
							Send(i+1,com);
							veit[i] = e1->uid_;
							hpar_->insert(e1);
							e1->input_ = com;
						}
						else
							break;
					}
					
					//fprintf(fdebug,"exec cid %d sid %d type %d uid %f time  %f\n",e->cid_,e->sid_,e->type_,e->uid_,e->time_);
					nevent++;
					pd.exec(e);//esegue l'evento
					/*riceve le risposte dagli altri processi con i risultati degli 
					 eventi mandati*/
					for(int j=0;j<i;j++)
					{
						CommBuffer *com = new CommBuffer();
						Event *e1=0;
						int addr = -1;
						Recv(com,&addr);
						//fprintf(fdebug,"recv addr %d uid %f\n",addr,veit[addr-1]);
						e1 = hpar_-> search(veit[addr-1]);
						if(e1 != 0)
						{	
							//fprintf(fdebug,"find recv %d cid %d sid %d type %d uid %f time  %f\n",addr,e1->cid_,e1->sid_,e1->type_,e1->uid_,e1->time_);
							e1->output_=com;
						}
						else
						{
							/*questo  il caso in cui un evento viene cancellato 
							dalla lista da un evento precedente*/
							//fprintf(fdebug,"no found %d uid %f\n",addr,veit[addr-1]);
							com->reset();
							delete com;
						}
					}
				}
				else
					break;
				nqueue += h_->getSize();
				nqueue2 += hpar_->getSize();
			}
			else
			{
				/*ripristina risultati evento eseguito esternamente*/
				e = hpar_->extract_first();
				(e->input_)->unpack(&e->cid_);
				(e->input_)->unpack(&e->sid_);
				(e->input_)->unpack(&e->time_);
				(e->input_)->unpack(&e->type_);
				int p;
				(e->input_)->unpack(&p);
				if(p != 0)
					(e->input_)->unpack((e->pack_)->getHdr(),(e->pack_)->hdrlen_);
				
				//fprintf(fdebug,"if ripristino cid %d sid %d uid %f time %f\n",e->cid_,e->sid_,e->uid_,e->time_);
				/*controlla se le variabili modificate dall'evento eseguito in remoto
				sono state modificate da prima dell'esecuzione dell'evento*/
				clock_=e->time_;
				if(pd.control(e->cid_,e->input_,e->output_))
				{
					/*in questo caso ripristina lo stato dell'evento eseguito in remoto*/
					int size = 0;
					pos++;
					//fprintf(fdebug,"remote positiva cid %d sid %d type %d uid %f time %f\n",e->cid_,e->sid_,e->type_,e->uid_,e->time_);
					(e->output_)->unpack(&size);
					while(size > 0)
					{
						Event *e1=new Event();
						(e->output_)->unpack(&e1->cid_);
						(e->output_)->unpack(&e1->sid_);
						(e->output_)->unpack(&e1->time_);
						(e->output_)->unpack(&e1->type_);
						e1->uid_=pd.getUid();
						int p;
						(e->output_)->unpack(&p);
						if(p != 0)
						{	
							e1->pack_ = Packet::alloc();		
							(e->output_)->unpack((e1->pack_)->getHdr(),(e1->pack_)->hdrlen_);
						}
						insert(e1);
						size--;
					}
					/*(e->input_)->reset();
					e->input_= 0;
					(e->output_)->reset();
					e->output_= 0;
					delete e->input_;
					delete e->output_;*/
					delete e;
				}
				else
				{
					/*lo rimette nella coda di esecuzione*/
					//fprintf(fdebug,"remote negativa cid %d sid %d type %d uid %f time %f\n",e->cid_,e->sid_,e->type_,e->uid_,e->time_);
					neg++;
					(e->input_)->reset();
					(e->output_)->reset();
					delete (e->input_);
					e->input_= 0;
					delete (e->output_);
					e->output_ = 0;
					insert(e);
				}	
			}
		}
		for(int i=1;i<ncluster_;i++)
			stop(i);
		pd.stop();
		fprintf(fdebug,"dimenzione media code remota %f locale %f\n",nqueue2/nevent,nqueue/nevent);
		fprintf(fdebug,"positivi %d negativi %d\n",pos,neg);
	}
	else
	{
		Event *e;
		/*svuota la coda*/
		while((e=deque()))
			delete e;
		int flag = 0;
		CommBuffer com;
		do
		{
			/*riceve un evento aggiorna lo stato del sistema e lo rimanda i risultati al processo principale*/
			com.reset();
			int addr=-1;
			flag = Recv(&com,&addr);
			if(flag == 0)
			{
				/*spachetta l'evento */
				e = new Event();
				com.unpack(&e->cid_);
				int c = e->cid_;
				com.unpack(&e->sid_);
				com.unpack(&e->time_);
				com.unpack(&e->type_);
				e->uid_=pd.getUid();
				int p;
				com.unpack(&p);
				if(p != 0)
				{	
					e->pack_ = Packet::alloc();		
					com.unpack((e->pack_)->getHdr(),(e->pack_)->hdrlen_);
				}
				/*aggiorna le variabili che potrebbero interessare l'evento*/
				//fprintf(fdebug,"recv-remote cid %d sid %d type %d uid %f time %f\n",e->cid_,e->sid_,e->type_,e->uid_,e->time_);
				pd.rupdate(e->cid_,&com);
				clock_ = e->time_;
				nevent++;
				pd.exec(e);
				com.reset();
				pd.getUpdate(c,&com);
				h_->copy(&com);
				//fprintf(fdebug,"send response\n");
				Send(0,&com);
			}
		} 
		while(flag == 0);
	}
	//printf("%f\n",pd.getUid());
	fprintf(fdebug,"numero eventi eseguiti %f\n",nevent);
	fclose(fdebug);
}

