/*author Guastella Marco*/

class Event;
class Object;
class CommBuffer;

class SObject
{
	protected:
		Object **table_;
		int tobj_;
		int sobj_;
		int addObject(Object *o);
		int update_;
	public:
		SObject();
		virtual ~SObject();
		virtual void handle(Event *)=0;
		virtual void recv(Event *)=0;
		virtual int type()=0;
		virtual void supdate(CommBuffer *) = 0;
		virtual void supdate2(CommBuffer *c){supdate(c);}
		virtual void rupdate(CommBuffer *) = 0;
		virtual void rupdate2(CommBuffer *c){rupdate(c);}
		int isUpdate() {return update_;}
		virtual int control(CommBuffer *) = 0;
		virtual void removeInput(CommBuffer *) = 0;
};

#define DEFAULT_MAX_TABLE 32

class routing: public SObject
{
	private:
		typedef struct rtable
		{
			int address;
			double time;
			int dindex;
		}RTABLE;
		
		typedef struct connection
		{
			int type;
			int daddr;
			int cid;
			int sid;
		}CONNECTION;
		
		int srtable_;
		int trtable_;
		RTABLE *rt_;
		int sconn_;
		int tconn_;
		CONNECTION *cn_;
		int nnet_;
	public:
		routing(int l);
		~routing();
		void handle(Event *);
		void recv(Event *);
		int type();
		int addRoute(int,double,int);
		int addConn(int,int,int,int);
		//void changeConn(int,int,int);
		void print(int);
		double getTime(int address,int *);
		void supdate(CommBuffer *);
		void rupdate(CommBuffer *);
		int control(CommBuffer *){return 1;}
		void removeInput(CommBuffer *){}
};

#define DEFAULT_MAX_PORT 32

class demux : public SObject
{
	private:
		int cid_;
		int *port_;
		int tport_;
		int sport_;
	public:
		demux(int);
		~demux();
		int addAgent(int);
		void handle(Event *);
		void recv(Event *);
		int type();
		void supdate(CommBuffer *);
		void rupdate(CommBuffer *);
		int control(CommBuffer *){return 1;}
		void removeInput(CommBuffer *){}
};

class netCard: public SObject
{
	private:
		int state_;
		int rcid_;
		int rsid_;
	public:
		netCard(int,int);
		~netCard();
		void handle(Event *);
		void recv(Event *);
		int type();
		void supdate(CommBuffer *);
		void rupdate(CommBuffer *);
		int control(CommBuffer *){return 1;}
		void removeInput(CommBuffer *){}
};


/*class Queue;
class LinkDelay;

class SimplexLink: public SObject
{
	private:
		unsigned int nlevel_;
		unsigned int *key_;
		unsigned int maxlevel_;
		Queue *queue_;
		LinkDelay *ld_;
	public:
		SimplexLink(double,double,int,int,int,int);
		~SimplexLink();
		void handle(Event *);
		void recv(Event *);
		int type();
		void addLevel(int);
		int getLevel(unsigned int **);
		int getDstCid();
		double bw();
		double delay();
		void supdate(CommBuffer *);
		void rupdate(CommBuffer *);
		int control(CommBuffer *){return 1;}
		void removeInput(CommBuffer *){}
};*/


class SimplexLink : public SObject
{
	private:
		unsigned int nlevel_;
		unsigned int *key_;
		unsigned int maxlevel_;
		/*per la coda*/ 
		int qmaxsize_;
		int qsize_;//per update
		double stime_;//tempo quando la coda pu mandare un messaggio update
		/*per update*/
		double bw_;
		double delay_;
		/*indirizzo locale*/
		int cid_;
		int sid_;
		/*indirizzo netcard corrispondente*/
		int dcid_;
		int dsid_;
	public:
		SimplexLink(double,double,int,int,int,int);
		~SimplexLink();
		void handle(Event *);
		void recv(Event *);
		int type();
		void addLevel(int);
		int getLevel(unsigned int **);
		int getDstCid();
		double bw();
		double delay();
		void setLocal(int c,int s);//cid e sid a cui appartiene
		void supdate(CommBuffer *);
		void rupdate(CommBuffer *);
		void qupdate(double,double);
		int control(CommBuffer *);
		void removeInput(CommBuffer *);
};

class Application;

class Agent : public SObject
{
	protected:
		Application *app_;		
		int address_;
		int raddress_;
		int port_;
		int dport_;
		int psize_;
		int cid_;
		int sid_;
		int rsid_;
	public:
		Agent();
		~Agent();
		void addApplication(Application *);
		int getAddress() {return address_;}
		void setAddress(int a) {address_ = a;}
		int getRAddress() {return raddress_;}
		void setRAddress(int a) {raddress_= a;} 
		int getPort() {return port_;}
		void setPort(int p) {port_=p;}
		int getRPort() {return dport_;}
		void setRPort(int p) {dport_=p;}
		int getPackSize() {return psize_;} 
		void setPackSize(int s);
		void setConnection(int,int,int);
		virtual void start() = 0;
		virtual void stop() = 0;
		virtual void handle(Event *)=0;
		virtual void recv(Event *)=0;
		virtual void setHeader()=0;
		virtual int type();
		virtual void printResult()=0;
		virtual void supdate(CommBuffer *)=0;
		virtual void rupdate(CommBuffer *)=0;
		virtual int control(CommBuffer *)= 0;
		virtual void removeInput(CommBuffer *)=0;
};

class UdpAgent: public Agent
{
	private:
		double interval_;
		int tpack_;
		int npack_;
		int state_;
	public:
		UdpAgent();
		~UdpAgent();
		void setInterval(double i) {interval_=i;}
		void setTotPack(int tp) {tpack_= tp;}
		void handle(Event *);
		void recv(Event *);
		void start();
		void stop();
		void setHeader();
		int type();
		void printResult();
		void supdate(CommBuffer *);
		void rupdate(CommBuffer *);
		int control(CommBuffer *);
		void removeInput(CommBuffer *);
};

class TcpAgent: public Agent
{
	private:
		int seq_;
		double rtt_;
		double mtime_;
		double crono_;
		double sdev_;
		double timeout_;
		int spack_;//pacchetti mandati
		int state_;
		int rack_;
		int rduplex_;
		double duid_;
		void setTimeout();
	public:
		TcpAgent();	
		~TcpAgent();
		void handle(Event *);
		void recv(Event *);
		void setHeader();
		void start();
		void stop();
		int type();
		void printResult();
		void sendPack(int,int,int);
		void timeout();
		void supdate(CommBuffer *);
		void supdate2(CommBuffer *);
		void rupdate(CommBuffer *);
		void rupdate2(CommBuffer *);
		int control(CommBuffer *);		
		void removeInput(CommBuffer *);
};

class TcpAgentListener : public Agent
{
	private:
		int ack_;
		int sack_;
		int rpack_;
		int duplex_;
		int state_;
	public:
		TcpAgentListener();
		~TcpAgentListener();
		void handle(Event *);
		void recv(Event *);
		void setHeader();
		void start();
		void stop();
		int type();
		void printResult();
		void sendPack(int,int,int);
		void supdate(CommBuffer *);
		void rupdate(CommBuffer *);
		int control(CommBuffer *);
		void removeInput(CommBuffer *);
};
