/*author Guastella Marco*/

#include <stdio.h>
#include <stdlib.h>
#include "SObject.h"
#include "Object.h"
#include "config.h"

#define MAX_OBJECT 32

SObject::SObject()
{
	tobj_= 0;
	sobj_= MAX_OBJECT;
	table_ = (Object **) malloc(sizeof(Object *)*sobj_);
	for(int i=0;i<sobj_;i++)
		table_[i] = 0;
	update_= 0;
}
		
SObject::~SObject()
{
	for(int i=0;i<sobj_;i++)
		delete table_[i];
	free(table_);
}

int SObject::addObject(Object *o)
{
	if(tobj_ == sobj_)
	{
		Object **tmp;
		tmp = table_;
		sobj_ += 20;
		table_ = (Object **) malloc(sizeof(Object *)*sobj_);
		for(int i=0; i < tobj_;i++)
			table_[i] = tmp[i]; 
		for(int i=tobj_;i<sobj_;i++)
			table_[i] = 0;	
		free(tmp);
	}
	table_[tobj_] = o;
	return tobj_++;
}
