/*author Guastella Marco*/

#include "Object.h"
#include "Scheduler.h"
#include "Packet.h"
#include <stdio.h>
#include "hdr.h"

#define QUEUE_NO_BLOCK 0
#define QUEUE_BLOCK 1
#define DEFAULT_MAX_SIZE 32

Queue::Queue()
{
	blocked_ = QUEUE_NO_BLOCK;
	maxsize_ = DEFAULT_MAX_SIZE;
	size_=0;
}

Queue::~Queue()
{

}

void Queue::recv(Event *e)
{
	if(blocked_ == QUEUE_NO_BLOCK)
	{	
		blocked_ = QUEUE_BLOCK;
		target_->recv(e);
	}
	else
	{
		if(size_ > maxsize_)
			dropTarget_->recv(e);
		else
		{
			size_++;
			enque(e->pack_);
			e->pack_= 0;
			delete e;
		}
	}
}

void Queue::send(Event *e)
{
	if(size_ == 0)
	{	
		blocked_ = QUEUE_NO_BLOCK;
		delete e;
	}
	else
	{
		size_--;
		e -> pack_ = deque();
		target_->recv(e);
	}
	
}
		
void Queue::setMaxSize(int s)
{
	maxsize_=s;
}

DropTail::~DropTail()
{
	tail_ = 0;
	while(head_ != 0)
	{
		Packet *tmp=head_;
		head_=tmp->next_;
		tmp->next_=0;
		head_->prev_ = 0;
		delete tmp;
	}
}
		
void DropTail::enque(Packet *p)
{
	
	if(head_ == 0)
	{
		head_ = p;
		head_->prev_ = 0;
		head_->next_ = 0;
		tail_ = head_;
	}
	else
	{
		p->next_ = head_;
		head_->prev_ = p;
		p->prev_ = 0;
		head_ = p; 
	}
}

Packet *DropTail::deque()
{
	Packet *p;
	if(tail_ == 0)
		return 0;
	if(tail_ == head_)
	{
		p = tail_;
		p -> next_ = 0;
		p -> prev_ = 0;
		tail_ = 0;
		head_ = 0;
	}
	else
	{
		p = tail_;
		tail_ = tail_ -> prev_;
		tail_ -> next_ = 0;
		p -> next_ = 0;
		p -> prev_ = 0;
	}	
	return p;
}


	
