/*author Guastella Marco*/

class Scheduler;
class container;
class Event;
class Agent;
class Application;

/*struttura per definire un riferimento ad un SObject*/
typedef struct sobj
{
	int cid;
	int sid;
}SOBJ;

/*struttura utilizzata per il routing*/
typedef struct linkTab
{
	int scid;
	int dcid;
	int sid;
	double time;
}LTAB;

class CommBuffer;



class Pdnet
{
	private:
		
		Pdnet();
		~Pdnet();
		double itime_;//tempo reale inizio simulazione
		double tsim_;//tempo virtuale di simulazione
		void topology();//esempi di topologie
		void topology2();
		Scheduler *s_;//scheduler
		static Pdnet *instance_;//istanza statica 
		container **table_;//lista contenitori(nodi)
		int tcont_;//numero di container assegnati
		int scont_;//size tabella container
		int addContainer(container *);//aggiunge un container alla tabella
		int exist(int c,int s);//verifica l'esistenza di un SObject
		void init_routing();//inizializza la tabella di routing
		/*registrazione applicazioni*/
		Agent **tbapp_;
		int tapp_;
		int sapp_;
		/*tabella dei ritardi dei vari nodi*/
		double **rittab;
		/*serve per associare un identificativo univoco ad un evento*/
		static double uid_;
	public:
		/*ritorna l'istanza di questa classe*/
		static Pdnet& instance() 
		{
			if(instance_ == 0)
				instance_ = new Pdnet();
			return (*instance_);
		}
		
		void init();//inizializza la simulazione
		void start();//inizia la simulazione
		void stop();//ci da i risultati della simulazione
		void schedType(char *);//cambia lo scheduler
		void simTime(double t); //inizializza il tempo di simulazione
		void schedule(Event *,int,int,double);//schedula un evento di routine
		void atSchedule(int,int,int,double);//schedula eventi iniziali
		void send(Event *,int,int);//manda un evento ad un SObject
		void exec(Event *);//esegue un evento
		int addNode();//crea un nodo
		double clock();//torna il tempo di simulazione
		SOBJ addSimplexLink(int,int,double,double,int,int);//crea un link semplice
		int addRoute(int n1,int n2,SOBJ l,double);//aggiunge un percorso alla tabella di routing del nodo n1 verso n2 attraverso il link l
		SOBJ attackAgent(int,Agent *);//attacca un agente ad un nodo e ritorna la coppia cid sid
		void connection(Agent *,Agent *);//setta i parametri di connessione tra due agenti
		void agentRegister(Agent *);//registra un agente nella tabella degli agenti per avere i risultati
		double getTime(int cid_,int address);//serve per trovare il minimo tempo stimato tra un nodo con relativo cid ed un nodo con indirizzo address
		void deleteEvent(double);//cancella dalla coda un evento con uid double
		int getTotContainer() {return tcont_;}//ritorna il numero totale di container
		double **getRittab() {return rittab;}//ritorna il puntatore alla tabella dei ritardi
		double getUid() {return uid_++;}//ritorna il prossimo uid
		void supdate(int,CommBuffer *);//aggiorna lo stato di un container
		void rupdate(int,CommBuffer *);//memorizza nel buffer lo stato di un container
		void getUpdate(int,CommBuffer *);//ottiene gli aggiornamenti del nodo rispetto allo stato precedente
		int control(int,CommBuffer *,CommBuffer *);//controlla se le variabili di input sono state modificate da altri eventi prima che siano state utilizzate da questo evento
};
