/*author Guastella Marco*/

#include <stdio.h>
#include <sys/time.h>
#include <string.h>
#include <stdlib.h>
#include "Pdnet.h"
#include "Scheduler.h"
#include "SObject.h"
#include "Object.h"
#include "Container.h"
#include "config.h"
#include <float.h>
#include "Packet.h"
#include <mpi.h>

Pdnet *Pdnet::instance_;
double Pdnet::uid_=0;
#define MAX_CONTAINER 32
#define MAX_AGENT 32

Pdnet::Pdnet() 
{
	tcont_= 0;
	scont_= MAX_CONTAINER;
	table_ = (container **) malloc(sizeof(container *)*scont_);
	for(int i=0;i<scont_;i++)
		table_[i] = 0;
	tsim_=-1.0;
	tapp_ = 0;
	sapp_ = MAX_AGENT;
	tbapp_ = (Agent **) malloc(sizeof(Agent *)*sapp_);
	s_=0;
}

Pdnet::~Pdnet() 
{
	for(int i=0;i<tcont_;i++)
		delete table_[i];
	free(table_);
	free(tbapp_);
	instance_=0;
}

int Pdnet::addContainer(container *c)
{
	if(tcont_ == scont_)
	{
		container **tmp;
		tmp = table_;
		scont_ *= 2;
		table_ = (container **) malloc(sizeof(container *)*scont_);
		for(int i=0; i < tcont_;i++)
			table_[i] = tmp[i]; 
		for(int i=tcont_;i<scont_;i++)
			table_[i] = 0;	
		free(tmp);
	}
	table_[tcont_] = c;
	return tcont_++;
}

int Pdnet::exist(int c,int s)
{
	if(c >= tcont_ || c < 0)
		return -1;
	return table_[c] -> exist(s);

}

#define INFINITY (DBL_MAX-1)/2

void Pdnet::init_routing()
{
	rittab = (double **)malloc(sizeof(double *)*tcont_);
	LTAB ltab[tcont_][tcont_];
	for(int i=0;i<tcont_;i++)
	{
		rittab[i] = (double *) malloc(sizeof(double) * tcont_);
		for(int j=0;j<tcont_;j++)
		{
			rittab[i][j] = INFINITY;
			ltab[i][j].time=0.0;
		}
	}	
	
	for(int i=0;i<tcont_;i++)
	{
		if(table_[i] -> type() == TYPE_NODE)
		{
			SObject **s;
			int nobject = table_[i] -> getStable(&s);
			for(int j=0;j<nobject;j++)
			{
				if(s[j] -> type() == TYPE_SIMPLEXLINK)
				{
					SimplexLink *sl = (SimplexLink *) s[j];
					int dcid = sl->getDstCid();
					double time = (8. * PKT_ROUTE / sl->bw())+sl->delay();
					if(ltab[i][dcid].time == 0.0) 
					{
						if(time > 0.0)
						{
							rittab[i][dcid]=time;
							ltab[i][dcid].scid=i;
							ltab[i][dcid].dcid=dcid;
							ltab[i][dcid].sid=j;
							ltab[i][dcid].time = time;
							
						}
					}
					else
					{
						if(time > 0.0 && time < ltab[i][j].time)
						{
							rittab[i][dcid]=time;
							ltab[i][dcid].scid=i;
							ltab[i][dcid].dcid=dcid;
							ltab[i][dcid].sid=j;
							ltab[i][dcid].time = time;
						}
					}
				}
			}
		}
	}
	/*algoritmo Floyd-Warshall*/
	for(int k=0;k<tcont_;k++)
	{	
		for(int i=0;i<tcont_;i++)
		{	
			for(int j=0;j<tcont_;j++)
			{
				double sum;
				if(i != j && (sum=rittab[i][k]+rittab[k][j]) < rittab[i][j])
				{
					rittab[i][j]=sum;
					ltab[i][j].scid = ltab[k][j].scid;	
					ltab[i][j].dcid = ltab[k][j].dcid;
					ltab[i][j].sid  = ltab[k][j].sid;
					ltab[i][j].time = ltab[k][j].time;
				}
			}
		}
	}
	for(int i=0;i<tcont_;i++)
	{
		for(int j=0;j<tcont_;j++)
		{
			if(rittab[i][j] != INFINITY)
			{
				SOBJ l;
				int k = j;
				while(ltab[i][k].scid != i)
					k = ltab[i][k].scid;
				l.cid = i;
				l.sid = ltab[i][k].sid;
				addRoute(i,j,l,rittab[i][j]);
			}
		}
	}
	
	/*for(int i=0;i<tcont_;i++)
	{	
		if(table_[i] -> type() == TYPE_NODE)
		{
			Node *n = (Node *)table_[i];
			n->print();
		}

	}*/
}

void Pdnet::init()
{
	struct timeval tv;
	gettimeofday(&tv,0);
	itime_ = (double)tv.tv_sec + (0.000001*((double)tv.tv_usec));
	s_ = new HeapScheduler();
	PacketMenager::init();
}
		
void Pdnet::start()
{
	topology();	
	//topology2();
	init_routing();
	s_-> start(tsim_);
}
		
void Pdnet::stop()
{
	for(int i=0;i<tapp_;i++)
		tbapp_[i]-> printResult();
	struct timeval tv;
	gettimeofday(&tv,0);
	double otime = (double)tv.tv_sec + (0.000001*((double)tv.tv_usec)) - itime_;
	printf("\nSimulation time %f\n",otime); 
}


void Pdnet::schedType(char *t)
{
	if(s_!=0)
		delete s_;
	if(strcmp("heap",t) == 0)
	{	
		s_ = new HeapScheduler();
	}
	else if(strcmp("Parheap",t) == 0)
	{
		s_ = new ParScheduler();
	}
	else if(strcmp("Parheap2",t) == 0)
	{
		s_ = new ParScheduler2();
	}
}

void Pdnet::simTime(double t)
{
	tsim_=t;
}
 
void Pdnet::schedule(Event *e,int cid,int sid,double delay)
{
	if(delay < 0)
	{
		printf("schedule negative time %f cid %d sid %d\n",delay,cid,sid);
		exit(-1);
	}
	if(exist(cid,sid) == -1)
	{
		printf("schedule not exist Object %d %d\n",cid,sid);
		exit(-1);
	}
	e -> cid_ = cid;
	e -> sid_ = sid;
	e -> time_ = clock() + delay;
	e -> type_ = EVENTHANDLE;
	e -> uid_ = uid_++;
	s_-> insert(e);
}

void Pdnet::atSchedule(int cid,int sid,int ty,double delay)
{
	if(delay < 0)
	{
		printf("schedule negative time %f\n",delay);
		exit(-1);
	}
	if(exist(cid,sid) == -1)
	{
		printf("schedule not exist Object %d %d\n",cid,sid);
		exit(-1);
	}
	Event *e = new Event();
	e -> cid_ = cid;
	e -> sid_ = sid;
	e -> time_ = clock() + delay;
	e -> type_ = ty;
	e -> uid_ = uid_++;
	s_-> insert(e);
}

void Pdnet::deleteEvent(double uid)
{
	s_ -> cancel(uid);
}

double Pdnet::clock()
{
	return s_->clock();
}

void Pdnet::send(Event *e,int cid,int sid)
{
	if(exist(cid,sid) == -1)
	{
		printf("send not Object exist %d %d\n",cid,sid);
		exit(-1);
	}
	e -> cid_ = cid;
	e -> sid_ = sid;
	table_[e->cid_] -> recv(e);
}

#include <unistd.h>
#include <time.h>

void Pdnet::exec(Event *e)
{
	//sleep(0.0000000100);
	//struct timespec req;
	//req.tv_sec = 0;
	//req.tv_nsec = 1000;
	//nanosleep(&req,NULL);
	//printf("gdggd %d\n",req.tv_nsec);
	//usleep(20);
	if(e->time_ != s_->clock())
	{
		printf("exec no time valid time %f clock %f\n",e->time_,s_-> clock());
		exit (-1);
	}
	 table_[e->cid_] -> handle(e);	
}


int Pdnet::addNode()
{
	Node *n=new Node();
	int c = addContainer(n);
	n->setAddress(c);
	n->setCid(c);
	n->addDemux();
	return c;
}

SOBJ Pdnet::addSimplexLink(int src,int dst,double bw,double delay,int qtype,int qsize)
{
	SOBJ s;
	s.cid = src;
	Node *nsrc = (Node *) table_[src];
	Node *ndst = (Node *) table_[dst];
	int snet = ndst -> addNetCard();
	s.sid=nsrc->addSimplexLink(bw,delay,qtype,qsize,dst,snet,ndst->getAddress());
	return s;
}

SOBJ Pdnet::attackAgent(int n0,Agent *a)
{
	SOBJ s;
	s.cid = n0;
	Node *n = (Node *) table_[n0];
	s.sid = n -> addAgent(a);
	return s;
}
		
void Pdnet::connection(Agent *s,Agent *r)
{
	if(s->type() == TYPE_AGENTUDP && r->type() == TYPE_AGENTUDP)
	{
		s -> setRAddress(r->getAddress());
		s -> setRPort(r->getPort());
		r -> setRAddress(s->getAddress());
		r -> setRPort(s->getPort());
	}
	else if(s->type() == TYPE_AGENTTCP && r -> type() == TYPE_AGENTTCPLISTENER)
	{
		s -> setRAddress(r->getAddress());
		s -> setRPort(r->getPort());
		r -> setRAddress(s->getAddress());
		r -> setRPort(s->getPort());
	}
	else
	{	
		printf("impossible connect (%d,%d) (%d,%d)\n",s->getAddress(),s->getPort(),r->getAddress(),r->getPort());
		exit (-1);
	}
}

void Pdnet::agentRegister(Agent *a)
{
	if(tapp_ == sapp_)
	{
		Agent **tmp;
		tmp = tbapp_;
		sapp_ *= 2;
		tbapp_ = (Agent **) malloc(sizeof(Agent *)*sapp_);
		for(int i=0; i < tcont_;i++)
			tbapp_[i] = tmp[i]; 
		for(int i=tcont_;i<scont_;i++)
			tbapp_[i] = 0;	
		free(tmp);
	}
	tbapp_[tapp_++] = a;
}

int Pdnet::addRoute(int n1,int n2,SOBJ l,double t)
{
	if(n1 != l.cid && table_[n1] -> type() != TYPE_NODE && table_[n2] -> type() != TYPE_NODE)
		return -1;	
	Node *src = (Node *) table_[n1];
	Node *dst = (Node *) table_[n2];
	return (src->addRoute(dst->getAddress(),l.sid,t));
}

double Pdnet::getTime(int cid_,int address)
{
	Node *n = (Node *) table_[cid_];
	return n->getTime(address);
}

void Pdnet::supdate(int c,CommBuffer *com)
{
	table_[c]->supdate(com);
}
		
void Pdnet::rupdate(int c,CommBuffer *com)
{
	table_[c]->rupdate(com);
}

void Pdnet::getUpdate(int c,CommBuffer *com)
{
	table_[c]->getUpdate(com);
}

int Pdnet::control(int c,CommBuffer *input,CommBuffer *output)
{
	return table_[c] -> controlUpdate(input,output);
}

void Pdnet::topology()
{
	//schedType("Parheap");	
	//schedType("heap");
	schedType("Parheap2");
	int n0 = addNode();
	int n1 = addNode();
	int n2 = addNode();
	int n3 = addNode();
	int n4 = addNode();
	int n5 = addNode();
	int n6 = addNode();
	int n7 = addNode();
	int n8 = addNode();
	int n9 = addNode();
	int n10 = addNode();
	int n11 = addNode();
	int n12 = addNode();
	SOBJ link01 = addSimplexLink(n0,n1,1000000,0.005,DROPTAIL,100);
	SOBJ link10 = addSimplexLink(n1,n0,1000000,0.005,DROPTAIL,100);
	SOBJ link21 = addSimplexLink(n2,n1,1000000,0.005,DROPTAIL,100);
	SOBJ link12 = addSimplexLink(n1,n2,1000000,0.005,DROPTAIL,100);
	SOBJ link02 = addSimplexLink(n0,n2,2000000,0.005,DROPTAIL,100);
	SOBJ link20 = addSimplexLink(n2,n0,2000000,0.005,DROPTAIL,100);
	SOBJ link15 = addSimplexLink(n1,n5,1000000,0.005,DROPTAIL,100);
	SOBJ link51 = addSimplexLink(n5,n1,1000000,0.005,DROPTAIL,100);
	SOBJ link06 = addSimplexLink(n0,n6,500000,0.005,DROPTAIL,100);
	SOBJ link60 = addSimplexLink(n6,n0,500000,0.005,DROPTAIL,100);
	SOBJ link07 = addSimplexLink(n0,n7,500000,0.005,DROPTAIL,100);
	SOBJ link70 = addSimplexLink(n7,n0,500000,0.005,DROPTAIL,100);
	SOBJ link18 = addSimplexLink(n1,n8,700000,0.004,DROPTAIL,100);
	SOBJ link81 = addSimplexLink(n8,n1,700000,0.004,DROPTAIL,100);
	SOBJ link59 = addSimplexLink(n5,n9,1000000,0.006,DROPTAIL,100);
	SOBJ link95 = addSimplexLink(n9,n5,1000000,0.006,DROPTAIL,100);
	SOBJ link510 = addSimplexLink(n5,n10,1000000,0.006,DROPTAIL,100);
	SOBJ link105 = addSimplexLink(n10,n5,1000000,0.006,DROPTAIL,100);
	SOBJ link23 = addSimplexLink(n2,n3,2000000,0.005,DROPTAIL,100);
	SOBJ link32 = addSimplexLink(n3,n2,2000000,0.005,DROPTAIL,100);
	SOBJ link312 = addSimplexLink(n3,n12,1500000,0.004,DROPTAIL,100);
	SOBJ link123 = addSimplexLink(n12,n3,1500000,0.004,DROPTAIL,100);
	SOBJ link311 = addSimplexLink(n3,n11,800000,0.003,DROPTAIL,100);
	SOBJ link113 = addSimplexLink(n11,n3,800000,0.003,DROPTAIL,100);
	SOBJ link34 = addSimplexLink(n3,n4,800000,0.006,DROPTAIL,100);
	SOBJ link43 = addSimplexLink(n4,n3,800000,0.006,DROPTAIL,100);
	
	UdpAgent *agent1 = new UdpAgent();
	UdpAgent *agent2 = new UdpAgent();
	agent1 -> setPackSize(400);
	agent1 -> setInterval(0.007);
	countApplication *c1 = new countApplication("agent1");
	countApplication *c2 = new countApplication("agent2");
	agent1 -> addApplication(c1);
	agent2 -> addApplication(c2);
	SOBJ a1 = attackAgent(n6,agent1);
	SOBJ a2 = attackAgent(n8,agent2);
	connection(agent1,agent2);
	atSchedule(a1.cid,a1.sid,EVENTSTART,0.0);
	atSchedule(a1.cid,a1.sid,EVENTSTOP,1000.0);
		
	UdpAgent *agent3 = new UdpAgent();
	UdpAgent *agent4 = new UdpAgent();
	agent3 -> setPackSize(200);
	agent3 -> setInterval(0.008);
	countApplication *c3 = new countApplication("agent3");
	countApplication *c4 = new countApplication("agent4");
	agent3 -> addApplication(c3);
	agent4 -> addApplication(c4);
	SOBJ a3 = attackAgent(n7,agent3);
	SOBJ a4 = attackAgent(n11,agent4);
	connection(agent3,agent4);
	atSchedule(a3.cid,a3.sid,EVENTSTART,0.0);
	atSchedule(a3.cid,a3.sid,EVENTSTOP,1000.0);
	
	UdpAgent *agent5 = new UdpAgent();
	UdpAgent *agent6 = new UdpAgent();
	agent5 -> setPackSize(100);
	agent5 -> setInterval(0.001);
	countApplication *c5 = new countApplication("agent5");
	countApplication *c6 = new countApplication("agent6");
	agent5 -> addApplication(c5);
	agent6 -> addApplication(c6);
	SOBJ a5 = attackAgent(n9,agent5);
	SOBJ a6 = attackAgent(n12,agent6);
	connection(agent5,agent6);
	atSchedule(a5.cid,a5.sid,EVENTSTART,0.0);
	atSchedule(a5.cid,a5.sid,EVENTSTOP,1000.0);
	
	UdpAgent *agent7 = new UdpAgent();
	UdpAgent *agent8 = new UdpAgent();
	agent7 -> setPackSize(120);
	agent7 -> setInterval(0.005);
	countApplication *c7 = new countApplication("agent7");
	countApplication *c8 = new countApplication("agent8");
	agent7 -> addApplication(c7);
	agent8 -> addApplication(c8);
	SOBJ a7 = attackAgent(n4,agent7);
	SOBJ a8 = attackAgent(n10,agent8);
	connection(agent7,agent8);
	atSchedule(a7.cid,a7.sid,EVENTSTART,0.0);
	atSchedule(a7.cid,a7.sid,EVENTSTOP,1000.0);
	
	UdpAgent *agent9 = new UdpAgent();
	UdpAgent *agent10 = new UdpAgent();
	agent9 -> setPackSize(200);
	agent9 -> setInterval(0.001);
	countApplication *c9 = new countApplication("agent9");
	countApplication *c10 = new countApplication("agent10");
	agent9 -> addApplication(c9);
	agent10 -> addApplication(c10);
	SOBJ a9 = attackAgent(n11,agent9);
	SOBJ a10 = attackAgent(n12,agent10);
	connection(agent9,agent10);
	atSchedule(a9.cid,a9.sid,EVENTSTART,0.0);
	atSchedule(a9.cid,a9.sid,EVENTSTOP,1000.0);

	UdpAgent *agent11 = new UdpAgent();
	UdpAgent *agent12 = new UdpAgent();
	agent11 -> setPackSize(200);
	agent11 -> setInterval(0.004);
	countApplication *c11 = new countApplication("agent11");
	countApplication *c12 = new countApplication("agent12");
	agent11 -> addApplication(c11);
	agent12 -> addApplication(c12);
	SOBJ a11 = attackAgent(n10,agent11);
	SOBJ a12 = attackAgent(n7,agent12);
	connection(agent11,agent12);
	atSchedule(a11.cid,a11.sid,EVENTSTART,0.0);
	atSchedule(a11.cid,a11.sid,EVENTSTOP,1000.0);



	/*TcpAgent *tcp1 = new TcpAgent();
	TcpAgentListener *tcpl1 = new TcpAgentListener();
	SOBJ tagent1 = attackAgent(n4,tcp1);
	attackAgent(n10,tcpl1);
	connection(tcp1,tcpl1);
	atSchedule(tagent1.cid,tagent1.sid,EVENTSTART,0.0); 
	atSchedule(tagent1.cid,tagent1.sid,EVENTSTOP,100.0);
	
	TcpAgent *tcp2 = new TcpAgent();
	TcpAgentListener *tcpl2 = new TcpAgentListener();
	SOBJ tagent2 = attackAgent(n11,tcp2);
	attackAgent(n12,tcpl2);
	connection(tcp2,tcpl2);
	atSchedule(tagent2.cid,tagent2.sid,EVENTSTART,0.0); 
	atSchedule(tagent2.cid,tagent2.sid,EVENTSTOP,100.0);
	
	TcpAgent *tcp3 = new TcpAgent();
	TcpAgentListener *tcpl3 = new TcpAgentListener();
	SOBJ tagent3 = attackAgent(n10,tcp3);
	attackAgent(n7,tcpl3);
	connection(tcp3,tcpl3);
	atSchedule(tagent3.cid,tagent3.sid,EVENTSTART,0.0); 
	atSchedule(tagent3.cid,tagent3.sid,EVENTSTOP,100.0);*/
	
	simTime(100.0);
}

void Pdnet::topology2()
{
	schedType("Parheap");
	//schedType("heap");
	int n0 = addNode();
	int n1 = addNode();
	int n2 = addNode();
	int n3 = addNode();
	int n4 = addNode();
	int n5 = addNode();
	int n6 = addNode();
	int n7 = addNode();
	int n8 = addNode();
	int n9 = addNode();
	int n10 = addNode();
	int n11 = addNode();
	int n12 = addNode();
	int n13 = addNode();
	int n14 = addNode();
	int n15 = addNode();
	int n16 = addNode();
	int n17 = addNode();
	int n18 = addNode();
	int n19 = addNode();
	int n20 = addNode();
	int n21 = addNode();
	int n22 = addNode();
	int n23 = addNode();
	int n24 = addNode();
	int n25 = addNode();
	int n26 = addNode();
	int n27 = addNode();
	int n28 = addNode();
	int n29 = addNode();
	int n30 = addNode();
	int n31 = addNode();
	int n32 = addNode();
	int n33 = addNode();
	addSimplexLink(n0,n3,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n3,n0,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n1,n3,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n3,n1,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n2,n3,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n3,n2,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n4,n7,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n7,n4,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n5,n7,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n7,n5,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n6,n7,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n7,n6,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n8,n11,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n11,n8,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n9,n11,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n11,n9,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n10,n11,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n11,n10,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n12,n15,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n15,n12,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n13,n15,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n15,n13,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n14,n15,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n15,n14,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n3,n16,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n16,n3,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n7,n16,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n16,n7,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n11,n16,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n16,n11,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n15,n16,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n16,n15,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n17,n20,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n20,n17,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n18,n20,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n20,n18,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n19,n20,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n20,n19,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n21,n24,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n24,n21,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n22,n24,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n24,n22,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n23,n24,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n24,n23,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n25,n28,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n28,n25,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n26,n28,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n28,n26,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n27,n28,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n28,n27,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n29,n32,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n32,n29,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n30,n32,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n32,n30,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n31,n32,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n32,n31,1000000,0.005,DROPTAIL,100);
	addSimplexLink(n20,n33,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n33,n20,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n24,n33,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n33,n24,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n28,n33,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n33,n28,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n33,n32,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n32,n33,2000000,0.008,DROPTAIL,100);
	addSimplexLink(n33,n16,3000000,0.009,DROPTAIL,100);
	addSimplexLink(n16,n33,2000000,0.008,DROPTAIL,100);
	
	UdpAgent *a1 = new UdpAgent();
	UdpAgent *a2 = new UdpAgent();
	a1 -> setPackSize(200);
	a1 -> setInterval(0.002);
	a2 -> setPackSize(100);
	a2 -> setInterval(0.004);
	countApplication *c1 = new countApplication("agent1");
	countApplication *c2 = new countApplication("agent2");
	a1 -> addApplication(c1);
	a2 -> addApplication(c2);
	SOBJ o1 = attackAgent(n0,a1);
	SOBJ o2 = attackAgent(n17,a2);
	connection(a1,a2);
	atSchedule(o1.cid,o1.sid,EVENTSTART,0.0);
	//atSchedule(o2.cid,o2.sid,EVENTSTART,0.0);
	
	UdpAgent *a3 = new UdpAgent();
	UdpAgent *a4 = new UdpAgent();
	a3 -> setPackSize(200);
	a3 -> setInterval(0.002);
	a4 ->setPackSize(100);
	a4 -> setInterval(0.004);
	countApplication *c3 = new countApplication("agent3");
	countApplication *c4 = new countApplication("agent4");
	a3 -> addApplication(c3);
	a4 -> addApplication(c4);
	SOBJ o3 = attackAgent(n0,a3);
	SOBJ o4 = attackAgent(n2,a4);
	connection(a3,a4);
	//atSchedule(o3.cid,o3.sid,EVENTSTART,0.0);
	atSchedule(o4.cid,o4.sid,EVENTSTART,0.0);

	UdpAgent *a5 = new UdpAgent();
	UdpAgent *a6 = new UdpAgent();
	a5 -> setPackSize(200);
	a5 -> setInterval(0.002);
	a6 ->setPackSize(100);
	a6 -> setInterval(0.004);
	countApplication *c5 = new countApplication("agent5");
	countApplication *c6 = new countApplication("agent6");
	a5 -> addApplication(c5);
	a6 -> addApplication(c6);
	SOBJ o5 = attackAgent(n0,a5);
	SOBJ o6 = attackAgent(n8,a6);
	connection(a5,a6);
	//atSchedule(o5.cid,o5.sid,EVENTSTART,0.0);
	atSchedule(o6.cid,o6.sid,EVENTSTART,0.0);
	
	UdpAgent *a7 = new UdpAgent();
	UdpAgent *a8 = new UdpAgent();
	a7 -> setPackSize(200);
	a7 -> setInterval(0.002);
	a8 ->setPackSize(100);
	a8 -> setInterval(0.004);
	countApplication *c7 = new countApplication("agent7");
	countApplication *c8 = new countApplication("agent8");
	a7 -> addApplication(c7);
	a8 -> addApplication(c8);
	SOBJ o7 = attackAgent(n1,a7);
	SOBJ o8 = attackAgent(n9,a8);
	connection(a7,a8);
	atSchedule(o7.cid,o7.sid,EVENTSTART,0.0);
	//atSchedule(o8.cid,o8.sid,EVENTSTART,0.0);
	
	UdpAgent *a9 = new UdpAgent();
	UdpAgent *a10 = new UdpAgent();
	a9 -> setPackSize(200);
	a9 -> setInterval(0.002);
	a10 ->setPackSize(100);
	a10 -> setInterval(0.004);
	countApplication *c9 = new countApplication("agent9");
	countApplication *c10 = new countApplication("agent10");
	a9 -> addApplication(c9);
	a10 -> addApplication(c10);
	SOBJ o9 = attackAgent(n8,a9);
	SOBJ o10 = attackAgent(n25,a10);
	connection(a9,a10);
	//atSchedule(o9.cid,o9.sid,EVENTSTART,0.0);
	atSchedule(o10.cid,o10.sid,EVENTSTART,0.0);

	UdpAgent *a11 = new UdpAgent();
	UdpAgent *a12 = new UdpAgent();
	a11 -> setPackSize(200);
	a11 -> setInterval(0.002);
	a12 ->setPackSize(100);
	a12 -> setInterval(0.004);
	countApplication *c11 = new countApplication("agent11");
	countApplication *c12 = new countApplication("agent12");
	a11 -> addApplication(c11);
	a12 -> addApplication(c12);
	SOBJ o11 = attackAgent(n8,a11);
	SOBJ o12 = attackAgent(n10,a12);
	connection(a11,a12);
	//atSchedule(o11.cid,o11.sid,EVENTSTART,0.0);
	atSchedule(o12.cid,o12.sid,EVENTSTART,0.0);

	UdpAgent *a13 = new UdpAgent();
	UdpAgent *a14 = new UdpAgent();
	a13 -> setPackSize(200);
	a13 -> setInterval(0.002);
	a14 ->setPackSize(100);
	a14 -> setInterval(0.004);
	countApplication *c13 = new countApplication("agent13");
	countApplication *c14 = new countApplication("agent14");
	a13 -> addApplication(c13);
	a14 -> addApplication(c14);
	SOBJ o13 = attackAgent(n4,a13);
	SOBJ o14 = attackAgent(n21,a14);
	connection(a13,a14);
	atSchedule(o13.cid,o13.sid,EVENTSTART,0.0);
	//atSchedule(o14.cid,o14.sid,EVENTSTART,0.0);
	
	UdpAgent *a15 = new UdpAgent();
	UdpAgent *a16 = new UdpAgent();
	a15 -> setPackSize(200);
	a15 -> setInterval(0.002);
	a16 ->setPackSize(100);
	a16 -> setInterval(0.004);
	countApplication *c15 = new countApplication("agent15");
	countApplication *c16 = new countApplication("agent16");
	a15 -> addApplication(c15);
	a16 -> addApplication(c16);
	SOBJ o15 = attackAgent(n4,a15);
	SOBJ o16 = attackAgent(n6,a16);
	connection(a15,a16);
	//atSchedule(o15.cid,o15.sid,EVENTSTART,0.0);
	atSchedule(o16.cid,o16.sid,EVENTSTART,0.0);
	
	UdpAgent *a17 = new UdpAgent();
	UdpAgent *a18 = new UdpAgent();
	a17 -> setPackSize(200);
	a17 -> setInterval(0.002);
	a18 ->setPackSize(100);
	a18 -> setInterval(0.004);
	countApplication *c17 = new countApplication("agent17");
	countApplication *c18 = new countApplication("agent18");
	a17 -> addApplication(c17);
	a18 -> addApplication(c18);
	SOBJ o17 = attackAgent(n5,a17);
	SOBJ o18 = attackAgent(n13,a18);
	connection(a17,a18);
	atSchedule(o17.cid,o17.sid,EVENTSTART,0.0);
	//atSchedule(o18.cid,o18.sid,EVENTSTART,0.0);
	
	UdpAgent *a19 = new UdpAgent();
	UdpAgent *a20 = new UdpAgent();
	a19 -> setPackSize(200);
	a19 -> setInterval(0.002);
	a20 ->setPackSize(100);
	a20 -> setInterval(0.004);
	countApplication *c19 = new countApplication("agent19");
	countApplication *c20 = new countApplication("agent20");
	a19 -> addApplication(c19);
	a20 -> addApplication(c20);
	SOBJ o19 = attackAgent(n4,a19);
	SOBJ o20 = attackAgent(n12,a20);
	connection(a19,a20);
	atSchedule(o19.cid,o19.sid,EVENTSTART,0.0);
	//atSchedule(o20.cid,o20.sid,EVENTSTART,0.0);
	
	UdpAgent *a21 = new UdpAgent();
	UdpAgent *a22 = new UdpAgent();
	a21 -> setPackSize(200);
	a21 -> setInterval(0.002);
	a22 ->setPackSize(100);
	a22 -> setInterval(0.004);
	countApplication *c21 = new countApplication("agent21");
	countApplication *c22 = new countApplication("agent22");
	a21 -> addApplication(c21);
	a22 -> addApplication(c22);
	SOBJ o21 = attackAgent(n12,a21);
	SOBJ o22 = attackAgent(n14,a22);
	connection(a21,a22);
	atSchedule(o21.cid,o21.sid,EVENTSTART,0.0);
	//atSchedule(o22.cid,o22.sid,EVENTSTART,0.0);
	
	UdpAgent *a23 = new UdpAgent();
	UdpAgent *a24 = new UdpAgent();
	a23 -> setPackSize(200);
	a23 -> setInterval(0.002);
	a24 ->setPackSize(100);
	a24 -> setInterval(0.004);
	countApplication *c23 = new countApplication("agent23");
	countApplication *c24 = new countApplication("agent24");
	a23 -> addApplication(c23);
	a24 -> addApplication(c24);
	SOBJ o23 = attackAgent(n12,a23);
	SOBJ o24 = attackAgent(n29,a24);
	connection(a23,a24);
	//atSchedule(o23.cid,o23.sid,EVENTSTART,0.0);
	atSchedule(o24.cid,o24.sid,EVENTSTART,0.0);
	
	UdpAgent *a25 = new UdpAgent();
	UdpAgent *a26 = new UdpAgent();
	a25 -> setPackSize(200);
	a25 -> setInterval(0.002);
	a26 ->setPackSize(100);
	a26 -> setInterval(0.004);
	countApplication *c25 = new countApplication("agent25");
	countApplication *c26 = new countApplication("agent26");
	a25 -> addApplication(c25);
	a26 -> addApplication(c26);
	SOBJ o25 = attackAgent(n17,a25);
	SOBJ o26 = attackAgent(n19,a26);
	connection(a25,a26);
	atSchedule(o25.cid,o25.sid,EVENTSTART,0.0);
	//atSchedule(o26.cid,o26.sid,EVENTSTART,0.0);
	
	UdpAgent *a27 = new UdpAgent();
	UdpAgent *a28 = new UdpAgent();
	a27 -> setPackSize(200);
	a27 -> setInterval(0.002);
	a28 ->setPackSize(100);
	a28 -> setInterval(0.004);
	countApplication *c27 = new countApplication("agent27");
	countApplication *c28 = new countApplication("agent28");
	a27 -> addApplication(c27);
	a28 -> addApplication(c28);
	SOBJ o27 = attackAgent(n18,a27);
	SOBJ o28 = attackAgent(n26,a28);
	connection(a27,a28);
	atSchedule(o27.cid,o27.sid,EVENTSTART,0.0);
	//atSchedule(o28.cid,o28.sid,EVENTSTART,0.0);
	
	UdpAgent *a29 = new UdpAgent();
	UdpAgent *a30 = new UdpAgent();
	a29 -> setPackSize(200);
	a29 -> setInterval(0.002);
	a30 ->setPackSize(100);
	a30 -> setInterval(0.004);
	countApplication *c29 = new countApplication("agent29");
	countApplication *c30 = new countApplication("agent30");
	a29 -> addApplication(c29);
	a30 -> addApplication(c30);
	SOBJ o29 = attackAgent(n25,a29);
	SOBJ o30 = attackAgent(n27,a30);
	connection(a29,a30);
	//atSchedule(o29.cid,o29.sid,EVENTSTART,0.0);
	atSchedule(o30.cid,o30.sid,EVENTSTART,0.0);
	
	UdpAgent *a31 = new UdpAgent();
	UdpAgent *a32 = new UdpAgent();
	a31 -> setPackSize(200);
	a31 -> setInterval(0.002);
	a32 ->setPackSize(100);
	a32 -> setInterval(0.004);
	countApplication *c31 = new countApplication("agent31");
	countApplication *c32 = new countApplication("agent32");
	a31 -> addApplication(c31);
	a32 -> addApplication(c32);
	SOBJ o31 = attackAgent(n21,a31);
	SOBJ o32 = attackAgent(n23,a32);
	connection(a31,a32);
	atSchedule(o31.cid,o31.sid,EVENTSTART,0.0);
	//atSchedule(o32.cid,o32.sid,EVENTSTART,0.0);
	
	UdpAgent *a33 = new UdpAgent();
	UdpAgent *a34 = new UdpAgent();
	a33 -> setPackSize(200);
	a33 -> setInterval(0.002);
	a34 ->setPackSize(100);
	a34 -> setInterval(0.004);
	countApplication *c33 = new countApplication("agent33");
	countApplication *c34 = new countApplication("agent34");
	a33 -> addApplication(c33);
	a34 -> addApplication(c34);
	SOBJ o33 = attackAgent(n22,a33);
	SOBJ o34 = attackAgent(n30,a34);
	connection(a33,a34);
	atSchedule(o33.cid,o33.sid,EVENTSTART,0.0);
	//atSchedule(o34.cid,o34.sid,EVENTSTART,0.0);
	
	UdpAgent *a35 = new UdpAgent();
	UdpAgent *a36 = new UdpAgent();
	a35 -> setPackSize(200);
	a35 -> setInterval(0.002);
	a36 ->setPackSize(100);
	a36 -> setInterval(0.004);
	countApplication *c35 = new countApplication("agent35");
	countApplication *c36 = new countApplication("agent36");
	a35 -> addApplication(c35);
	a36 -> addApplication(c36);
	SOBJ o35 = attackAgent(n29,a35);
	SOBJ o36 = attackAgent(n31,a36);
	connection(a35,a36);
	//atSchedule(o35.cid,o35.sid,EVENTSTART,0.0);
	atSchedule(o36.cid,o36.sid,EVENTSTART,0.0);

	simTime(100.0);
}
