/*author Guastella Marco*/

class Packet
{
	private: 	
		static Packet *free_;
		unsigned char *hdr_;
	public:
		Packet();
		~Packet();
		static int hdrlen_;
		static int *hpos_;
		void setHeader(int,int,int,int);
		unsigned char *getHdr();
		static inline Packet * alloc();
		static inline void free(Packet *);
		Packet *next_;
		Packet *prev_;
};

class PacketMenager
{
	public:
		PacketMenager();
		~PacketMenager();
		static void init();
};

#include <stdio.h>

inline Packet * Packet::alloc()
{
	Packet *p;
	if(free_ == 0)
	{	
		p=new Packet();
		p->hdr_ = new unsigned char[hdrlen_];
	}
	else
	{
		p = free_;
		free_ = free_ -> next_;	
		p -> next_ = 0;
	} 
	return p;
}

		
inline void Packet::free(Packet *p)
{
	p -> next_ = free_;
	free_ = p;
}


