/*author Guastella Marco*/

#include "Packet.h"
#include "hdr.h"
#include <stdio.h>

Packet *Packet::free_=0;
int Packet::hdrlen_=0;
int *Packet::hpos_=0;

PacketMenager::PacketMenager() 
{
	
}

		
PacketMenager::~PacketMenager()
{
	delete [] Packet::hpos_;
	Packet::hpos_= 0;
} 


void PacketMenager::init()
{
	int dlevel = 0;
	int maxSize = sizeof(struct hdr_cmn);
	unsigned int max;
	Packet::hpos_ = new int[NLEVEL];
	while(dlevel < NLEVEL)
	{
		switch(dlevel)
		{
			case LEVELDL:
				max = 0;
				Packet::hpos_[LEVELDL] = maxSize;
				maxSize += max;
				break;
			case LEVELIP:
				max = 0;
				Packet::hpos_[LEVELIP] = maxSize;
				if(max < sizeof(struct hdr_ip))
					max = sizeof(struct hdr_ip);
				maxSize += max;
				break;
			case LEVELTR:
				max = 0;
				Packet::hpos_[LEVELTR] = maxSize;
				if(max < sizeof(struct hdr_tcp))
					max = sizeof(struct hdr_tcp);
				if(max < sizeof(struct hdr_udp))
					max = sizeof(struct hdr_udp);
				maxSize += max;
				break;
			case LEVELAP:
				max = 0;
				Packet::hpos_[LEVELAP] = maxSize;
				maxSize += max;
				break;
			default : return;
		}
		dlevel++;
	}	
	Packet::hdrlen_ = maxSize;
}

Packet::Packet()
{
	hdr_ = 0;
	next_=0;
	prev_=0;
}
		
Packet::~Packet()
{
	delete [] hdr_;
}


void Packet::setHeader(int leveldl,int levelip,int leveltr,int levelap)
{
	struct hdr_cmn *cmn = (hdr_cmn *) hdr_;
	
	
	/*header livello data link-mac*/
	switch(leveldl)
	{
		default: 
			cmn->htype_[LEVELDL] = HDRNO;
			break;
	}
	
	/*header livello ip*/
	switch(levelip)
	{
		case HDRIP:
			cmn->htype_[LEVELIP] = HDRIP;
			
			break;
		default:
			cmn->htype_[LEVELIP] = HDRNO;
			break;
	}
	
	/*header livello di trasporto*/
	switch(leveltr)
	{
		case HDRTCP:
			cmn->htype_[LEVELTR] = HDRTCP;
			break;
		case HDRUDP:
			cmn->htype_[LEVELTR] = HDRUDP;
			break;
	}
	
	/*header livello applicativo*/
	switch(levelap)
	{
		default:
			cmn->htype_[LEVELAP] = HDRNO;
			break;
	}
}

unsigned char *Packet::getHdr()
{
	return hdr_;
}



