/*author Guastella Marco*/

class Event;
class Packet;

class Object
{
	public:
		Object();
		virtual ~Object();
		virtual void recv(Event *)=0;
		virtual void send(Event *)=0;
};

class LocalConnector : public Object
{
	protected:
		 Object *target_;
		 Object *dropTarget_;
	public:
		 LocalConnector();
		 virtual ~LocalConnector();
		 virtual void recv(Event *)=0;
		 virtual void send(Event *)=0;
		 void setTarget(Object *);
		 void setDropTarget(Object *);
};


class RemoteConnector : public Object
{
	protected:	
		  int cid_;
		  int sid_;
	public:
		  RemoteConnector();
		  virtual ~RemoteConnector();
		  virtual void recv(Event *)=0;
		  virtual void send(Event *)=0;
		  void setRemote(int,int);
};

class Agent;

class Application: public Object
{
	protected:	
		int lip_;
		int ltr_;
		Agent *agent_;
		int spack_;
		int rpack_;
	public:
		Application();
		~Application();
		virtual void recv(Event *)=0;
		virtual void send(Event *)=0;
		void addHeader(int,int);
		void addAgent(Agent *);
		virtual int getNextPack(Event *)=0;
		virtual void printResult()=0;
		int getSpack() {return spack_;}
		int getRpack() {return rpack_;}
		void setSpack(int s) {spack_=s;}
		void setRpack(int s) {rpack_=s;}
};


class Queue : public LocalConnector
{
	public : 
		Queue();
		virtual ~Queue();
		void recv(Event *);
		void send(Event *);
		void setMaxSize(int);

	protected:
		int blocked_;
		int maxsize_;
		int size_;	
		virtual void enque(Packet *)=0;
		virtual Packet *deque()=0;
	
};

class DropTail: public Queue
{
	private:
		Packet *head_;
		Packet *tail_;
		void enque(Packet *);
		Packet *deque();	
	public:
		DropTail():head_(0),tail_(0){}
		~DropTail();
};

/*simula lo scarto dei pacchetti*/
class drop : public LocalConnector
{
	public :
		drop();
		~drop();
		void recv(Event *);
		void send(Event *);		
};

class LinkDelay: public RemoteConnector
{
	private:
		double bw_;
		double delay_;
	public:
		LinkDelay(double,double,int,int);
		~LinkDelay();
		void recv(Event *);
		void send(Event *);	
		int getDstCid();
		double bw();
		double delay();
};

class countApplication : public Application
{
	private:
		char *name_;
	public:
		countApplication(const char *);
		~countApplication();
		void recv(Event *e);
		void send(Event *);
		int getNextPack(Event *);
		void printResult();
		
};
