/*author Guastella Marco*/

#include "config.h"
#include "Container.h"
#include "SObject.h"
#include <stdio.h>
#include "Pdnet.h"
#include "Scheduler.h"

Node::Node()
{
	routing *r=new routing(0);
	head_ = addSobject(r);
	demux_ = -1;
}
		
Node::~Node()
{
	
}

int Node::type()
{
	return TYPE_NODE;
}

/*setta l'indirizzo del nodo*/
void Node::setAddress(int a)
{
	address_ = a;
}

/*ritorna l'indirizzo del nodo*/
int Node::getAddress()
{
	return address_;
}

/*setta il cid del nodo*/
void Node::setCid(int c)
{
	cid_=c;
}

/*aggiunge record alla tabella di routing*/
int Node::addRoute(int addr,int s,double t)
{
	if(s >= tsobj_ || s < 0)
		return -1;
	if(stable_[s] -> type() == TYPE_SIMPLEXLINK)
	{
		SimplexLink *l = (SimplexLink *) stable_[s];
		unsigned int *k;
		unsigned int nl = l->getLevel(&k);
		int sroute=head_;
		for(unsigned int i=0;i<nl && sroute != -1;i++)
		{	
			routing *r = (routing *)stable_[sroute];
			sroute = r->addRoute(addr,t,k[i]);
		}
		return 0;
	}
	return -1;
}

/*crea l'oggetto che serve per identificare gli agenti del nodo*/
void Node::addDemux()
{
	demux *dm = new demux(cid_);
	demux_=addSobject(dm);
	routing *r = (routing *) stable_[head_];
	int index = r->addConn(TYPE_DEMUX,address_,cid_,demux_);	
	r->addRoute(address_,0.0,index);
}

/*aggiunge un link al nodo prima parte*/
int Node::addSimplexLink(double bw,double delay,int qtype,int size,int dcid,int dsid,int daddr)
{
	SimplexLink *l = new SimplexLink(bw,delay,qtype,size,dcid,dsid);
	int sid = addSobject(l);
	l->setLocal(cid_,sid);
	routing *r = (routing *) stable_[head_];
	int index = r->addConn(TYPE_SIMPLEXLINK,daddr,cid_,sid);	
	l -> addLevel(index);
	return sid;
	
}

/*aggiunge una netcard al nodo seconda parte link*/
int Node::addNetCard()
{
	netCard *nc = new netCard(cid_,head_);
	return addSobject(nc);
}

/*stampa la tabella di routing*/
void Node::print()
{
	routing *r = (routing *) stable_[head_];
	r -> print(cid_);
}

/*aggiunge un agente al nodo*/
int Node::addAgent(Agent *a)
{
	int sid = addSobject(a);
	a -> setAddress(address_);
	a -> setConnection(cid_,sid,head_);
	demux *dm = (demux *) stable_[demux_];
	a -> setPort(dm -> addAgent(sid));
	return sid;
}

void Node::handle(Event *e)
{
	if(e->type_ == EVENTHANDLE)
	{
		stable_[e->sid_] -> handle(e);
	}
	else if(e->type_ == EVENTSTART)
	{
		Agent *a = (Agent *) stable_[e->sid_];
		a->start();
		delete e;
	} 
	else if(e->type_ == EVENTSTOP)
	{
		Agent *a = (Agent *) stable_[e->sid_];
		a->stop();
		delete e;
	}
	else
	{
		delete e;
	}
}

double Node::getTime(int address)
{
	int sroute=head_;
	double time = 0.0;
	while(sroute != -1)
	{	
		routing *r = (routing *)stable_[sroute];
		time = r->getTime(address,& sroute);
	}
	return time;
}
