/*author Guastella Marco*/

#include "Object.h"
#include "Pdnet.h"
#include "Scheduler.h"
#include "hdr.h"
#include "Packet.h"
#include <stdio.h>

LinkDelay::LinkDelay(double b,double d,int c,int s)
{
	bw_=b;
	delay_=d;
	setRemote(c,s);
}
		
LinkDelay::~LinkDelay()
{
}
		
void LinkDelay::recv(Event *e)
{
	Event *event = new Event();
	unsigned char *h = (e->pack_) -> getHdr();
	hdr_cmn *cmn = (hdr_cmn *) h;
	double time= (8. * cmn->size_ / bw_);
	Pdnet &pd = Pdnet::instance();
	int c = e->cid_;
	int s = e->sid_;
	pd.schedule(e,cid_,sid_,time+delay_);
	pd.schedule(event,c,s,time);
}

		
void LinkDelay::send(Event *)
{
			
}

int LinkDelay::getDstCid()
{
	return cid_;
}
		
double LinkDelay::bw()
{
	return bw_;
}
		
double LinkDelay::delay()
{
	return delay_;
}
