/*author Guastella Marco*/

#define MAX_SOBJECT 100

class SObject;
class Event;
class CommBuffer;

class container
{
	protected:
		SObject **stable_;
		int tsobj_;
		int ssobj_;
		int shead_;//indice oggetto head del container
		int addSobject(SObject *s);
	public:
		container();
		virtual ~container();
		int exist(int);//ci dice su SObject con sid associato a questo evento esiste
		void recv(Event *);//riceve un pacchetto da remoto e lo passa al relativo sid
		virtual void handle(Event *);
		int getStable(SObject ***);//ottiene il puntatore ad un Stable
		virtual int type() = 0;	//ci da il tipo di container
		void supdate(CommBuffer *);
		void rupdate(CommBuffer *);
		void getUpdate(CommBuffer *);
		int controlUpdate(CommBuffer *,CommBuffer *);
		
};

class Agent;

class Node : public container
{
	private:
		int address_;
		int cid_;
		int head_;
		int demux_;
	public:
		Node();
		~Node();
		int type();	
		void handle(Event *);
		void setCid(int);
		void setAddress(int);
		int getAddress();
		int addRoute(int,int,double);
		int addSimplexLink(double,double,int,int,int,int,int);
		int addNetCard();
		void addDemux();
		void print();
		int addAgent(Agent *);
		double getTime(int address);
};

