/*author Guastella Marco*/

#include <stdio.h>
#include <stdlib.h>
#include "Container.h"
#include "Scheduler.h"
#include "SObject.h"
#include "config.h"
#include "CommBuffer.h"

#define MAX_OBJECT 32

container::container()
{
	tsobj_= 0;
	ssobj_= MAX_SOBJECT;
	stable_ = (SObject **) malloc(sizeof(SObject *)*ssobj_);
	for(int i=0;i<ssobj_;i++)
		stable_[i] = 0;
}
		
container::~container()
{
	for(int i=0;i<ssobj_;i++)
		delete stable_[i];
	free(stable_);
}

/*void Container::setLocation(int c)
{
	cid_=c;
}*/

int container::addSobject(SObject *s)
{
	if(tsobj_ == ssobj_)
	{
		SObject **tmp;
		tmp = stable_;
		ssobj_ *= 2;
		stable_ = (SObject **) malloc(sizeof(SObject *)*ssobj_);
		for(int i=0; i < tsobj_;i++)
			stable_[i] = tmp[i]; 
		for(int i=tsobj_;i<ssobj_;i++)
			stable_[i] = 0;	
		free(tmp);
	}
	stable_[tsobj_] = s;
	return tsobj_++;
}

int container::exist(int s)
{
	if(s >= tsobj_ || s < 0)
		return -1;
	return 0;
}

void container::recv(Event *e)
{
	stable_[e->sid_] -> recv(e);
}
		
void container::handle(Event *e)
{
	stable_[e->sid_] -> handle(e);
}
		
int container::getStable(SObject ***s)
{
	*s = stable_;
	return tsobj_; 
}

void container::supdate(CommBuffer *c)
{
	for(int i=0;i<tsobj_;i++)
		stable_[i]->supdate(c);
	
}

void container::rupdate(CommBuffer *c)
{
	for(int i=0;i<tsobj_;i++)
		stable_[i]->rupdate(c);
}

void container::getUpdate(CommBuffer *com)
{
	for(int i=0;i<tsobj_;i++)
		if(stable_[i]->isUpdate())
			com->pack(i);
	com->pack(-1);
	for(int i=0;i<tsobj_;i++)
		if(stable_[i] -> isUpdate())
		{	
			com->pack(i);
			stable_[i] -> supdate2(com);
		}
	com->pack(-1);
}

int container::controlUpdate(CommBuffer *input,CommBuffer *output)
{
	int sid = -2;
	int init = 0;
	//printf("output %d\n",output->getPosition());
	output->unpack(&sid);
	while(sid != -1)
	{
		//printf("sid %d tsobj %d\n",sid,tsobj_);
		for(int i=init;i<sid;i++)
			stable_[i]->removeInput(input);
		if((stable_[sid] -> control(input) == 0))
			break;
		init = sid;
		output->unpack(&sid);
	}
	if(sid == -1)
	{
		output->unpack(&sid);
		while(sid != -1)
		{	
			stable_[sid]->rupdate2(output);
			output->unpack(&sid);
		}
		return 1;
	}	
	return 0;
}



