/*author Guastella Marco*/


class CommBuffer
{
	private:
		 char *mBuffer;    // il buffer
    		 int mBufferSize;  // size del buffer allocato
    		 int mMsgSize;     // msg size (incrementato by pack() functions)
    		 int mPosition;    // posizione corrente del buffer per unpacking
	public:
		 CommBuffer();
		~CommBuffer();
		 void extendBuffer(int); // aumenta la dimensione del buffer di una quantit
		 char *getBuffer() {return mBuffer;}
		 void setBuffer(char *,int);
		 int getBufferSize () {return mBufferSize;}
		 int getMessageSize () {return mMsgSize;}
		 int getPosition() {return mPosition;}
		 void reset(); 
		 CommBuffer& operator=(CommBuffer &cm);
		 int pack(int d);
    		 int pack(unsigned int);
		 int pack(double d);
    		 int pack(const unsigned char *d,int);
    		 int unpack(int* d);
    		 int unpack(unsigned int* d);
		 int unpack(double* d);
    		 int unpack(const unsigned char *d,int);
		 void resetPosition() {mPosition = 0;}
};
