/*author Guastella Marco*/

#include "CommBuffer.h"
#include <stdlib.h>
#include <mpi.h>
#include <string.h>

CommBuffer::CommBuffer()
{
	mBuffer = 0;
  	mBufferSize = 0;  
    	mMsgSize=0;     
    	mPosition=0; 
	
}

CommBuffer::~CommBuffer()
{
	/*if(mBuffer != 0)
		delete [] mBuffer;*/
}

CommBuffer& CommBuffer::operator=(CommBuffer &cm)
{
	mBufferSize = cm.getBufferSize();
	mBuffer = new char[mBufferSize]; 
	for(int i=0;i < mBufferSize;i++)
		mBuffer[i]=(cm.getBuffer())[i];
	mMsgSize = cm.getMessageSize();
	mPosition = cm.getPosition();
	return (*this);
}

void CommBuffer::extendBuffer(int size)
{
	if(mBuffer == 0)
	{	
		mBufferSize = size;
		mBuffer = new char[mBufferSize];
		return;
	}
	char *tmpbuffer = new char[mBufferSize+size];
	for(int i=0;i < mBufferSize;i++)
		tmpbuffer[i] = mBuffer[i];
	delete [] mBuffer;
	mBuffer = tmpbuffer;
	mBufferSize += size;
} 

void CommBuffer::reset()
{
	if(mBuffer != 0)
		delete [] mBuffer;
	mBuffer = 0;
  	mBufferSize = 0;  
    	mMsgSize=0;     
    	mPosition=0; 
}



/*setta i valori del buffer*/
void CommBuffer::setBuffer(char *c,int l)
{
	if(mBuffer != 0)
		delete [] mBuffer;
	mBufferSize = l;
	mPosition = 0;
	mMsgSize = l;
	mBuffer = new char[l];
	for(int i=0;i<mMsgSize;i++)
		mBuffer[i] = c[i];
}



int CommBuffer::pack(int d)
{
    extendBuffer(sizeof(int));
    return MPI_Pack(&d, 1, MPI_INT, mBuffer, mBufferSize, &mMsgSize, MPI_COMM_WORLD);
}

int CommBuffer::pack(unsigned int d)
{
	extendBuffer(sizeof(unsigned int));
	return MPI_Pack(&d, 1, MPI_UNSIGNED, mBuffer, mBufferSize, &mMsgSize, MPI_COMM_WORLD);
}

int CommBuffer::pack(double d)
{
    extendBuffer(sizeof(double));
    return MPI_Pack(&d, 1, MPI_DOUBLE, mBuffer, mBufferSize, &mMsgSize, MPI_COMM_WORLD);
}

// pack una stringa
int CommBuffer::pack(const unsigned char *d,int len)
{
    if(len == 0)
    	return pack(len);
    int ret = pack(len);
    if (ret != MPI_SUCCESS)
    	return ret;
    extendBuffer(len*sizeof(char));
    return MPI_Pack((void *)d, len, MPI_UNSIGNED_CHAR, mBuffer, mBufferSize, &mMsgSize, MPI_COMM_WORLD);
}

int CommBuffer::unpack(int* d)
{
    	return MPI_Unpack(mBuffer, mMsgSize, &mPosition, d, 1, MPI_INT, MPI_COMM_WORLD);
}

int CommBuffer::unpack(unsigned int* d)
{
    	return MPI_Unpack(mBuffer, mMsgSize, &mPosition, d, 1, MPI_UNSIGNED, MPI_COMM_WORLD);
}

int CommBuffer::unpack(double* d)
{
     return MPI_Unpack(mBuffer, mMsgSize, &mPosition, d, 1, MPI_DOUBLE, MPI_COMM_WORLD);
}


// unpack a string
int CommBuffer::unpack(const unsigned char *d,int len)
{
    int ret;
    if((ret = MPI_Unpack(mBuffer, mMsgSize, &mPosition,(void *) d,len, MPI_UNSIGNED_CHAR, MPI_COMM_WORLD) != MPI_SUCCESS))
        return ret;
    return MPI_SUCCESS;
}

