/*author Guastella Marco*/


#include "SObject.h"
#include "config.h"
#include "Pdnet.h"
#include "Object.h"
#include "hdr.h"
#include "Scheduler.h"
#include "Packet.h"
#include <stdio.h>
#include <limits.h>
#include <stdio.h>
#include "CommBuffer.h"

Agent::Agent()
{
	app_=0;		
	address_ = -1;
	raddress_= -1;
	port_ = -1;
	dport_ = -1;
	psize_ = 210;
	cid_ = -1;
	sid_ = -1;
	rsid_ = -1;
	Pdnet &pd = Pdnet::instance();
	pd.agentRegister(this);
}

Agent::~Agent()
{
	if(app_ != 0)
		delete app_;
}

int Agent::type()
{
	return TYPE_AGENT;
}

/*indica all'agent l'oggetto del nodo con cui comunica*/
void Agent::setConnection(int c,int s,int rs)
{
	cid_=c;
	sid_=s;
	rsid_=rs;
}

/*aggiunge un'applicazione all'agent*/
void Agent::addApplication(Application *a) 
{
	app_=a; 
	app_->addAgent(this);
	setHeader();
}


void Agent::setPackSize(int s) 
{
	if(s < PKT_ROUTE)
		psize_ = PKT_ROUTE;
	else	
		psize_=s;
}

UdpAgent::UdpAgent()
{
	tpack_ = -1;
	npack_ = 0;
	psize_ = 210;
	interval_ = 0.01;
	state_ = 0;
}

UdpAgent::~UdpAgent()
{

}

		
void UdpAgent::handle(Event *e)
{
	update_ = 1;
	Pdnet &pd = Pdnet::instance();
	npack_++;
	if(state_ == 1 && (tpack_ == -1 || npack_ <= tpack_)) 
	{
		if(app_ != 0)
		{
			Event *sevent = new Event(); 
			int size = app_->getNextPack(sevent);
			unsigned char *h = (sevent->pack_)->getHdr();		
			hdr_cmn *cmn = (hdr_cmn *) h;
			if(cmn->htype_[LEVELIP] == HDRIP && cmn->htype_[LEVELTR] == HDRUDP)
			{
				if(size <= psize_)
					cmn -> size_ = size;
				else
					return;
				hdr_ip *ip = (hdr_ip *) &h[Packet::hpos_[LEVELIP]];
				ip -> ttl_ = 0;
				ip -> saddr_ = address_;
				ip -> daddr_ = raddress_;
				hdr_udp *udp = (hdr_udp *) &h[Packet::hpos_[LEVELTR]];
				udp -> sport_ = port_;
				udp -> dport_ = dport_;  
				pd.send(sevent,cid_,rsid_);
				pd.schedule(e,cid_,sid_,interval_);
			}
		}
	}
	else
		delete e;
}
		
void UdpAgent::recv(Event *e)
{
	update_=1;
	if(app_ != 0)
		app_ -> recv(e);
}

void UdpAgent::setHeader()
{
	if(app_ != 0)
		app_-> addHeader(HDRIP,HDRUDP);
}

int UdpAgent::type()
{
	return TYPE_AGENTUDP;
}

void UdpAgent::start()
{
	if(state_ == 0)
	{
		state_ = 1;
		Event *e=new Event();
		handle(e);
		npack_=0;
	}
}

void UdpAgent::stop()
{
	state_=0;
}

void UdpAgent::printResult()
{
	if(app_ != 0)
		app_->printResult();
}

void UdpAgent::supdate(CommBuffer *c)
{
	c->pack(state_);
	if(app_!=0)
	{
		c->pack(app_->getSpack()); 
		c->pack(app_->getRpack());
	}
}

void UdpAgent::rupdate(CommBuffer *c)
{
	update_ = 0;
	c->unpack(&state_);
	if(app_!=0)
	{
		int s;
		c->unpack(&s);
		app_->setSpack(s);
		c->unpack(&s);
		app_->setRpack(s);
	}	
}

int UdpAgent::control(CommBuffer *c)
{
	int tmpstate; 
	c->unpack(&tmpstate);
	if(app_!=0)
	{
		int s1=-1;
		c->unpack(&s1);
		int v1 = app_->getSpack();
		int s2=-1;
		c->unpack(&s2);
		int v2 = app_->getRpack();
		if(tmpstate == state_ && s1 == v1 && s2 == v2)
			return 1;
	}
	else
	{
		if(tmpstate == state_)
			return 1;
	}
	return 0;
}

void UdpAgent::removeInput(CommBuffer *com)
{
	int tmp = 0;
	com->unpack(&tmp);
	if(app_!=0)
	{
		com->unpack(&tmp);
		com->unpack(&tmp);
	}
}

#define IPSIZE 20
#define TCPSIZE 20

/*stati tcp*/
#define CLOSED 0
#define LISTEN 1
#define SYNSENT 2
#define SYNRECV 3
#define ESTABLISHED 4
#define FINWAIT 5
#define WAIT 6

/*tipi messaggio tcp*/
#define SYN 0
#define SYNACK 1
#define SYNACKACK 2
#define SEQ 3
#define ACK 4
#define FIN 5
#define FINACK 6
#define FINACKACK 7

TcpAgent::TcpAgent()
{
	state_ = CLOSED;	
	psize_ = 210;
}
		
TcpAgent::~TcpAgent()
{
	
}

void TcpAgent::handle(Event *e)
{
	update_ = 1;
	switch(state_)
	{
		case SYNSENT:
				spack_++;
				setTimeout();
				sendPack(SYNACKACK,psize_,seq_);
				break;
		case ESTABLISHED:
				spack_++;
				setTimeout();
				sendPack(SEQ,psize_,seq_);
				break;
		case FINWAIT:
				setTimeout();
				sendPack(FINACKACK,HDRIP+HDRTCP,-1);
				state_ = WAIT;
				break;
		case WAIT:
				state_ = CLOSED;
				break;
	}
}

		
void TcpAgent::recv(Event *e)
{
	update_ = 1;
	unsigned char *h = (e->pack_) -> getHdr();
	hdr_tcp *tcp = (hdr_tcp *) &h[Packet::hpos_[LEVELTR]];
	switch(state_)
	{
		case SYNSENT: if(tcp -> mtype_ == SYNACK)
			      {
					setTimeout();
					state_ = ESTABLISHED;
			      		spack_++;
					sendPack(SYNACKACK,psize_,seq_++);
			      }
			      break;
		
		case ESTABLISHED: if(tcp->mtype_ == ACK)
				  {
					if(tcp -> sack_ == seq_)
					{
						setTimeout();
						rack_++;
						spack_++;
						sendPack(SEQ,psize_,seq_);
						if(seq_ == INT_MAX)
							seq_ = 0;
						else
							seq_++;
						 
					}	
				  	else
					{	
						rack_++;
						rduplex_++;
					}
				  }
			      	  break;			
		
		case FINWAIT: if(tcp->mtype_ == FINACK)
			      {
				  setTimeout();
				  state_ = WAIT;
				  sendPack(FINACKACK,HDRIP+HDRTCP,-1);
			      }
			      else
			      {
				  rack_++;
				  if(tcp->mtype_ == ACK && tcp->sack_ != seq_)
				  {	
					rduplex_++;
			                seq_++;
				  }
			      }
			      break;
		
		case WAIT:   if(tcp->mtype_ == ACK )
			     {
			      	  if(seq_ == tcp->sack_)
				  {
					rack_++;
					if(seq_ == INT_MAX)
						seq_ = 0;
					else
						seq_++;
				  }	
			      	  else
				  {
				  	rack_++;
					rduplex_++;
				  }
			      }
			      break;
		
		default: break;
	}
	delete e;
}

void TcpAgent::setTimeout()
{
	Pdnet &pd = Pdnet::instance();
	crono_ = pd.clock() - mtime_;
	mtime_ = pd.clock();
	rtt_ = (0.875 * rtt_) + (0.125 * crono_);
	if(rtt_ > crono_)
		sdev_= (0.875 * sdev_) + (0.125 * (rtt_ - crono_));
	else
		sdev_= (0.875 * sdev_) + (0.125 * (crono_ - rtt_));
	timeout_ = rtt_ + (4*sdev_)+0.001;
}

void TcpAgent::start()
{
	update_ = 1;
	Pdnet &pd = Pdnet::instance();
	if(state_ == CLOSED)
	{
		seq_ = 0;
		spack_ = 0;	
		rack_ = 0;
		rduplex_ = 0;
		crono_ = pd.getTime(cid_,raddress_) * 2; 
		rtt_ = crono_;
		sdev_ = crono_;
		if(crono_ <= 0.0)
			return;
		timeout_ = rtt_+ 4 *sdev_;
		state_ = SYNSENT;
		mtime_ = pd.clock();
		sendPack(SYN,IPSIZE+TCPSIZE,-1);
	}
}

void TcpAgent::stop()
{
	update_=1;
	state_ = FINWAIT;
	sendPack(FIN,IPSIZE+TCPSIZE,-1);	
}
		
void TcpAgent::setHeader()
{
	
}

void TcpAgent::sendPack(int type,int s,int nseq)
{
	Pdnet &pd = Pdnet::instance();
	Event *e = new Event();
	e -> pack_ = Packet::alloc();
	(e-> pack_) -> setHeader(HDRNO,HDRIP,HDRTCP,HDRNO);
	unsigned char *h = (e->pack_) -> getHdr();
	hdr_cmn *cmn = (hdr_cmn *) h;
	cmn -> size_ = s;
	hdr_ip *ip = (hdr_ip *) &h[Packet::hpos_[LEVELIP]];
	ip -> ttl_ = 0;
	ip -> saddr_ = address_;
	ip -> daddr_ = raddress_;
	hdr_tcp *tcp = (hdr_tcp *) &h[Packet::hpos_[LEVELTR]];	
	tcp -> sport_ = port_;
	tcp -> dport_ = dport_;
	tcp -> seq_ = nseq;
	tcp -> mtype_ = type;
	pd.send(e,cid_,rsid_);
	timeout();
}

void TcpAgent::printResult()
{
	printf("tcp agent (%d %d)->(%d %d) send pack %d recv pack %d duplex %d\n",address_,port_,raddress_,dport_,spack_,rack_,rduplex_);
}

void TcpAgent::timeout()
{
	Pdnet &pd = Pdnet::instance();
	Event *e = new Event();
	pd.deleteEvent(duid_);
	pd.schedule(e,cid_,sid_,timeout_);
	duid_ = e->uid_;
}

int TcpAgent::type()
{
	return TYPE_AGENTTCP;
}

void TcpAgent::supdate(CommBuffer *c)
{
	c->pack(seq_);
	c->pack(rtt_);
	c->pack(mtime_);
	c->pack(crono_);
	c->pack(sdev_);
	c->pack(timeout_);
	c->pack(spack_);
	c->pack(state_);
	c->pack(rack_);
	c->pack(rduplex_);
	
}

void TcpAgent::rupdate(CommBuffer *c)
{
	update_=0;
	c->unpack(&seq_);
	c->unpack(&rtt_);
	c->unpack(&mtime_);
	c->unpack(&crono_);
	c->unpack(&sdev_);
	c->unpack(&timeout_);
	c->unpack(&spack_);
	c->unpack(&state_);
	c->unpack(&rack_);
	c->unpack(&rduplex_);
}

void TcpAgent::rupdate2(CommBuffer *c)
{
	rupdate(c);
	timeout();
}

void TcpAgent::supdate2(CommBuffer *c)
{
	Pdnet &pd=Pdnet::instance();
	supdate(c);
	pd.deleteEvent(duid_);
}

int TcpAgent::control(CommBuffer *c)
{
	int tmpseq = 0;
	double tmprtt = 0;
	double tmpmtime = 0.0;
	double tmpcrono = 0.0;
	double tmpsdev = 0.0;
	double tmptimeout = 0.0;
	int tmpspack = 0;
	int tmpstate = 0;
	int tmprack = 0;
	int tmprduplex = 0;
	c->unpack(&tmpseq);
	c->unpack(&tmprtt);
	c->unpack(&tmpmtime);
	c->unpack(&tmpcrono);
	c->unpack(&tmpsdev);
	c->unpack(&tmptimeout);
	c->unpack(&tmpspack);
	c->unpack(&tmpstate);
	c->unpack(&tmprack);
	c->unpack(&tmprduplex);
	if(tmpseq == seq_ && tmprtt == rtt_ && tmpmtime == mtime_ && tmpcrono == crono_ && tmpsdev == sdev_ && tmptimeout == timeout_  && tmpspack == spack_ && tmpstate == state_ && tmprack == rack_ && tmprduplex == rduplex_)
		return 1;
	return 0;
}

void TcpAgent::removeInput(CommBuffer *com)
{
	int tmp=0;
	double tmp2 = 0.0;
	com->unpack(&tmp);
	com->unpack(&tmp2);
	com->unpack(&tmp2);
	com->unpack(&tmp2);
	com->unpack(&tmp2);
	com->unpack(&tmp2);
	com->unpack(&tmp);
	com->unpack(&tmp);
	com->unpack(&tmp);
	com->unpack(&tmp);
}

TcpAgentListener::TcpAgentListener()
{
	state_ = LISTEN;	
	psize_ = 40;
}
		
TcpAgentListener::~TcpAgentListener()
{
	
}

void TcpAgentListener::handle(Event *e)
{
	
}

		
void TcpAgentListener::recv(Event *e)
{
	update_=1;
	unsigned char *h = (e->pack_) -> getHdr();
	hdr_tcp *tcp = (hdr_tcp *) &h[Packet::hpos_[LEVELTR]];
	switch(state_)
	{
		case LISTEN: if(tcp -> mtype_ == SYN)
			     {
				state_ = SYNRECV;
			        ack_=0;
				rpack_=0;
				duplex_=0;
				sack_=0;
				sendPack(SYNACK,IPSIZE+TCPSIZE,-1);
			     }	 
			     else if(tcp->mtype_ == FIN)
			     {
				 sendPack(FINACK,HDRIP+HDRTCP,-1);
			     }
			     break;

		case SYNRECV:if(tcp -> mtype_ == SYNACKACK)
			     {
				state_ = ESTABLISHED;
				rpack_++;
				ack_ = tcp->seq_ + 1; 
				sack_++;
				sendPack(ACK,psize_,ack_);
			     } 
			     else if(tcp->mtype_ == FIN)
			     {
				 state_ = LISTEN;
				 sendPack(FINACK,HDRIP+HDRTCP,-1);
			     }	
			     break;

		case ESTABLISHED: if(tcp->mtype_ == SEQ)
				  {
					if((ack_ == 0 && tcp->seq_ == INT_MAX) || tcp->seq_ == (ack_ - 1))
					{	
						duplex_++;
						rpack_++;
						sack_++;
						sendPack(ACK,psize_,ack_);
					}
					else if(ack_ == tcp->seq_)
					{
						rpack_++;
						if(ack_ == INT_MAX)
							ack_=0;
						else
							ack_++;
						sack_++;
						sendPack(ACK,psize_,ack_);
					}
					else
					{
						duplex_++;
				  		rpack_++;
					}
				  }
				  else if(tcp->mtype_ == FIN)
				  {
					state_ = LISTEN;
				  	sendPack(FINACK,HDRIP+HDRTCP,-1);
				  }
				  else if(tcp -> mtype_ == SYNACKACK)
				  {
					duplex_++;
				  	rpack_++;
					if(ack_ == 1)
				  	{	
						sack_++;
						sendPack(ACK,psize_,ack_);
				  	}
				  }
				  break;
		default: break;
	}
	delete e;
}

void TcpAgentListener::sendPack(int type,int s,int nack)
{
	Pdnet &pd = Pdnet::instance();
	Event *e = new Event();
	e -> pack_ = Packet::alloc();
	(e-> pack_) -> setHeader(HDRNO,HDRIP,HDRTCP,HDRNO);
	unsigned char *h = (e->pack_) -> getHdr();
	hdr_cmn *cmn = (hdr_cmn *) h;
	cmn -> size_ = s;
	hdr_ip *ip = (hdr_ip *) &h[Packet::hpos_[LEVELIP]];
	ip -> ttl_ = 0;
	ip -> saddr_ = address_;
	ip -> daddr_ = raddress_;
	hdr_tcp *tcp = (hdr_tcp *) &h[Packet::hpos_[LEVELTR]];	
	tcp -> sport_ = port_;
	tcp -> dport_ = dport_;
	tcp -> sack_ = nack;
	tcp -> mtype_ = type;
	pd.send(e,cid_,rsid_);
}

void TcpAgentListener::start()
{
	
}

void TcpAgentListener::stop()
{

}
		
void TcpAgentListener::setHeader()
{
	
}



void TcpAgentListener::printResult()
{
	printf("tcp agent listener (%d %d)->(%d %d) send ack %d recv pack %d duplex %d\n",address_,port_,raddress_,dport_,sack_,rpack_,duplex_);
}

int TcpAgentListener::type()
{
	return TYPE_AGENTTCPLISTENER;
}

void TcpAgentListener::supdate(CommBuffer *c)
{
	c->pack(ack_);
	c->pack(sack_);
	c->pack(rpack_);
	c->pack(duplex_);
	c->pack(state_);
}

void TcpAgentListener::rupdate(CommBuffer *c)
{
	update_=0;
	c->unpack(&ack_);
	c->unpack(&sack_);
	c->unpack(&rpack_);
	c->unpack(&duplex_);
	c->unpack(&state_);
}

int TcpAgentListener::control(CommBuffer *c)
{
	int tmpack;
	int tmpsack;
	int tmprpack;
	int tmpduplex;
	int tmpstate;
	c->unpack(&tmpack);
	c->unpack(&tmpsack);
	c->unpack(&tmprpack);
	c->unpack(&tmpduplex);
	c->unpack(&tmpstate);
	if(tmpack == ack_ && tmpsack == sack_ && tmprpack == rpack_ && tmpduplex == duplex_ && tmpstate == state_)
		return 1;
	return 0;
}

void TcpAgentListener::removeInput(CommBuffer *com)
{
	int tmp = 0;
	com->unpack(&tmp);
	com->unpack(&tmp);
	com->unpack(&tmp);
	com->unpack(&tmp);
	com->unpack(&tmp);
}
