/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include "../core.h"
 
 /*extern*/
l_com l_com_new(const l_str visual)
{
	l_com com=(l_com)l_mem_malloc0(sizeof(struct commander));
	com->data_=l_hash_new();
	com->visual_=l_str_new();
	l_str_cpy(&(com->visual_),visual);	
	return com;
}

void l_com_free(l_com *pcom)
{
	l_hash_free(&(*pcom)->data_);
	l_str_free(&((*pcom)->visual_));
	l_mem_freezero((void **)pcom,sizeof(struct commander));	
}

void l_com_cmd(l_com com,const l_str cmdname,const l_str format,const l_str brief,l_fhash funz)
{
	l_abuf value=l_abuf_new();
	l_abuf_nwrite(value,0,0,(void *) format,l_str_len(format));
	l_abuf_nwrite(value,1,0,(void *) brief,l_str_len(brief));
	l_hash_insert(com->data_,cmdname,value,funz);
}

void l_com_exec(l_com com,const l_buf cmd)
{
	l_bsplit bsplit= l_bsplit_new(cmd,0," ");
	l_num narg=l_bsplit_nsplit(bsplit);
	l_abuf list;
	l_abuf tmp;
	l_uint32 i;
	if( narg > 0)
	{
		if(l_buf_cmpstr(l_bsplit_read(bsplit,0),"help") == 0)
		{
			if(narg ==1)
			{
				l_std_out("help topic:\n");
				list=l_abuf_new();
				l_hash_allkey(com->data_,list);
				for(i=0;i<l_abuf_size(list);i++)
				{
					l_std_out("%15s ",(l_str) l_abuf_getmem(list,i,0));
					if((i%4) == 3)
						l_std_out("\n\n");
				}
				l_abuf_free(&list);	
				l_std_out("\n\nusage:help {cmdname} for info command\n\n");
			}
			else if(narg==2)
			{
				if((tmp=l_hash_search(com->data_,(l_str) l_buf_mem(l_bsplit_read(bsplit,1),0))) != 0)
				{
					l_std_out("usage:%s\n",(l_str)l_abuf_getmem(tmp,0,0));
					l_std_out("\t%s\n",(l_str)l_abuf_getmem(tmp,1,0));
				}		
				else
					l_std_out("help: command not found\n");
			}
			else
				l_std_out("usage:help [command]\n");	
		}
		else if(! l_hash_exec(com->data_,(l_str) l_buf_mem(l_bsplit_read(bsplit,0),0),bsplit->pbsplit_))
			l_std_out("%s:command not found\n",(l_str) l_buf_mem(l_bsplit_read(bsplit,0),0));
	}
	l_bsplit_free(&bsplit);	
}

void l_com_read(l_com com)
{
	l_buf buf=l_buf_new();
	l_std_out("%s",com->visual_);
	l_std_in(buf);
	l_com_exec(com,buf);
	l_buf_free(&buf);	
}

void l_com_list(l_com com,const l_str lcmd)
{
	l_num i;
	l_buf buf=l_buf_new();
	l_bsplit cmdsplit;
	l_buf_fwrite(buf,0,"s",lcmd);
	cmdsplit= l_bsplit_new(buf,0,";");
	l_buf_free(&buf);
	for(i=0;i< l_bsplit_nsplit(cmdsplit);i++)
		l_com_exec(com,l_bsplit_read(cmdsplit,i));
	l_bsplit_free(&cmdsplit);
}

/*end extern*/
 