/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include "../core.h"
 
 /*extern*/
 
 l_hmac3 l_hmac3_new()
 {
	l_hmac3 hmac3=(l_hmac3) l_mem_malloc(sizeof(struct mac3));
	hmac3->dmac_=l_str_new();	
	hmac3->smac_=l_str_new();
	hmac3->sap_= SAPUNDEF; 
	return hmac3; 
}
 
void l_hmac3_free(l_hmac3 *phmac3)
{
	l_hmac3_reset((*phmac3));
	l_mem_freezero((void **)phmac3,sizeof(struct mac3));	
}
 
void l_hmac3_reset(l_hmac3 hmac3)
{
	l_str_free(& (hmac3->dmac_));	
	l_str_free(& (hmac3->smac_));
	hmac3->sap_= SAPUNDEF;
}

void l_hmac3_set(const l_str dmac,const l_str smac,l_sap sap,l_hmac3 hmac3,l_out out)
{
	l_out_reset(out);
	l_hmac3_reset(hmac3);
	if(! l_mac_is(dmac))
		l_out_err(out,"l_hmac3_set:dmac not mac address valid");
	else if(! l_mac_is(smac))
		l_out_err(out,"l_hmac3_set:smac not mac address valid");
	else if(sap == SAPUNDEF)
		l_out_err(out,"l_hmac3_set:sap UNDEF value");
	else
	{
		l_str_cpy(& (hmac3->dmac_),dmac);
		l_str_cpy(& (hmac3->smac_),smac);
		hmac3->sap_=sap;	
		
	}		
}

l_index l_hmac3_write(l_hmac3 hmac3,l_buf buf,l_index point,l_out out)
{
	l_out_reset(out);
	if(hmac3->sap_ == SAPUNDEF)
	{	
		l_out_err(out,"l_hmac3_write:hmac3 not setting");
		return point;
	}
	else 
	{	
		l_mac_strtobuf(hmac3->dmac_,buf,point);
		l_mac_strtobuf(hmac3->smac_,buf,point+ MACADDRLEN);
		if(hmac3->sap_ == IPV4)
			l_buf_fwrite(buf,point+(2* MACADDRLEN),"w",0x800);
		else if(hmac3->sap_ == ARP4)
			 l_buf_fwrite(buf,point+(2* MACADDRLEN),"w",0x806);
	}	
	return (point+(2*MACADDRLEN)+2);
}

l_index l_hmac3_read(l_buf buf,l_index point,l_hmac3 hmac3,l_out out)
{
	l_out_reset(out);
	l_hmac3_reset(hmac3);
	l_word type;
	if(l_buf_size(buf)-point < (2*MACADDRLEN)+2)
	{	
		l_out_err(out,"l_hmac3_read:read failed");
		return point;
	}
	else
	{
		hmac3->dmac_=l_mac_read(buf,point);
		hmac3->smac_=l_mac_read(buf,point+MACADDRLEN);
		l_buf_fread(buf,point +(2*MACADDRLEN),"w",&type);
		if(type == 0x800)
			hmac3->sap_=IPV4;
		else if(type == 0x806)
			hmac3->sap_ = ARP4;
		else
		{
			l_hmac3_reset(hmac3);
			l_out_err(out,"l_hmac3_read:no protocol type valid");
			return point;
		}		
	}
	return (point+(2*MACADDRLEN)+2);
}

 /*end extern*/
