/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

/*extern*/

l_harp4 l_harp4_new()
{
	l_harp4 harp4=(l_harp4) l_mem_malloc(sizeof(struct arp4));
	harp4->hw_=HWUNDEF;
	harp4->ptype_=SAPUNDEF;
	harp4->hwsize_=0x00;
	harp4->psize_=0x00;
	harp4->opcode_=ARPCODEUNDEF;
	harp4->smac_=l_str_new();
	harp4->sip_=l_str_new();
	harp4->dmac_=l_str_new();
	harp4->dip_=l_str_new();
	return harp4;
}

void l_harp4_free(l_harp4 *pharp4)
{
	l_harp4_reset((*pharp4));
	l_mem_freezero((void **)pharp4,sizeof(struct arp4));
}

void l_harp4_reset(l_harp4 harp4)
{
	harp4->hw_=HWUNDEF;
	harp4->ptype_=SAPUNDEF;
	harp4->hwsize_=0x00;
	harp4->psize_=0x00;
	harp4->opcode_=ARPCODEUNDEF;
	l_str_free(&(harp4->smac_));
	l_str_free(&(harp4->sip_));
	l_str_free(&(harp4->dmac_));
	l_str_free(&(harp4->dip_));
}

void l_harp4_set(l_hw hw,l_sap ptype,l_arpcode opcode,const l_str smac,const l_str sip,const l_str dmac,const l_str dip,l_harp4 harp4,l_out out)
{
	l_out_reset(out);
	l_harp4_reset(harp4);
	if(hw == HWUNDEF)
		l_out_err(out,"l_harp4_set:hw UNDEF value");
	else if(ptype == SAPUNDEF)
		l_out_err(out,"l_harp4_set:ptype UNDEF value");
	else if(opcode == ARPCODEUNDEF)
		l_out_err(out,"l_harp4_set:arpcode UNDEF value");
	else if(! l_mac_is(smac))
		l_out_err(out,"l_harp4_set:smac not mac address valid");
	else if(! l_ip_4isstr(sip))
		l_out_err(out,"l_harp4_set:sip not ip address valid");
	else if(! l_mac_is(dmac))
		l_out_err(out,"l_hmac3_set:dmac not mac address valid");
	else if(! l_ip_4isstr(dip))
		l_out_err(out,"l_harp4_set:dip not ip address valid");
	else
	{
		harp4->hw_=hw;
		harp4->ptype_=ptype;
		harp4->hwsize_=0x06;
		harp4->psize_=0x04;
		harp4->opcode_=opcode;
		l_str_cpy(& (harp4->smac_),smac);
		l_str_cpy(& (harp4->sip_),sip);
		l_str_cpy(& (harp4->dmac_),dmac);
		l_str_cpy(& (harp4->dip_),dip);
	}	
}

l_size l_harp4_write(l_harp4 harp4,l_buf buf,l_index point,l_out out)
{
	l_out_reset(out);
	l_word nhw;
	l_word npt;
	l_word nop;
	
	switch(harp4->hw_)
	{
		case ETH:nhw=0x01;
				break;
		case HWUNDEF:l_out_err(out,"l_harp4_write:hw not valid");
					return point;
	}
	
	if(harp4->ptype_ == IPV4)
		npt=0x800;
	else
	{
		l_out_err(out,"l_harp4_write:protocol type not valid");
		return point;
	}
	
	switch(harp4->opcode_)
	{
		case REQUEST: nop=0x01;
					  break;
		case REPLY: nop=0x02;
					  break;
		case RREQUEST: nop=0x03;
					  break;
		case RREPLY: nop=0x04;
					  break;
		case DRARPREQUEST: nop=0x05;
					  break;
		case DRARPREPLY: nop=0x06;
					  break;
		case DRARPERROR: nop=0x07;
					  break;
		case INARPREQUEST: nop=0x08;
					  break;
		case INARPREPLY: nop=0x09;
					  break;
		case ARPNAK: nop=0x0a;
					  break;
		case MARSREQUEST: nop=0x0b;
					  break;
		case MARSMULTI: nop=0x0c;
					  break;
		case MARSMSERV: nop=0x0d;
					  break;
		case MARSJOIN: nop=0x0e;
					  break;
		case MARSLEAVE: nop=0x0f;
					  break;
		case MARSNAK: nop=0x10;
					  break;
		case MARSUNSERV: nop=0x11;
					  break;
		case MARSSJOIN: nop=0x12;
					  break;
		case MARSSLEAVE: nop=0x13;
					  break;
		case MARSGRREQUEST: nop=0x14;
					  break;
		case MARSGRREPLY: nop=0x15;
					  break;
		case MARSREDIRECTMAP: nop=0x16;
					  break;
		case MAPOSUNARP: nop=0x17;
					  break;
		case ARPCODEUNDEF:l_out_err(out,"l_harp4_write:opcode not valid");
					return point;
	}
	l_buf_fwrite(buf,point,"w:w:b:b:w",nhw,npt,harp4->hwsize_,harp4->psize_,nop);
	l_mac_strtobuf(harp4->smac_,buf,point+8);
	l_ip_4strtobuf(harp4->sip_,buf,point+14);
	l_mac_strtobuf(harp4->dmac_,buf,point+18);
	l_ip_4strtobuf(harp4->dip_,buf,point+24);
	return point+28;
}

l_size l_harp4_read(l_buf buf,l_index point,l_harp4 harp4,l_out out)
{
	l_word nhw;
	l_word npt;
	l_word nop;
	l_index tmp=point;
	l_size sbuf=l_buf_size(buf);
	l_out_reset(out);
	l_harp4_reset(harp4);
	if(sbuf-tmp < 28)
	{	
		l_out_err(out,"l_harp4_read:read failed");
		return point;
	}
	l_buf_fread(buf,tmp,"w:w:b:b:w",&nhw,&npt,&(harp4->hwsize_),&(harp4->psize_),&nop);
	switch(nhw)
	{
		case 0x01:harp4->hw_=ETH;
				  break;
		default:l_out_err(out,"l_harp4_read:hw not valid");
				return point;
	}
	switch(npt)
	{
		case 0x800:harp4->ptype_=IPV4;
				    break;
		default:l_out_err(out,"l_harp4_read:ptype not valid");
				return point;	
	}
	switch(nop)
	{
		case 0x01:harp4->opcode_=REQUEST;
				  break;
		case 0x02:harp4->opcode_=REPLY;
				  break;
		case 0x03:harp4->opcode_=RREQUEST;
				  break;
		case 0x04:harp4->opcode_=RREPLY;
				  break;
		case 0x05:harp4->opcode_=DRARPREQUEST;
				  break;
		case 0x06:harp4->opcode_=DRARPREPLY;
				  break;
		case 0x07:harp4->opcode_=DRARPERROR;
				  break;
		case 0x08:harp4->opcode_=INARPREQUEST;
				  break;
		case 0x09:harp4->opcode_=INARPREPLY;
			          break;
		case 0x0a:harp4->opcode_=ARPNAK;
			          break;
		case 0x0b:harp4->opcode_=MARSREQUEST;
			          break;
		case 0x0c:harp4->opcode_=MARSMULTI;
			          break;
		case 0x0d:harp4->opcode_=MARSMSERV;
			          break;
		case 0x0e:harp4->opcode_=MARSJOIN;
			          break;
		case 0x0f:harp4->opcode_=MARSLEAVE;
			          break;
		case 0x10:harp4->opcode_=MARSNAK;
			          break;
		case 0x11:harp4->opcode_=MARSUNSERV;
			          break;
		case 0x12:harp4->opcode_=MARSSJOIN;
				  break;
		case 0x13:harp4->opcode_=MARSSLEAVE;
			          break;
		case 0x14:harp4->opcode_=MARSGRREQUEST;
			          break;
		case 0x15:harp4->opcode_= MARSGRREPLY;
				  break;
		case 0x16:harp4->opcode_=MARSREDIRECTMAP;
			          break;
		case 0x17:harp4->opcode_=MAPOSUNARP;
				  break;
		default:l_out_err(out,"l_hmac3_read:opcode not valid");
				return point;	
	}
	tmp+=8;
	harp4->smac_= l_mac_read(buf,tmp);
	harp4->sip_=l_ip_4buftostr(buf,tmp+6);
	harp4->dmac_= l_mac_read(buf,tmp+10);
	harp4->dip_=l_ip_4buftostr(buf,tmp+16);
	return tmp+20;
}
/*end extern*/
