/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

/*internal*/

void l_time_usleep(l_ulong ms)
{
	g_usleep(ms);
}

void l_time_sleep(l_ulong s)
{
	l_time_usleep(s*1000000);	
}

l_time l_time_new()
{
	l_time time;
	GTimeVal val;
	g_get_current_time(&val); 
	time=(l_time)val.tv_sec+((l_time)val.tv_usec)/1000000;
	return  time;		
}

l_time l_time_get(l_time itime)
{
	l_time time;
	GTimeVal val;
	g_get_current_time(&val); 
	time=(l_time)val.tv_sec+((l_time)val.tv_usec)/1000000;
	return (time-itime);
}

/*end internal*/
