/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

#define LMSIZETABDEFAULT 64

/*internal*/

l_bool l_tab_colname(const l_tab tab,const l_str name,l_index *col)
{
	l_index i;
	for(i=0;i<l_abuf_size(tab->named_);i++)
	{
		if(l_str_cmp(name,(l_str)l_abuf_getmem(tab->named_,i,0))==0)
		{
			(*col)=i;
			return TRUE;	
		}	
	}
	return FALSE;
}

/*end internal*/

/*extern*/

l_tab l_tab_new()
{
	l_index i;
	l_tab ret=l_mem_malloc0(sizeof(struct table));
	ret->named_=l_abuf_new();
	ret->msize_=LMSIZETABDEFAULT;
	ret->mem_=(l_abuf *) l_mem_malloc0(ret->msize_*sizeof(l_abuf));
	ret->size_=0;
	for(i=0;i<ret->msize_;i++)
		(ret->mem_)[i]=l_abuf_new();	
	return ret;
}

void l_tab_reset(l_tab tab)
{
	l_index i;
	l_abuf_reset(tab->named_);
	for(i=0;i<l_tab_sizerow(tab);i++)
		l_abuf_reset((tab->mem_)[i]);
	tab->size_=0;	
}

l_size l_tab_sizerow(const l_tab tab)
{
	return tab->size_;	
}

l_size l_tab_sizecol(const l_tab tab,l_index rindex)
{
	if(rindex < l_tab_sizerow(tab))
		return l_abuf_size((tab->mem_)[rindex]);
	return 0;	
}

l_size l_tab_newsize(l_tab tab,l_size size)
{
	l_size nsize,s=l_tab_sizerow(tab);
	l_abuf *tmp;
	l_index i;
	if(size < s)
	{
		for(i=size;i<s;i++)
			l_abuf_reset((tab->mem_)[i]);
		tab->size_=size;
	} 
	else if (size > s)
	{
		nsize=tab->msize_;
		while(nsize < size)
			nsize *=2;
		if(nsize > tab->msize_)
		{
			tmp=(l_abuf *) l_mem_malloc0(nsize);
			for(i=0;i<s;i++)
				tmp[i]=(tab->mem_)[i];
			for(i=s;i<nsize;i++)
				tmp[i]=l_abuf_new();
			l_mem_freezero((void **) &(tab->mem_),tab->msize_);
			tab->mem_=tmp;
			tab->msize_=nsize;
		}
		tab->size_=size;
	}
	return l_tab_sizerow(tab);		
}



void l_tab_name(l_tab tab,const l_str name,l_index col)
{
	l_index c;
	if(! l_tab_colname(tab,name,&c))
		l_abuf_nwrite(tab->named_,col,0,(void *)name,l_str_len(name));	
}

void l_tab_rname(l_tab tab,l_index col)
{
	l_abuf_resetbuf(tab->named_,col);	
}

void l_tab_get(const l_tab tab,l_index row,l_index col,l_buf obuf)
{
	if(row < l_tab_sizerow(tab))
		l_abuf_get((tab->mem_)[row],col,obuf);
}

void l_tab_getn(const l_tab tab,l_index row,const l_str name,l_buf obuf)
{
	l_index col;
	if(l_tab_colname(tab,name,&col))
		l_tab_get(tab,row,col,obuf);	
}

void l_tab_getrm(l_tab tab,l_index row,l_index col,l_buf obuf)
{
	if(row < l_tab_sizerow(tab))
		l_abuf_getrm((tab->mem_)[row],col,obuf);
}

void l_tab_getrmn(l_tab tab,l_index row,const l_str name,l_buf obuf)
{
	l_index col;
	if(l_tab_colname(tab,name,&col))
		l_tab_getrm(tab,row,col,obuf);
}

void l_tab_set(l_tab tab,l_index row,l_index col,const l_buf buf)
{
	if(l_tab_sizerow(tab)<=row)
		l_tab_newsize(tab,row+1);
	l_abuf_set((tab->mem_)[row],col,buf); 	
}

void l_tab_setn(l_tab tab,l_index row,l_str name,const l_buf buf)
{
	l_index col;
	if(l_tab_colname(tab,name,&col))
		l_tab_set(tab,row,col,buf);
}

l_buf l_tab_getbuf(const l_tab tab,l_index row,l_index col)
{
	if(row < l_tab_sizerow(tab))
		return  l_abuf_getbuf((tab->mem_)[row],col);
	return 0;
}

l_buf l_tab_getbufn(const l_tab tab,l_index row,const l_str name)
{
	l_index col;
	if(l_tab_colname(tab,name,&col))
		return  l_abuf_getbuf((tab->mem_)[row],col);
	return 0;
}

void *l_tab_getmem(const l_tab tab,l_index row,l_index col,l_index point)
{
	l_buf ret=	 l_tab_getbuf(tab,row,col);
	if(ret != 0)
		return l_buf_mem(ret,point);
	return 0;
}

void *l_tab_getmemn(const l_tab tab,l_index row,const l_str name,l_index point)
{
	l_index col;
	if(l_tab_colname(tab,name,&col))
		return l_tab_getmem(tab,row,col,point);
	return 0;
}

l_size l_tab_write(l_tab tab,l_index row,l_index col,l_index point,void *mem,l_size len)
{
	l_buf buf=l_tab_getbuf(tab,row,col);
	l_size size;
	if(buf == 0)
	{
		buf=l_buf_new();
		size=l_buf_nwrite(buf,point,mem,len);
		l_tab_set(tab,row,col,buf);
		l_buf_free(&buf);
		return size;
	}
	else
		return l_buf_write(buf,point,mem,len);
}

l_size l_tab_writen(l_tab tab,l_index row,const l_str name,l_index point,void *mem,l_size len)
{
	l_index col;	
	if(l_tab_colname(tab,name,&col))
		return l_tab_write(tab,row,col,point,mem,len);
	return 0;
}

l_size l_tab_nwrite(l_tab tab,l_index  row,l_index col,l_index point,void *mem,l_size len)
{
	l_buf buf=l_tab_getbuf(tab,row,col);
	l_size size;
	if(buf == 0)
	{
		buf=l_buf_new();
		size=l_buf_nwrite(buf,point,mem,len);
		l_tab_set(tab,row,col,buf);
		l_buf_free(&buf);
		return size;
	}
	else
		return l_buf_nwrite(buf,point,mem,len);
}

l_size l_tab_nwriten(l_tab tab,l_index  row,const l_str name,l_index point,void *mem,l_size len)
{
	l_index col;	
	if(l_tab_colname(tab,name,&col))
		return l_tab_nwrite(tab,row,col,point,mem,len);
	return 0;
}

l_size l_tab_cwrite(l_tab tab,l_index row,l_index col,void *mem,l_size len)
{
	l_buf buf=l_tab_getbuf(tab,row,col);
	l_size size;
	if(buf == 0)
	{
		buf=l_buf_new();
		size=l_buf_nwrite(buf,0,mem,len);
		l_tab_set(tab,row,col,buf);
		l_buf_free(&buf);
		return size;
	}
	else
		return l_buf_cwrite(buf,mem,len);	
	
}

l_size l_tab_cwriten(l_tab tab,l_index row,const l_str name,void *mem,l_size len)
{
	l_index col;	
	if(l_tab_colname(tab,name,&col))
		return l_tab_cwrite(tab,row,col,mem,len);
	return 0;	
}

void l_tab_free(l_tab *ptab)
{
	l_index i;
	for(i=0;i<(*ptab)->msize_;i++)
		l_abuf_free(&((*ptab)->mem_)[i]);
	l_mem_freezero((void **)ptab,sizeof(struct table));	
}

/*end extern*/
