/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

/*internal*/

void l_std_debug(const l_str fmt, ...)
{
   #ifdef LDEBUG	
	va_list ap;
	va_start(ap,fmt);
	l_std_out("lupin debug>");
        g_vfprintf(stdout,fmt,ap);
	va_end(ap);
	l_std_out("\n");
    #endif
}

/*end internal*/

/*extern*/

void l_lupin()
{
	l_std_out("Welcome to lupin\n");	
}

void l_std_out(const l_str fmt,...)
{
	va_list ap;
	va_start(ap,fmt);
	g_vfprintf(stdout,fmt,ap);
	va_end(ap);	
}

void l_std_err(const l_str fmt,...)
{
	va_list ap;
	va_start(ap,fmt);
	g_vfprintf(stderr,fmt,ap);
	va_end(ap);	
}

void l_std_in(l_buf buf)
{
	l_buf_reset(buf);
	l_byte val;
	l_index i=0;	
	while(1)
	{	
		val=(l_byte) getchar();
		if(val == '\n')
			break;
		else
			l_buf_fwrite(buf,i,"b",val);
		i++;
	}
}

void l_std_exit(l_bool failure,l_fexit e)
{
	if( e != 0)
		(*e)();
	if (failure)
		exit(EXIT_FAILURE);
	else
		exit(EXIT_SUCCESS);
}

void l_std_error(const l_str msg)
{
	l_std_err("%s\n",msg);
	l_std_exit(TRUE,0);	
}

l_file l_std_openfile(const l_str path,const l_str mode,l_out out)
{
	l_file file=(l_file)fopen(path,mode);
	if(file == 0)
		l_out_err(out,"l_std_openfile:%s",l_str_error(errno));
	return file;	
}
 
void l_std_fileclose(l_file *pfile)
{
	if((*pfile) != 0)
	{
		fclose((FILE *)(*pfile));
		(*pfile) = 0;
	}
 }
 
l_size l_std_filereadline(l_file file,l_buf obuf,l_index point,l_out out)
{
	l_int32 c;
	l_byte tmp;
	l_size s=0;
	if(file != 0)
	{
		while((c=fgetc((FILE *)file)) != EOF)
		{
			tmp=(l_byte) c;
			if(tmp != '\n')
			{	
				s++;
				l_buf_fwrite(obuf,point++,"b",tmp);
			}
			else
				break;
		}
		if(c==EOF && s == 0)
			l_out_err(out,"l_std_filereadline:EOF");
	}
	else
		l_out_err(out,"l_std_filereadline:file null");
	return s;
}

/*end extern*/
