/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include  "../core.h"

/*internal*/

void l_out_ok(l_out out,const l_str fmt,...)
{
	l_str tmp=l_str_new();
	l_str_alloc(&tmp,L_MAXSTRWRITE);
	va_list ap;
	va_start(ap,fmt);
	g_vsprintf(tmp,fmt,ap);
	va_end(ap);
	l_buf_nwrite(out->stdout_,0,tmp,l_str_len(tmp));
	l_str_free(&tmp);
	l_buf_reset(out->stderr_);
	out->retvalue_=LOK;
}

void l_out_err(l_out out,const l_str fmt,...)
{
	l_str tmp=l_str_new();
	l_str_alloc(&tmp,L_MAXSTRWRITE);
	va_list ap;
	va_start(ap,fmt);
	g_vsprintf(tmp,fmt,ap);
	va_end(ap);
	l_buf_nwrite(out->stderr_,0,tmp,l_str_len(tmp));
	l_str_free(&tmp);
	l_buf_reset(out->stdout_);
	out->retvalue_=LERR;
}

void l_out_cok(l_out out,const l_str fmt,...)
{
	l_str tmp=l_str_new();
	l_str_alloc(&tmp,L_MAXSTRWRITE);
	va_list ap;
	va_start(ap,fmt);
	g_vsprintf(tmp,fmt,ap);
	va_end(ap);
	if(l_buf_size(out->stdout_) == 0)
		l_buf_nwrite(out->stdout_,0,tmp,l_str_len(tmp));
	else
	{	
		l_buf_cwrite(out->stdout_,"\n",1);
		l_buf_cwrite(out->stdout_,tmp,l_str_len(tmp));
		
	}
	l_str_free(&tmp);
	out->retvalue_=LOK;
}

void l_out_cerr(l_out out,const l_str fmt,...)
{
	l_str tmp=l_str_new();
	l_str_alloc(&tmp,L_MAXSTRWRITE);
	va_list ap;
	va_start(ap,fmt);
	g_vsprintf(tmp,fmt,ap);
	va_end(ap);
	if(l_buf_size(out->stderr_) == 0)
		l_buf_nwrite(out->stderr_,0,tmp,l_str_len(tmp));
	else
	{	
		l_buf_cwrite(out->stderr_,"\n",1);
		l_buf_cwrite(out->stderr_,tmp,l_str_len(tmp));
		
	}
	l_str_free(&tmp);
	out->retvalue_=LERR;
}

void l_out_bok(l_out out,const l_buf buf,l_num point)
{
	l_out_reset(out);
	l_buf_copymem(out->stdout_,0,buf,point,l_buf_size(buf)-point);
	out->retvalue_=LOK;
}

void l_out_berr(l_out out,const l_buf buf,l_num point)
{
	l_out_reset(out);
	l_buf_copymem(out->stderr_,0,buf,point,l_buf_size(buf)-point);
	out->retvalue_=LERR;
}

void l_out_reset(l_out out)
{
	out->retvalue_=LUNDEF;
	l_buf_reset(out->stdout_);
	l_buf_reset(out->stderr_);
}

/*end internal*/

/*extern*/

l_out l_out_new()
{
	l_out out = l_mem_malloc(sizeof (struct out));
	out->retvalue_=LUNDEF;
	out->stderr_=l_buf_new();
	out->stdout_=l_buf_new();	
	return out;
}

void l_out_free(l_out *pout)
{
	l_buf_free(&(*pout)->stderr_);	
	l_buf_free(&(*pout)->stdout_);
	l_mem_free((void **)pout);
}

void l_out_print(const l_out out)
{
	l_byte b;
	switch(out->retvalue_)
	{
		case LOK:  l_buf_out(out->stdout_);
				  if((b=l_buf_byte(out->stdout_,l_buf_size(out->stdout_)-1)) != '\n')
					l_std_out("\n");
				  break;
		case LERR:l_buf_err(out->stderr_);
				  if((b=l_buf_byte(out->stderr_,l_buf_size(out->stderr_)-1)) != '\n')
					l_std_err("\n");
				  break;
		case LUNDEF:break;
	}		
}

void l_out_sprint(const l_out out,l_str *pstr)
{
	switch(out->retvalue_)
	{
		case LOK:   l_buf_tostr(out->stdout_,0,pstr,l_buf_size(out->stdout_));
				  break;
		case LERR: l_buf_tostr(out->stderr_,0,pstr,l_buf_size(out->stderr_));
				   break;
		case LUNDEF:l_str_free(pstr);
				      break;
	}	
}

l_bool l_out_iserr(l_out out)
{
	if(out->retvalue_ == LERR)
		return TRUE;
	return FALSE;	
}

void l_out_assert(l_out out,l_fexit e)
{
	if(l_out_iserr(out))
	{
		l_out_print(out);
		l_std_exit(TRUE,e);
	}		
}

/*end extern*/

