/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

/*internal*/

void *l_mem_null()
{
	return 0;	
}

void l_mem_bzero(void *s,l_size len)
{
	memset(s,'\0',len);	
}

void l_mem_freezero(void **mem,l_size size)
{
	if((*mem) != 0)
	{	
		l_mem_bzero((*mem),size);
		l_mem_free(mem);
	}
}

void l_mem_cpy(void *dst,void *src,l_size n)
{
	if(n != 0)
		memcpy(dst,src,n);
}

void *l_mem_malloc(l_size nbytes)
{
	return g_malloc(nbytes);	
}

void *l_mem_malloc0(l_size nbytes)
{
	return g_malloc0(nbytes);	
}

void l_mem_free(void **ptr)
{
	if((*ptr) != 0)
	{
		g_free((*ptr));
		(*ptr) = 0;
	}		
}

/*end internal*/
