/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include "../core.h"

/*internal*/

l_bool l_mac_is(const l_str str)
{
	l_num i,len;
	l_bool ret=TRUE;
	l_str s;
	l_split split =l_str_split(str,":");
	if(l_str_nsplit(split) !=  MACADDRLEN)
		ret=FALSE;
	else
	{
		for(i=0;i<MACADDRLEN;i++)
		{
			s=l_str_rsplit(split,i);
			len=l_str_len(s);
			if(len > 2 || len==0)
			{
				ret=FALSE;
				break;	
			}
			if(! l_str_isxdigit(s))
			{
				ret=FALSE;
				l_str_freesplit(&split);	
				break;	
			}	
		}
	}
	l_str_freesplit(&split);
	return ret;
}

l_str l_mac_incrdigit(const l_str mac,l_num pos)
{
	l_num i,len,ns,ps;
	l_bool ret=TRUE;
	l_str s;
	l_str sret=l_str_new();
	if(pos > 11)
		return FALSE;
	else
	{
		ns=(l_num) pos/2;
		ps=(l_num) pos%2;
	}		
	l_split split =l_str_split(mac,":");
	if(l_str_nsplit(split) !=  MACADDRLEN)
		ret=FALSE;
	else
	{
		for(i=0;i<MACADDRLEN;i++)
		{
			s=l_str_rsplit(split,i);
			len=l_str_len(s);
			if(len > 2 || len==0)
			{
				ret=FALSE;
				break;	
			}
			if(! l_str_isxdigit(s))
			{
				ret=FALSE;
				l_str_freesplit(&split);	
				break;	
			}	
			if(i!=ns)
			{	
				if(len == 1)
					l_str_cat(&sret,"0");
			}
			else
			{
				if(len==2)
				{
					if(ps==0)
						l_digit_incrx(&s[0]);
					else
						l_digit_incrx(&s[1]);
						
				}
				else
				{
					if(ps == 0)
						l_str_cat(&sret,"1");
					else
					{	
						l_str_cat(&sret,"0");
						l_digit_incrx(&s[1]);
					}
				}		
			}
			l_str_cat(&sret,s);
			if(i!=5)
				l_str_cat(&sret,":");
		}
	}
	l_str_freesplit(&split);
	if(!ret)
		l_str_free(&sret);
	return sret;
}

l_str l_mac_read(l_buf buf,l_num point)
{
	l_byte m[MACADDRLEN];
	l_str str;
	if(l_buf_size(buf)-point < MACADDRLEN)
		return 0;	
	l_buf_fread(buf,point,"b:b:b:b:b:b",&m[0],&m[1],&m[2],&m[3],&m[4],&m[5]);
	str=l_str_new();
	l_str_write(&str,"%02x:%02x:%02x:%02x:%02x:%02x",m[0],m[1],m[2],m[3],m[4],m[5]);
	return str;
}

/*end internal*/

/*extern*/

l_bool l_mac_strtobuf(const l_str str,l_buf buf,l_num point)
{
	l_num i,len,j;
	l_str s;
	l_uchar vect[MACADDRLEN];
	l_mem_bzero(vect,6);
	l_split split =l_str_split(str,":");
	if(l_str_nsplit(split) !=  MACADDRLEN)
	{
		l_str_freesplit(&split);	
		return FALSE;		
	}
	else
	{
		for(i=0;i<MACADDRLEN;i++)
		{
			s=l_str_rsplit(split,i);
			len=l_str_len(s);
			if(len > 2 || len==0)
			{
				l_str_freesplit(&split);	
				return FALSE;		
			}
			if(! l_str_isxdigit(s))
			{
				l_str_freesplit(&split);	
				return FALSE;	
			}	
			for(j=0;j<len;j++)
				vect[i] = (vect[i] << 4) + (l_byte)  l_digit_asciix(s[j]);
		}
	}
	l_buf_fwrite(buf,point,"b:b:b:b:b:b",vect[0],vect[1],vect[2],vect[3],vect[4],vect[5]);
	l_str_freesplit(&split);
	return TRUE;
}

/*end extern*/
