/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include  "../core.h"

/*internal*/

void l_hash_keydestroy (gpointer key)
{
	l_str_free((l_str *) (&key));	
}

void l_hash_datadestroy(gpointer data)
{
	l_dh tmp=(l_dh) data;
	l_abuf_free(&(tmp->data_));
	l_mem_freezero(data,sizeof(struct datahash));	
}

/*end internal*/

/*extern*/

l_hash l_hash_new()
{
	l_hash hash =(void *) g_hash_table_new_full(g_str_hash,g_str_equal,l_hash_keydestroy,l_hash_datadestroy); 	
	return hash;
}

void l_hash_free(l_hash *phash)
{
	if((*phash) != 0)
	{	
		g_hash_table_destroy ((GHashTable *)(*phash));
		(*phash)=0;
	}
}

void l_hash_insert(l_hash hash,l_str key,l_abuf data,l_fhash funz)
{
	l_dh val=(l_dh)l_mem_malloc0(sizeof(struct datahash));
	l_str tmp=l_str_new();
	val->data_=data;
	val->funz_=funz;
	l_str_cpy(&tmp,key);
	g_hash_table_insert((GHashTable *)hash,(gpointer) tmp,(gpointer) val); 
}

l_size l_hash_size(l_hash hash)
{
	return (l_size) g_hash_table_size((GHashTable*)hash); 	
}

l_abuf l_hash_search(l_hash hash,l_str key)
{
	l_dh dh=(l_dh)g_hash_table_lookup ((GHashTable *)hash,(gpointer) key);
	if(dh != 0)
		return (l_abuf) (dh->data_);	
	return 0;
}

l_bool l_hash_exec(l_hash hash,l_str key,l_abuf args)
{
	l_dh dh=(l_dh)g_hash_table_lookup ((GHashTable *)hash,(gpointer) key);
	if(dh != 0 && (dh->funz_) != 0)
	{	
		(*(dh->funz_))(dh->data_,args);
		return TRUE;
	}
	return FALSE;
}

void l_hash_remove(l_hash hash,l_str key)
{
	 g_hash_table_remove((GHashTable *)hash,(gpointer)(key)); 	
}

void l_hash_reset(l_hash hash)
{
	g_hash_table_remove_all((GHashTable *)hash);
}

void l_hash_allkey(l_hash hash,l_abuf okey)
{
	l_index i;
	GList *list=g_hash_table_get_keys((GHashTable *)hash);
	GList *tmp=list;
	for(i=0;i<g_list_length(list);i++)
	{
		l_abuf_nwrite (okey,l_abuf_size(okey),0,tmp->data,l_str_len((l_str) (tmp->data)));
		tmp=tmp->next; 
	}
	g_list_free(list);	
}


/*end extern*/
