/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include "../core.h"

/*extern*/

 void l_fs_mkdir(const l_str path,l_out out)
{
	l_str tmp=l_str_new();
	l_split split;
	l_int32 i,code;
	struct stat  st;

	if(l_str_len(path) == 0)
		l_out_err(out,"l_fs_mkdir:path len 0");
	else
	{	
		if(path[0] == '/')
			l_str_cpy(&tmp,"/");
		split=l_str_split(path,"/");
		for(i=0;i<l_str_nsplit(split);i++)
		{
			l_str_cwrite(&tmp,"/%s",l_str_rsplit(split,i));
			if (stat(tmp, &st) != 0)
			{
				if ((code=mkdir(tmp,0700)) != 0)
				{
					l_out_err(out,l_str_error(code));
					break;	
				}	
			}
		}
		l_str_freesplit(&split);
		l_str_free(&tmp);
	}
}

void l_fs_remove(const l_str file)
{
	remove(file);	
}

/*end extern*/

