/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
#include "../core.h"

/*internal*/

l_int32 l_digit_asciix(l_char c)
{
	return g_ascii_xdigit_value(c);
}

l_bool l_digit_is(l_char c)
{
	if(g_ascii_isdigit(c))
		return TRUE;
	return FALSE;
}

l_bool l_digit_isx(l_char c)
{
	if(g_ascii_isxdigit(c))
		return TRUE;
	return FALSE;
}

l_bool l_digit_incrx(l_char *c)
{
	l_str tmp=l_str_new();
	l_int32 v = l_digit_asciix((*c));
	if(v != -1)
	{	
		v = (v+1)%16;
		l_str_write(&tmp,"%x",v);
		(*c) = tmp[0];
		l_str_free(&tmp);
		return TRUE;
	}
	return FALSE;
}

l_str l_digit_tostr(l_int32 d)
{
	l_str str = l_str_new();
	l_str_write(&str,"%d",d);
	return str;
}

l_str l_digit_tostrx(l_int32 d)
{
	l_str str = l_str_new();
	l_str_write(&str,"%x",d);
	return str;
}

l_int32 l_digit_byte(l_byte b)
{
	l_int32 ret=0;
	ret = b;
	return ret;	
}

/*end internal*/

