/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include "../core.h"
 
/*internal*/

l_devtype l_dev_type(const l_str dev,l_out out)
{
	l_devtype dt;
	l_raw raw = l_sock_rawopen(dev,0,out);	
	if(raw == 0)
		return NOTYPE;
	switch(pcap_datalink(raw->handle_))
	{
		case DLT_EN10MB: dt=LETH;
					      break;
		default:  l_out_err(out,"l_dev_type:device not valid type");
			       dt=NOTYPE;
			       break;
	}
	l_sock_rawclose(&raw);
	return dt;	
}

l_bool l_dev_iseth(const l_str dev,l_out out)
{
	l_devtype dt=l_dev_type(dev,out);
	if(dt == NOTYPE)
		return FALSE;
	if(dt != LETH)
	{		
		l_out_err(out,"l_dev_iseth:not ethernet netcard");
		return FALSE;
	}
	return TRUE;
}

l_bool l_dev_ifinfo(const l_str dev,struct ifreq *ifreq,l_ifparinfo par,l_out out)
{
	l_int32 val;
	l_int32 fd;
	switch(par)
	{
		case HW:	val=SIOCGIFHWADDR;
					break;
		case IP:		val=SIOCGIFADDR;
					break;
		case MASK:	val=SIOCGIFNETMASK;
					break;
		default:		l_out_err(out,"l_dev_ifinfo:not parinfo valid");
					return FALSE;
	}	
	fd=socket(AF_INET,SOCK_DGRAM,0);
	if(fd < 0)
	{
		fd=socket(AF_INET6,SOCK_DGRAM,0);
		if(fd < 0)
		{
			l_out_err(out,"l_dev_ifinfo:%s",l_str_error(errno));
			return FALSE;
		}		
	
	}
	l_str_cpy2(ifreq->ifr_name,dev,IFNAMSIZ);
	if(ioctl(fd,val,ifreq) < 0)
	{	
		l_out_err(out,"l_dev_ifinfo:%s",l_str_error(errno));
		close(fd);
		return FALSE;
	}	
	close(fd);
	return TRUE;
}

l_size l_dev_bhw(const l_str dev,l_buf buf,l_num point,l_out out)
{
	struct ifreq ifreq;
	l_mem_bzero(&ifreq,sizeof(struct ifreq));
	if(l_dev_ifinfo(dev,&ifreq,HW,out))
		l_buf_write(buf,0,&ifreq.ifr_hwaddr.sa_data,MACADDRLEN);
	return l_buf_size(buf);	
}

l_str l_dev_shw(const l_str dev,l_out out)
{
	struct ifreq ifreq;
	l_str ret=l_str_new();
	l_mem_bzero(&ifreq,sizeof(struct ifreq));
	if(l_dev_ifinfo(dev,&ifreq,HW,out))
		l_str_write(&ret,"%02x:%02x:%02x:%02x:%02x:%02x",(l_uchar)ifreq.ifr_hwaddr.sa_data[0],(l_uchar)ifreq.ifr_hwaddr.sa_data[1],(l_uchar)ifreq.ifr_hwaddr.sa_data[2],(l_uchar)ifreq.ifr_hwaddr.sa_data[3],(l_uchar)ifreq.ifr_hwaddr.sa_data[4],(l_uchar)ifreq.ifr_hwaddr.sa_data[5]);
	return ret;	
}

l_str l_dev_sip(const l_str dev,l_out out)
{
	struct ifreq ifreq;
	struct sockaddr *sa;
	l_str ret=l_str_new();
	l_mem_bzero(&ifreq,sizeof(struct ifreq));
	if(l_dev_ifinfo(dev,&ifreq,IP,out))
	{	
		sa=(struct sockaddr *)&(ifreq.ifr_addr);
		ret=l_ip_top(sa,out);
	}
	return ret;
}

l_str l_dev_smask(const l_str dev,l_out out)
{
	struct ifreq ifreq;
	struct sockaddr *sa;
	l_str ret=l_str_new();
	l_mem_bzero(&ifreq,sizeof(struct ifreq));
	if(l_dev_ifinfo(dev,&ifreq,MASK,out))
	{	
		sa=(struct sockaddr *)&(ifreq.ifr_addr);
		ret=l_ip_top(sa,out);
	}
	return ret;
}

/*end internal*/
