/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

/*internal*/

l_int32 l_db_funz(void *tab,l_int32 argc, l_char **argv, l_char **colname)
{
	l_int32 i;
	l_tab tmp=(l_tab) tab;
	l_size size =l_tab_sizerow(tab);
	if(size==0)
		for(i=0;i<argc;i++)
			 l_tab_name(tmp,colname[i],i);
	for(i=0; i<argc; i++)
	{	
		if(argv[i])
			l_tab_nwriten(tmp,size,colname[i],0,(void *)argv[i],l_str_len(argv[i]));	
		else
			l_tab_nwriten(tmp,size,colname[i],0,"NULL",4);
	}
	return SQLITE_OK;	
}

/*end internal*/

/*extern function*/

l_db l_db_open(const l_str name,l_str path,l_bool newdb,l_out out)
{
	l_db db;
	if(l_str_len(name) == 0)
		return 0;
	db=(l_db)l_mem_malloc0(sizeof(struct db));
	if(l_str_len(path) == 0)
	{	
		path=l_str_new();
		l_str_write(&path,"%s/.lupin/default/",getenv("HOME"));
		l_fs_mkdir(path,out);
		l_str_write(&(db->file_),"%s%s.sqlite3",path,name);
		l_str_free(&path);
	}
	else
	{	
		l_fs_mkdir(path,out);
		l_str_write(&(db->file_),"%s%s.sqlite3",path,name);
	}
	if(newdb)
		l_fs_remove(db->file_);
	if(sqlite3_open(db->file_,(sqlite3 **) &(db->dbase_))!=SQLITE_OK)
	{	
		l_out_err(out,"l_db_open:%s",sqlite3_errmsg(db->dbase_));
		l_db_close(&db,TRUE);
		sqlite3_close(db->dbase_);
		return 0;
	}
	return db;
}

void l_db_query(l_db db,const l_str query,l_out out)
{
	l_str errmsg=l_str_new();
	if(sqlite3_exec((sqlite3 *)db->dbase_,query,0,0, &errmsg) != SQLITE_OK)
	{	
		l_out_err(out,"l_db_query:%s",errmsg);	
		sqlite3_free(errmsg);
	}
}	

void l_db_select(l_db db,const l_str squery,l_tab tab,l_out out)
{
	if(tab == 0)
	{	
		l_out_err(out,"l_db_select:paremeter tab NULL");
		return;
	}
	l_tab_reset(tab);	
	l_str errmsg=l_str_new();
	if(sqlite3_exec((sqlite3 *) db->dbase_,squery,l_db_funz,tab, &errmsg) != SQLITE_OK)
	{	
		l_out_err(out,"l_db_select:%s",errmsg);	
		sqlite3_free(errmsg);
	}
}

void l_db_close(l_db *pdb,l_bool remove)
{
	sqlite3_close((sqlite3 *)((*pdb)->dbase_));
	if(remove)
		l_fs_remove((*pdb)->file_);
	l_str_free(&((*pdb)->file_));
	l_mem_freezero((void **) pdb,sizeof(struct db));
}

/*end extern*/
