/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

/*extern functions*/

void l_crypt_md4(const l_buf input,l_buf obuf)
{
	MD4_CTX c;
	l_buf_reset(obuf);
	if(input!=0)
	{		
		MD4_Init(&c);
		MD4_Update(&c,l_buf_mem(input,0),l_buf_size(input));
		MD4_Final((l_uchar *)l_buf_alloc(obuf,MD4_DIGEST_LENGTH), &c);
	}
}

void l_crypt_md5(const l_buf input,l_buf obuf)
{
	MD5_CTX c;
	l_buf_reset(obuf);
	if(input!=0)
	{		
		MD5_Init(&c);
		MD5_Update(&c,l_buf_mem(input,0),l_buf_size(input));
		MD5_Final((l_uchar *)l_buf_alloc(obuf,MD5_DIGEST_LENGTH), &c);
	}
	
}	

void l_crypt_sha256(const l_buf input,l_buf obuf)
{
	SHA256_CTX sha256;
	l_buf_reset(obuf);
	if(input!=0)
	{
		SHA256_Init(&sha256);
		SHA256_Update(&sha256,l_buf_mem(input,0),l_buf_size(input));
		SHA256_Final((l_uchar *)l_buf_alloc(obuf, SHA256_DIGEST_LENGTH), &sha256);
	}		
}

void l_crypt_rc4(const l_buf key,const l_buf text,l_buf obuf)
{
	RC4_KEY rkey;
	l_size stext;
	l_buf_reset(obuf);
	if(key != 0 && text != 0)
	{
		stext=l_buf_size(text);
		RC4_set_key(&rkey,l_buf_size(key),l_buf_mem(key,0));
		RC4(&rkey,stext,l_buf_mem(text,0),l_buf_alloc(obuf,stext));
	}
}


/*end extern functions*/



