/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

/*extern*/ 

l_bsplit l_bsplit_new(const l_buf buf,l_index point,const l_str delimiter)
{
	l_split split;
	l_index i,j=0;
	l_str tmp;
	l_size stmp;
	l_bsplit bsplit = (l_bsplit)l_mem_malloc0(sizeof(struct bsplit));
	bsplit->pbsplit_=l_abuf_new();
	split=l_str_split((l_str) l_buf_mem(buf,point),delimiter);
	stmp=l_str_nsplit(split);
	for(i=0;i<stmp;i++)
	{
		tmp=(l_str_rsplit(split,i));
		if(l_str_len(tmp) != 0)
		{
			l_abuf_nwrite(bsplit->pbsplit_,j,0,(void *)tmp,l_str_len(tmp));
			j++;
		}
	}
	bsplit->nbsplit_=j;
	l_str_freesplit(&split);
	return bsplit;
}	

l_num l_bsplit_nsplit(const l_bsplit bsplit)
{
	return bsplit->nbsplit_;
}

l_buf l_bsplit_read(const l_bsplit bsplit,l_num n)
{
	return l_abuf_getbuf(bsplit->pbsplit_,n);
}

void *l_bsplit_memsplit(const l_bsplit bsplit,l_num n)
{
	return l_abuf_getmem(bsplit->pbsplit_,n,0);	
}

void l_bsplit_free(l_bsplit *pbsplit)
{
	l_abuf_free(&((*pbsplit)->pbsplit_));
	l_mem_freezero((void **)pbsplit,sizeof(struct bsplit));
}

/*end extern*/

