/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

#define LMSIZEABUFDEFAULT 64

/*extern*/

l_abuf l_abuf_new()
{
	l_index i;
	l_abuf ret=l_mem_malloc0(sizeof(struct arraybuffer));
	ret->msize_=LMSIZEABUFDEFAULT;
	ret->mem_=(l_buf *) l_mem_malloc0(ret->msize_*sizeof(l_buf));
	ret->size_=0;
	for(i=0;i<ret->msize_;i++)
		(ret->mem_)[i]=l_buf_new();	
	return ret;
}

l_size l_abuf_size(const l_abuf abuf)
{
	return abuf->size_;	
}

void l_abuf_reset(l_abuf abuf)
{
	l_index i;
	for(i=0;i<l_abuf_size(abuf);i++)
		l_buf_reset(l_abuf_getbuf(abuf,i));
	abuf->size_=0;
	
}

void l_abuf_resetbuf(l_abuf abuf,l_index index)
{
	if(index<l_abuf_size(abuf))
		l_buf_reset(l_abuf_getbuf(abuf,index));	
}

l_size l_abuf_newsize(l_abuf abuf,l_size size)
{
	l_size nsize,s=l_abuf_size(abuf);
	l_buf *tmp;
	l_index i;
	if(size < s)
	{
		for(i=size;i<s;i++)
			l_buf_reset((abuf->mem_)[i]);
		abuf->size_=size;
	} 
	else if (size > s)
	{
		nsize=abuf->msize_;
		while(nsize < size)
			nsize *=2;
		if(nsize > abuf->msize_)
		{
			tmp=(l_buf *) l_mem_malloc0(nsize*sizeof(l_buf));
			for(i=0;i<nsize;i++)
				tmp[i]=l_buf_new();
			for(i=0;i<l_abuf_size(abuf);i++)
			{	
				l_buf_copy(tmp[i],(abuf->mem_)[i]);
				l_buf_free(& ((abuf->mem_)[i]));
			}	
			l_mem_freezero((void **) &(abuf->mem_),abuf->msize_);
			abuf->mem_=tmp;
			abuf->msize_=nsize;
		}
		abuf->size_=size;
	}
	return l_abuf_size(abuf);	
}

void l_abuf_get(const l_abuf abuf,l_index index,l_buf obuf)
{
	l_buf_reset(obuf);
	if(index < l_abuf_size(abuf))
		l_buf_copy(obuf,(abuf->mem_)[index]);
}

void l_abuf_getrm(l_abuf abuf,l_index index,l_buf obuf)
{
	l_abuf_get(abuf,index,obuf);
	l_abuf_resetbuf(abuf,index);
}

void l_abuf_set(l_abuf abuf,l_index index,const l_buf buf)
{
	if(l_abuf_size(abuf) <= index)
		l_abuf_newsize(abuf,index+1);
	l_buf_copy((abuf->mem_)[index],buf);
}


void l_abuf_free(l_abuf *pabuf)
{
	l_index i;
	for(i=0;i<(*pabuf)->msize_;i++)
		l_buf_free(&(((*pabuf)->mem_)[i]));
	l_mem_freezero((void **)pabuf,sizeof(struct arraybuffer));
}



l_buf l_abuf_getbuf(const l_abuf abuf,l_index index)
{
	if(index < l_abuf_size(abuf))
		return (abuf->mem_)[index];
	return 0;	
}

void *l_abuf_getmem(const l_abuf abuf,l_index index,l_index point)
{
	l_buf buf=l_abuf_getbuf(abuf,index);
	if(buf != 0)
		return l_buf_mem(buf,point);
	return 0;
}

l_size l_abuf_write(l_abuf abuf,l_index index,l_index point,void *mem,l_size len)
{
	l_buf buf=l_abuf_getbuf(abuf,index);
	l_size size;
	if(buf == 0)
	{
		buf=l_buf_new();
		size=l_buf_nwrite(buf,point,mem,len);
		l_abuf_set(abuf,index,buf);
		l_buf_free(&buf);
		return size;
	}
	else
		return l_buf_write(buf,point,mem,len);
}

l_size l_abuf_nwrite(l_abuf abuf,l_index index,l_index point,void *mem,l_size len)
{
	l_buf buf=l_abuf_getbuf(abuf,index);
	l_size size;
	if(buf == 0)
	{
		buf=l_buf_new();
		size=l_buf_nwrite(buf,point,mem,len);
		l_abuf_set(abuf,index,buf);
		l_buf_free(&buf);
		return size;
	}
	else
		return l_buf_nwrite(buf,point,mem,len);
}

l_size l_abuf_cwrite(l_abuf abuf,l_index index,void *mem,l_size len)
{
	l_buf buf=l_abuf_getbuf(abuf,index);
	l_size size;
	if(buf == 0)
	{
		buf=l_buf_new();
		size=l_buf_nwrite(buf,0,mem,len);
		l_abuf_set(abuf,index,buf);
		l_buf_free(&buf);
		return size;
	}
	else
		return l_buf_cwrite(buf,mem,len);
}

/*end extern*/
