/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

/*including the main header*/

#include "config.h"
#include  "../include/lupin.h"

/*end including the main header*/

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <netdb.h>
#include <net/if.h>
	
#include <glib.h>
#include <glib/gprintf.h>
#include <pcap.h>
#include <sqlite3.h>
#include <openssl/sha.h>
#include <openssl/rc4.h>
#include  <openssl/md4.h>
#include <openssl/md5.h>
#include  <openssl/des.h>

#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <unistd.h>

#include <arpa/inet.h>

#include <errno.h>

#include <math.h>	

extern l_int32 errno;

/*including the core header*/

/*mem.c*/

void *l_mem_null();
void l_mem_bzero(void *s,l_size len);
void l_mem_freezero(void **mem,l_size size);
void l_mem_cpy(void *dst,void *src,l_size n);
void *l_mem_malloc(l_size nbytes);
void *l_mem_malloc0(l_size nbytes);
void l_mem_free(void **ptr);

/*end mem.c*/

/*time.c*/

void l_time_usleep(l_ulong ms);
void l_time_sleep(l_ulong s);
l_time l_time_new();
l_time l_time_get(l_time itime);

/*end time.c*/

/*str.c*/
#define L_MAXSTRWRITE 1024

const l_str l_str_error(l_int32 err);
const  l_str l_str_gaierror(l_int32 err);
void l_str_alloc(l_str *pstr,l_size len);
l_bool l_str_isdigit(const l_str str);
l_bool l_str_isxdigit(const l_str str);
l_bool l_str_toirange(const l_str str,l_int32 low,l_int32 up,l_int32 *ret);
l_bool l_str_tox(const l_str str,l_int32 *ret);

/*end str.c*/

/*digit.c*/

l_int32 l_digit_asciix(l_char c);
l_bool l_digit_is(l_char c);
l_bool l_digit_isx(l_char c);
l_bool l_digit_incrx(l_char *c);
l_str l_digit_tostr(l_int32 d);
l_str l_digit_tostrx(l_int32 d);
l_int32 l_digit_byte(l_byte b);

/*end digit.c*/

/*buf.c*/

void *l_buf_alloc(l_buf buf,l_size size);
void *l_buf_ext(l_buf buf,l_size size);
l_bool l_buf_sub(const l_buf buf,l_index index,const l_buf sbuf);
l_bool l_buf_substr(l_buf buf,l_index index,const l_str str);
l_bool l_buf_tokenend(const l_buf buf,const l_buf token);
l_bool l_buf_tokenendstr(const l_buf buf,const l_str token);

/*end buf.c*/

 /*tab.c*/
 
 l_bool l_tab_colname(const l_tab tab,const l_str name,l_index *col);
 
 /*end tab.c*/

/*out.c*/

void l_out_ok(l_out out,const l_str fmt,...);
void l_out_err(l_out out,const l_str fmt,...);
void l_out_cok(l_out out,const l_str fmt,...);
void l_out_cerr(l_out out,const l_str fmt,...);
void l_out_bok(l_out out,const l_buf buf,l_num point);
void l_out_berr(l_out out,const l_buf buf,l_num point);
void l_out_reset(l_out out);

/*end out.c*/

/*std.c*/

void l_std_debug(const l_str fmt, ...);

/*end std.c*/

/*ip.c*/

l_str l_ip_4ntoa(l_uint32 ip);
l_bool l_ip_4strtobuf(const l_str ip,l_buf obuf,l_num point);
l_bool l_ip_4isstr(const l_str ip);
l_bool l_ip_4tobuf(struct addrinfo *ip,l_buf buf,l_num point);
l_bool l_ip_4tostr(struct addrinfo *ip,l_str *str);
l_str l_ip_4buftostr(const l_buf buf,l_num point);
l_num l_ip_6strfragment(const l_str fipv6,l_buf obuf);
l_bool l_ip_6strtobuf(const l_str ip,l_buf obuf,l_num point);
l_bool l_ip_6isstr(const l_str ip);
l_int32 l_ip_type(const l_str ip,l_out out);
l_str l_ip_ntop(l_int32 af,void *src,l_out out);
l_str l_ip_top(struct sockaddr *sa,l_out out);
l_str l_ip_addrtop(struct addrinfo *ai,l_out out);
void l_ip_getstraddrinfo(void *addr,l_size saddr,l_str *host,l_str *port,l_out out);
void l_ip_getaddrinfo(struct addrinfo *ai,l_str *host,l_str *port,l_out out);
struct addrinfo *l_ip_newaddrinfo(const l_str ip,const l_str port,l_int32 socktype,l_int32 flags,l_out out);
struct addrinfo *l_ip_dupaddrinfo(struct addrinfo *ai);
void l_ip_freeaddrinfo(struct addrinfo **addr);
struct addrinfo *l_ip_getsubnetaddrinfo(const l_str ip,const l_str netmask,l_num *nhost,l_out out);
void l_ip_incraddrinfo(struct addrinfo *addr);

/*end ipc.c*/

/*mac.c*/

#define MACADDRLEN 6

l_bool l_mac_is(const l_str str);
l_str l_mac_incrdigit(const l_str mac,l_num pos);
l_str l_mac_read(l_buf buf,l_num point);

/*end mac.c*/

/*dev.c*/

typedef enum devtype {NOTYPE,LETH} l_devtype;
typedef enum ifparinfo{HW,IP,MASK} l_ifparinfo;


l_devtype l_dev_type(const l_str dev,l_out out);
l_bool l_dev_iseth(const l_str dev,l_out out);
l_bool l_dev_ifinfo(const l_str dev,struct ifreq *ifreq,l_ifparinfo par,l_out out);
l_size l_dev_bhw(const l_str dev,l_buf buf,l_num point,l_out out);
l_str l_dev_shw(const l_str dev,l_out out);
l_str l_dev_sip(const l_str dev,l_out out);
l_str l_dev_smask(const l_str dev,l_out out);

/*end dev.c*/

/*sock.c*/

l_udp l_sock_udp();
l_udp l_sock_udpdup(const l_udp udp);
void l_sock_udpsetraddr(const l_str host,const l_str port,l_udp udp,l_out out);
l_tcp l_sock_tcp();
l_raw  l_sock_raw();

/*end sock.c*/

/*db.c*/

l_int32 l_db_funz(void *tab,l_int32 argc, l_char **argv, l_char **colname);
 
/*end db.c*/

/*hash.c*/

typedef struct datahash
{
	l_abuf data_;
	l_fhash funz_;	
}*l_dh;

void l_hash_keydestroy (gpointer key);
void l_hash_datadestroy(gpointer data);

/*end hash.c*/

/*section local header*/

#include "utils.h"
#include "header.h"
#include "apps.h"

/*end section local header*/



