/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include "../core.h"
 
 /*internal*/
 
 
 /*end internal*/
 
 /*external*/
 
 l_tor l_tor_new(const l_str ip,const l_str portc,const l_str passc,const l_str ports)
{
	l_tor tor=(l_tor) l_mem_malloc0(sizeof(struct tor));
	tor->ip_=l_str_new();
	tor->portc_=l_str_new();
	tor->passc_=l_str_new();
	tor->ports_=l_str_new();
	tor->torc_=0;
	tor->socks_=0;
	if(ip != 0)
		l_str_cpy(&(tor->ip_),ip);
	else
		l_str_cpy(&(tor->ip_),"0.0.0.0");
	if(portc != 0)
		l_str_cpy(&(tor->portc_),portc);
	else
		l_str_cpy(&(tor->portc_),"0");
	if(passc != 0)
		l_str_cpy(&(tor->passc_),passc);
	else
		l_str_cpy(&(tor->passc_),"\"\"");
	if(ports != 0)
		l_str_cpy(&(tor->ports_),ports);
	else
		l_str_cpy(&(tor->ports_),"0");
	return tor;
}

void l_tor_free(l_tor *ptor)
{
	l_str_free(&((*ptor)->ip_));
	l_str_free(&((*ptor)->portc_));
	l_str_free(&((*ptor)->passc_));
	l_str_free(&((*ptor)->ports_));
	l_tor_controlclose((*ptor));
	l_mem_freezero((void **)ptor,sizeof(struct tor));
}

void l_tor_control(l_tor tor,l_out out)
{
	l_out_reset(out);
	if(tor->torc_ == 0)
	{
		tor->torc_=l_sock_tcpclient(tor->ip_,tor->portc_,out);
		if(l_out_iserr(out))
			return;
		l_sock_tcpbsendreset(tor->torc_);
		l_buf_fwrite(tor->torc_->bsend_,0,"s:s:s","authenticate \"",tor->passc_,"\"\r\n");
		l_sock_tcpsend(tor->torc_,out);
		if(! l_out_iserr(out))
		{
			l_sock_tcpbrecvreset(tor->torc_);
			l_sock_tcprecv(tor->torc_,"\r\n",out);
			if(l_out_iserr(out))
			{
				l_sock_tcpclose(& (tor->torc_));
				return;
			}
			if(l_buf_cmpstr(tor->torc_->brecv_,"250 OK") != 0)
			{	
				l_out_berr(out,tor->torc_->brecv_,0);	
				l_tor_controlclose(tor);
			}
			else
				l_out_bok(out,tor->torc_->brecv_,0);	
		}
	}
}

void l_tor_controlclose(l_tor tor)
{
	l_out out;
	if(tor->torc_ != 0)
	{
		out=l_out_new();
		l_sock_tcpbsendreset(tor->torc_);
		l_buf_fwrite(tor->torc_->bsend_,0,"s","quit\r\n");
		l_sock_tcpsend(tor->torc_,out);
		if(! l_out_iserr(out))
		{
			l_sock_tcpbrecvreset(tor->torc_);
			l_sock_tcprecv(tor->torc_,0,out);
		}
		l_out_free(&out);
		l_sock_tcpclose(&(tor->torc_));
	}
}

void l_tor_newidentity(l_tor tor,l_out out)
{
	l_out_reset(out);
	l_tor_control(tor,out);
	if(l_out_iserr(out))
		return;	
	l_sock_tcpbsendreset(tor->torc_);
	l_buf_fwrite(tor->torc_->bsend_,0,"s","SIGNAL NEWNYM\r\n");
	l_sock_tcpsend(tor->torc_,out);
	if(! l_out_iserr(out))
	{
		l_sock_tcpbrecvreset(tor->torc_);
		l_sock_tcprecv(tor->torc_,"\r\n",out);
		if(! l_out_iserr(out))
			l_out_bok(out,tor->torc_->brecv_,0);
		l_time_sleep(2);	
	}		
}

void l_tor_resolve(l_tor tor,const l_str host,l_str *ip,l_out out)
{
	l_buf tmp=0;
	l_bsplit split1,split2;
	l_index i,tot,prove;
	l_out_reset(out);
	switch(l_ip_type(host,out))
	{
		case AF_INET:l_str_cpy(ip,host);
			      return;
		case AF_INET6:l_str_cpy(ip,host);
			       return;
	}
	l_out_reset(out);
	l_tor_control(tor,out);
	if(! l_out_iserr(out))
	{
		tmp=l_buf_new();
		for(prove=0;prove<5;prove++)
		{	
			l_sock_tcpbsendreset(tor->torc_);
			l_buf_fwrite(tor->torc_->bsend_,0,"s:s:s","resolve ",host,"\r\n");
			l_sock_tcpsend(tor->torc_,out);
			if(l_out_iserr(out))
				break;
			l_sock_tcpbrecvreset(tor->torc_);
			l_sock_tcprecv(tor->torc_,0,out);
			if(l_out_iserr(out))
				break;
			l_time_sleep(1);
			l_sock_tcpbsendreset(tor->torc_);
			l_buf_fwrite(tor->torc_->bsend_,0,"s","getinfo address-mappings/cache\r\n");
			l_sock_tcpsend(tor->torc_,out);
			if(l_out_iserr(out))
				break;
			l_sock_tcpbrecvreset(tor->torc_);
			l_sock_tcprecv(tor->torc_,"250 OK\r\n",out);
			if(l_out_iserr(out))
				break;
			l_buf_nwrite(tmp,0,(void *)"250-",4);	
			if(l_buf_sub(tor->torc_->brecv_,0,tmp))
			{
				split1=l_bsplit_new(tor->torc_->brecv_,27," ");
				if(l_bsplit_nsplit(split1) > 2)
				{
					if(l_str_cmp((const l_str)l_buf_mem(l_bsplit_read(split1,0),0),host) == 0)
					{	
						l_str_cpy(ip,(const l_str)l_buf_mem(l_bsplit_read(split1,1),0));
						break;
					}
				}
				l_bsplit_free(&split1);
			}
			else
			{
				split1=l_bsplit_new(tor->torc_->brecv_,0,"\n");
				tot=l_bsplit_nsplit(split1)-1;
				for(i=1;i<tot;i++)
				{
					split2=l_bsplit_new(l_bsplit_read(split1,i),0," ");
					if(l_str_cmp((const l_str)l_buf_mem(l_bsplit_read(split2,0),0),host) == 0)
					{	
						l_str_cpy(ip,(const l_str)l_buf_mem(l_bsplit_read(split2,1),0));
						l_bsplit_free(&split2);	
						break;
					}
				}
				l_bsplit_free(&split1);
				if(i!= tot)
					break;
			}
		}
		l_buf_free(&tmp);
		if(prove==5)
			l_out_err(out,"l_tor_resolve:Host %s not found",host);
	}		
}

 /*end external*/
 