/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include  "../core.h"

/*internal*/

void l_tcp_info(l_tcp tcp,l_out out)
{
	l_sock_tcprecv(tcp,0,out);
	if(! l_out_iserr(out))
		l_out_bok(out,tcp->brecv_,0);
	else
		l_out_ok(out,"no server info",0);
}


/*end internal*/

/*extern*/

void l_http_options(const l_str host,const l_str port,l_out out)
{
	l_tcp stcp=l_sock_tcpclient(host,port,out);
	if(! l_out_iserr(out))
	{	
		l_sock_tcpTimeout(stcp,2.0,out);
		l_buf_nwrite(stcp->bsend_,0,(void *)"OPTIONS / HTTP/1.0\r\n\r\n",22);
		l_sock_tcpsend(stcp,out);
		if(! l_out_iserr(out))
		{
			l_sock_tcprecv(stcp,"\r\n\r\n",out);
			if(!l_out_iserr(out))
				l_out_bok(out,stcp->brecv_,0);
		}
	}		
	l_sock_tcpclose(&stcp);
}

void l_tcp_scan(l_str host,l_str port,l_bool info,l_out out)
{
	l_tcp tcp=l_sock_tcpclient(host,port,out);
	l_sock_tcpTimeout(tcp,2.0,out);
	if((! l_out_iserr(out)) && info)
		l_tcp_info(tcp,out);
	l_sock_tcpclose(&tcp);	
}

void l_ftp_scan(l_str host,l_str port,l_out out)
{
	l_tcp tcp=l_sock_tcpclient(host,port,out);
	l_buf ret=l_buf_new();
	if(! l_out_iserr(out))
	{
		l_sock_tcpTimeout(tcp,2.0,out);
		l_sock_tcprecv(tcp,0,out);
		l_buf_copy(ret,tcp->brecv_);
		if(! l_out_iserr(out))
		{
			l_sock_tcpbsendreset(tcp);
			l_hftp_user("anonymous",tcp->bsend_,0);
			l_sock_tcpsend(tcp,out);
			if(!l_out_iserr(out))
			{
				l_sock_tcpbrecvreset(tcp);
				l_sock_tcprecv(tcp,0,out);
				if(! l_out_iserr(out))
				{	
					l_sock_tcpbsendreset(tcp);
					l_hftp_pass("anon@anon",tcp->bsend_,0);
					l_sock_tcpsend(tcp,out);
					if(! l_out_iserr(out))
					{
						l_sock_tcpbrecvreset(tcp);
						l_sock_tcprecv(tcp,0,out);
						if(! l_out_iserr(out) && l_buf_substr(tcp->brecv_,0,"230"))
						{
							l_buf_fwrite(ret,l_buf_size(ret),"s","(anonymous)");
							l_out_bok(out,ret,0);
						}
						else
						{
							l_buf_fwrite(ret,l_buf_size(ret),"s","(no anonymous)");
							l_out_bok(out,ret,0);
						}
					}		
				}
			}		
		}	
	}
	l_buf_free(&ret);
	l_sock_tcpclose(&tcp);
}

/*end extern*/
