/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

/**
	*\file lupin.h
	*\author Marco Guastella(contact:vasta@ragnu.it)
	*\brief Main header file
*/

#ifndef	_LIBLUPIN_H
#define	_LIBLUPIN_H	1

#ifdef __cplusplus
extern "C" {
#endif

/**
	\defgroup version version library
*/

/**
	*\ingroup version 
	*\brief  major version
*/
	
#define LIBLUPIN_VERSION_MAJOR   0

/**
	*\ingroup version 
	*\brief  minor version
*/
	
#define LIBLUPIN_VERSION_MINOR   2

/**
	*\ingroup version 
	*\brief  sub version
*/

#define LIBLUPIN_VERSION_SUB       3

/**
	*\ingroup version 
	*\brief  release type
*/

#define LIBLUPIN_RELEASE "alpha"

/**
	\defgroup type type identifier
*/
	
/**
	*\ingroup type 
	*\brief  char type
*/
typedef char l_char;

/**
	*\ingroup type 
	*\brief  unsigned char type
*/
typedef unsigned char l_uchar;
	
/**
	*\ingroup type 
	*\brief  32 bit integer type
*/
typedef int l_int32;

/**
	*\ingroup type 
	*\brief  unsigned 32 bit integer type
*/
typedef unsigned int l_uint32;

/**
	*\ingroup type 
	*\brief  16 bit integer type
*/
typedef short int l_int16;

/**
	*\ingroup type 
	*\brief  16 bit unsigned integer type
*/
typedef short int l_uint16;

/**
	*\ingroup type 
	*\brief  long type
*/
typedef unsigned long l_long;

/**
	*\ingroup type 
	*\brief  unsigned long type
*/
typedef unsigned long l_ulong;

/**
	*\ingroup type 
	*\brief  double type
*/
typedef double l_double;

/**
	*\ingroup type 
	*\brief  counter element type
*/
typedef unsigned long l_num;

/**
	*\ingroup type 
	*\brief  index type
*/

typedef unsigned long l_index;

/**
	*\ingroup type 
	*\brief  size type
*/
typedef unsigned long l_size;

/**
	*\ingroup type 
	*\brief  time type
*/
typedef double l_time;

/**
	*\ingroup type 
	*\brief  byte type
*/
typedef unsigned char l_byte;

/**
	*\ingroup type 
	*\brief  word 16 bits type
*/
typedef unsigned short int l_word;

/**
	*\ingroup type 
	*\brief  double word 32 bits type
*/
typedef unsigned long int l_dword;

/**
	*\ingroup type
	\brief file type
*/
typedef void *l_file;

/**
	*\ingroup type 
	*\brief  boolean(TRUE,FALSE) type 
*/
typedef int l_bool;

#ifndef TRUE
	/**
	*\ingroup type 
	*\brief  true boolean 
	*/
	#define TRUE  1
#endif

#ifndef FALSE
	/**
	*\ingroup type 
	*\brief  false boolean 
	*/
	#define FALSE 0
#endif

#include "lupin-core.h"
#include "lupin-utils.h"
#include "lupin-header.h"
#include "lupin-apps.h"

#ifdef __cplusplus
}
#endif
#endif /*end lupin.h*/

