/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

/**
	*\file lupin-utils.h
	*\author Marco Guastella(contact:vasta@ragnu.it)
	*\brief Header file to utils function
*/

#ifndef	_LIBLUPINUTILS_H
#define	_LIBLUPINUTILS_H	1

/**
	\defgroup commander commander section
*/

/**
	*\ingroup commander
	*\brief	commander header type
*/
typedef struct commander
{
	/**
		*\ingroup commander
		*\brief	archive commands
	*/
	l_hash data_;
	
	/**
		*\ingroup commander
		*\brief      string displayed
	*/
	l_str visual_;	
}*l_com;

/**
	*\ingroup commander
	*\param[in] visual string displayed
	*\brief	create commander
*/
l_com l_com_new(const l_str visual);

/**
	*\ingroup commander
	*\param[in] pcom commander structure pointer
	*\brief	destroy commander
*/
void l_com_free(l_com *pcom);

/**
	*\ingroup commander
	*\param[in] com commander to insert command
	*\param[in] cmdname command name
	*\param[in] format command format
	*\param[in] brief command brief
	*\param[in] funz function performed by running the command
	*\brief	insert commander in a command
*/
void l_com_cmd(l_com com,const l_str cmdname,const l_str format,const l_str brief,l_fhash funz);

/**
	*\ingroup commander
	*\param[in] com commander
	*\param[in] cmd command to exec
	*\brief executes a command
*/
void l_com_exec(l_com com,const l_buf cmd);

/**
	*\ingroup commander
	*\param[in] com commander
	*\brief reads a command from standard input and executes it
*/	
void l_com_read(l_com com);

/**
	*\ingroup commander
	*\param[in] com commander
	*\param[in] lcmd list of commands separated by a semicolon
	*\brief executes a list of commands
*/
void l_com_list(l_com com,const l_str lcmd);

#endif /*end lupin-utils.h*/
