/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"


void l_lupin()
{
	
}

/*memory section*/

void *l_nullinit()
{
	return 0;	
}

void l_bzero(void *s,l_size len)
{
	memset(s,'\0',len);	
}

void l_memfree(void **mem,l_size size)
{
	if((*mem) != 0)
	{	
		/*#ifdef L_DEBUG
			l_debug("l_memfree:free memory (%d byte)",size);
		#endif*/
		l_bzero((*mem),size);
		l_free(mem);
	}
}

void l_memcpy(void *dst,void *src,l_size n)
{
	memcpy(dst,src,n);
}

void *l_malloc(l_size nbytes)
{
	return g_malloc(nbytes);	
}

void *l_malloc0(l_size nbytes)
{
	return g_malloc0(nbytes);	
}

void l_free(void **ptr)
{
	if((*ptr) != 0)
	{
		g_free((*ptr));
		(*ptr) = 0;
	}		
}

/*end memory section*/

/*time section*/

void l_usleep(l_ulong ms)
{
	g_usleep(ms);
}

void l_sleep(l_ulong s)
{
	l_usleep(s*1000000);	
}

l_time l_newtime()
{
	l_time time;
	GTimeVal val;
	g_get_current_time(&val); 
	time=(l_time)val.tv_sec+((l_time)val.tv_usec)/1000000;
	return  time;		
}

l_time l_gettime(l_time itime)
{
	l_time time;
	GTimeVal val;
	g_get_current_time(&val); 
	time=(l_time)val.tv_sec+((l_time)val.tv_usec)/1000000;
	return (time-itime);
}

/*std section*/

/*external function*/

void l_stdout(const l_str fmt,...)
{
	va_list ap;
	va_start(ap,fmt);
	g_vfprintf(stdout,fmt,ap);
	va_end(ap);	
}

void l_stderr(const l_str fmt,...)
{
	va_list ap;
	va_start(ap,fmt);
	g_vfprintf(stdout,fmt,ap);
	va_end(ap);	
}

/*end external functions*/

void l_debug(const l_str fmt, ...)
{
    #ifdef L_DEBUG	
	va_list ap;
	va_start(ap,fmt);
	l_stdout("lupin debug>");
        g_vfprintf(stdout,fmt,ap);
	va_end(ap);
	l_stdout("\n");
    #endif
}

/*end std section*/
