/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 /*digit section*/

l_int32 l_asciixdigit(l_char);
l_bool l_isdigit(l_char);
l_bool l_isxdigit(l_char);
l_bool l_incrxdigit(l_char *c);
l_bool l_isstrdigit(const l_str str);
l_str l_digittostr(l_int32 d);
l_int32 l_bytetodigit(l_byte b);
l_bool l_isstrxdigit(const l_str str);
l_bool l_atoirange(const l_str str,l_int32 low,l_int32 up,l_int32 *ret);
l_bool l_axtoi(const l_str str,l_int32 *ret);

/*end digit section*/

/*ip section*/
l_str l_ipv4ntoa(l_uint32 ip);
l_bool l_stripv4tobuf(const l_str ip,l_buf obuf,l_num point);
l_bool l_isstripv4(const l_str ip);
l_bool l_ipv4tobuf(struct addrinfo *ip,l_buf buf,l_num point);
l_str l_readipv4(l_buf buf,l_num point);

#define FRAGIPV6ERR 65535
l_num l_stripv6fragment(const l_str fipv6,l_buf buf);
l_bool l_stripv6tobuf(const l_str ip,l_buf obuf,l_num point);
l_bool l_isstripv6(const l_str ip);

l_int32 l_ipstrtype(const l_str ip,l_out out);

l_str l_ipntop(l_int32 af,void *src,l_out out);
l_str l_ipsockaddrtop(struct sockaddr *sa,l_out out);
l_str l_ipaddrtop(struct addrinfo *ai,l_out out);
void l_getstraddrinfo(void *addr,l_size saddr,l_str *host,l_str *port,l_out out);
void l_getaddrinfo(struct addrinfo *ai,l_str *host,l_str *port,l_out out);
struct addrinfo *l_newaddrinfo(const l_str ip,const l_str port,l_int32 socktype,l_int32 flags,l_out out);
struct addrinfo *l_dupaddrinfo(struct addrinfo *ai);
void l_freeaddrinfo(struct addrinfo **addr);
struct addrinfo *l_getsubnetaddrinfo(const l_str ip,const l_str netmask,l_num *nhost,l_out out);
void l_incraddrinfo(struct addrinfo *addr);

/*end ip section*/

/*datalink section*/

#define MACADDRLEN 6

l_bool l_isstrmac(const l_str str);
l_str l_incrdigitmac(const l_str mac,l_num pos);
l_str l_readmac(l_buf buf,l_num point);

/*end datalink section*/

/*net interfaces section*/

typedef enum devtype {NOTYPE,LETH} l_devtype;
typedef enum ifparinfo{HW,IP,MASK} l_ifparinfo;

l_devtype l_getdevtype(const l_str dev,l_out out);
l_bool l_isethdev(const l_str dev,l_out out);
l_bool l_ifinfo(const l_str dev,struct ifreq *ifreq,l_ifparinfo par,l_out out);
l_size l_getdevhw(const l_str dev,l_buf buf,l_num point,l_out out);
l_str l_getstrdevhw(const l_str dev,l_out out);
l_str l_getstrdevip(const l_str dev,l_out out);
l_str l_getstrdevmask(const l_str dev,l_out out);

/*end net interfaces section*/
