/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
#include "../core.h"

const l_str l_strerror(l_int32 err)
{
	return (const l_str) strerror(err);	
}

const  l_str l_gaistrerror(l_int32 err)
{
	return (const l_str) gai_strerror(err);
}

void l_allocstr(l_str *pstr,l_size len)
{
	l_size l=len+1;
	if((*pstr) != 0)
		l_freestr(pstr);
	(*pstr)=l_malloc0(l);
}

/*external functions*/

l_str l_newstr()
{
	/*#ifdef L_DEBUG
		l_debug("l_newstr:create new string");
	#endif*/
	return (l_str) l_nullinit();	
}

void l_freestr(l_str *pstr)
{
	l_memfree((void **)pstr,l_strlen((*pstr)));
}

l_size l_strlen(l_str str)
{
	if(str==0)
		return 0;
	return strlen(str);	
}

l_int32 l_strcmp(const l_str s1,const l_str s2)
{
	return g_strcmp0(s1,s2);	
}

l_size l_strcpy(l_str *pdst,const l_str src)
{
	l_freestr(pdst);
	(*pdst) = g_strdup(src);
	return  l_strlen((*pdst));	
}

l_size l_strcpy2(l_str dst,l_str src,l_size len)
{
	return g_strlcpy(dst,src,len);
}

l_size l_strcat(l_str *pdst,const l_str src)
{
	l_size l1=l_strlen((*pdst)),l2=l_strlen(src),l=l1+l2;
	l_str str=l_newstr();
	l_allocstr(&str,l);
	if(l1 != 0)
		g_strlcpy(str,(*pdst),l+1);
	g_strlcat(str,src,l+1);
	l_freestr(pdst);
	(*pdst)=str;
	return l;
}

l_bool l_isstrprefix(l_str str,l_str prefix)
{
	if(g_str_has_prefix(str,prefix)) 
		return TRUE;
	else
		return FALSE;
}

l_str l_strtail(l_str str,l_num pos)
{
	l_str ret=l_newstr();
	if(pos < l_strlen(str))
		l_writestr(&ret,"%s",&str[pos]);	
	return ret;	
}

l_size l_writestr(l_str *pstr,const l_str fmt,...)
{
	l_size len;
	l_str tmp=l_newstr();
	l_allocstr(&tmp,L_MAXSTRWRITE);
	va_list ap;
	va_start(ap,fmt);
	g_vsprintf(tmp,fmt,ap);
	va_end(ap);
	len=l_strcpy(pstr,tmp);
	l_freestr(&tmp);
	/*#ifdef L_DEBUG
		l_debug("l_writestr:write %d byte in buffer",len);
	#endif*/
	return len;
}

l_size l_cwritestr(l_str *pstr,const l_str fmt,...)
{
	l_size len;
	l_str tmp=l_newstr();
	l_allocstr(&tmp,L_MAXSTRWRITE);
	va_list ap;
	va_start(ap,fmt);
	g_vsprintf(tmp,fmt,ap);
	va_end(ap);
	len=l_strcat(pstr,tmp);
	l_freestr(&tmp);
	/*#ifdef L_DEBUG
		l_debug("l_cwritestr:write %d byte in buffer",len1);
	#endif*/
	return len;
}

l_size l_reducestr(l_str str,l_size len)
{
	l_size s=l_strlen(str);
	if(s > len)
	{	
		l_bzero(str+len,s-len);
		return len;
	}
	return s;	
}

l_split l_newsplit(const l_str str,const l_str delimiter)
{
	l_split split = (l_split)l_malloc0(sizeof(struct split));
	split->nsplit=0;
	if(str == 0 || delimiter == 0)
	{	
		split->psplit=l_malloc0(1);
		(split->psplit)[0] = l_malloc0(1);
	}
	else
		split->psplit=g_strsplit(str,delimiter,0);
	while((split->psplit)[(split->nsplit)] != 0)
		(split->nsplit)++;
	return split;
}	

l_num l_nsplit(l_split split)
{
	return split->nsplit;	
}

l_str l_readsplit(l_split split,l_num n)
{
	if(n>= split->nsplit)
		return 0;
	return (split->psplit)[n];	
}

void l_freesplit(l_split *psplit)
{
	g_strfreev((*psplit)->psplit);
	l_memfree((void **)psplit,sizeof(struct split));	
}

/*end external function*/
