/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include  "../core.h"

void l_ok(l_out out,const l_str fmt,...)
{
	l_str tmp=l_newstr();
	l_allocstr(&tmp,L_MAXSTRWRITE);
	va_list ap;
	va_start(ap,fmt);
	g_vsprintf(tmp,fmt,ap);
	va_end(ap);
	l_nwritebuf(out->stdout,0,tmp,l_strlen(tmp));
	l_freestr(&tmp);
	l_resetbuf(out->stderr);
	out->retvalue=LOK;
}

void l_err(l_out out,const l_str fmt,...)
{
	l_str tmp=l_newstr();
	l_allocstr(&tmp,L_MAXSTRWRITE);
	va_list ap;
	va_start(ap,fmt);
	g_vsprintf(tmp,fmt,ap);
	va_end(ap);
	l_nwritebuf(out->stderr,0,tmp,l_strlen(tmp));
	l_freestr(&tmp);
	l_resetbuf(out->stdout);
	out->retvalue=LERR;
}

void l_cok(l_out out,const l_str fmt,...)
{
	l_str tmp=l_newstr();
	l_allocstr(&tmp,L_MAXSTRWRITE);
	va_list ap;
	va_start(ap,fmt);
	g_vsprintf(tmp,fmt,ap);
	va_end(ap);
	if(l_sizebuf(out->stdout) == 0)
		l_nwritebuf(out->stdout,0,tmp,l_strlen(tmp));
	else
	{	
		l_cwritebuf(out->stdout,"\n",1);
		l_cwritebuf(out->stdout,tmp,l_strlen(tmp));
		
	}
	l_freestr(&tmp);
	out->retvalue=LOK;
}

void l_cerr(l_out out,const l_str fmt,...)
{
	l_str tmp=l_newstr();
	l_allocstr(&tmp,L_MAXSTRWRITE);
	va_list ap;
	va_start(ap,fmt);
	g_vsprintf(tmp,fmt,ap);
	va_end(ap);
	if(l_sizebuf(out->stderr) == 0)
		l_nwritebuf(out->stderr,0,tmp,l_strlen(tmp));
	else
	{	
		l_cwritebuf(out->stderr,"\n",1);
		l_cwritebuf(out->stderr,tmp,l_strlen(tmp));
		
	}
	l_freestr(&tmp);
	out->retvalue=LERR;
}

void l_bok(l_out out,l_buf buf,l_num point)
{
	l_resetout(out);
	l_copymembuf(out->stdout,0,buf,point,l_sizebuf(buf)-point);
	out->retvalue=LOK;
}

void l_resetout(l_out out)
{
	out->retvalue=LUNDEF;
	l_resetbuf(out->stdout);
	l_resetbuf(out->stderr);
}

/*external*/

l_out l_newout()
{
	l_out out = l_malloc(sizeof (struct out));
	out->retvalue=LUNDEF;
	out->stderr=l_newbuf();
	out->stdout=l_newbuf();	
	return out;
}

void l_freeout(l_out *pout)
{
	l_freebuf(&(*pout)->stderr);	
	l_freebuf(&(*pout)->stdout);
	l_free((void **)pout);
}

void l_printout(l_out out)
{
	switch(out->retvalue)
	{
		case LOK:  l_outbuf(out->stdout);
				  l_stdout("\n");
				  break;
		case LERR:l_errbuf(out->stderr);
				  l_stderr("\n");
				  break;
		case LUNDEF:break;
	}		
}

void l_sprintout(l_str *str,l_out out)
{
	switch(out->retvalue)
	{
		case LOK:   l_buftostr(out->stdout,0,str,l_sizebuf(out->stdout));
				  break;
		case LERR: l_buftostr(out->stderr,0,str,l_sizebuf(out->stderr));
				   break;
		case LUNDEF:l_freestr(str);
				      break;
	}	
}

l_bool l_isouterr(l_out out)
{
	if(out->retvalue == LERR)
		return TRUE;
	return FALSE;	
}

/*external*/
