/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */
 
 #include "../core.h"
 
 /*ethernet mac802.3*/
 
 l_size l_addethheader(const l_str dmac,const l_str smac,const l_word ptype,l_buf buf,l_num point)
{
	if(l_strmactobuf(dmac,buf,point) && l_strmactobuf(smac,buf,point+ MACADDRLEN))
		l_fwritebuf(buf,point+(2* MACADDRLEN),"w",ptype);	
	else
		l_newsizebuf(buf,point);
	return l_sizebuf(buf);
}

/*arp ipv4*/

l_size l_addarpv4header(l_word hw,l_word prot,l_word opcode,l_str smac,struct addrinfo *ipsrc,l_str dmac,struct addrinfo *ipdst,l_buf buf,l_num point)
{
	l_fwritebuf(buf,point,"w:w:b:b:w",hw,prot,0x06,0x04,opcode);
	if(!(l_strmactobuf(smac,buf,point+8) && l_ipv4tobuf(ipsrc,buf,point+14) && l_strmactobuf(dmac,buf,point+18) && l_ipv4tobuf(ipdst,buf,point+24)))
		l_newsizebuf(buf,point);
	return l_sizebuf(buf);
}
 
l_arpv4 l_newarpv4()
{
	return (l_arpv4) l_malloc0(sizeof(struct arpv4));	
}

void l_freearpv4(l_arpv4 *av4)
{
	if((*av4) != 0)
	{		
		l_freestr(&((*av4)->sip));
		l_freestr(&((*av4)->smac));
		l_freestr(&((*av4)->dip));
		l_freestr(&((*av4)->dmac));
		l_memfree((void *)av4,sizeof(struct arpv4));
	}
}

void l_resetarpv4(l_arpv4 av4)
{
	av4->hw=0;
	av4->ptype=0;
	av4->hwsize=0;
	av4->psize=0;
	av4->opcode=0;
	l_freestr(&(av4->sip));
	l_freestr(&(av4->smac));
	l_freestr(&(av4->dip));
	l_freestr(&(av4->dmac));
}

l_size l_readarpv4(l_buf buf,l_num point,l_arpv4 av4)
{
	if(l_sizebuf(buf)-point < 28)
		return 0;
	l_freadbuf(buf,point,"w:w:b:b:w",&(av4->hw),&(av4->ptype),&(av4->hwsize),&(av4->psize),&(av4->opcode));
	av4->smac=l_readmac(buf,point+8);
	av4->sip=l_readipv4(buf,point+14);
	av4->dmac=l_readmac(buf,point+18);
	av4->dip=l_readipv4(buf,point+24);
	return 28;
}
