/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

/*external functions*/

l_buf l_md5(l_buf input)
{
	l_buf buf;
	MD5_CTX c;
	if(input!=0)
	{		
		buf=l_newbuf();
		MD5_Init(&c);
		MD5_Update(&c,l_membuf(input,0),l_sizebuf(input));
		MD5_Final((l_uchar *)l_allocbuf(buf,MD5_DIGEST_LENGTH), &c);
		return buf;
	}
	return 0;
}	

l_buf l_sha256(l_buf input)
{
	l_buf buf;
	SHA256_CTX sha256;
	if(input!=0)
	{
		buf=l_newbuf();
		SHA256_Init(&sha256);
		SHA256_Update(&sha256,l_membuf(input,0),l_sizebuf(input));
		SHA256_Final((l_uchar *)l_allocbuf(buf, SHA256_DIGEST_LENGTH), &sha256);
		return buf;
	}		
	return 0;	
}

/*end external functions*/



