/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

#include "../core.h"

void *l_membuf(l_buf buf,l_num point)
{
	if(l_sizebuf(buf) <= point)
		l_extbuf(buf,point+1);
	return (buf->mem)+point;	
}

void *l_allocbuf(l_buf buf,l_size size)
{
	l_size tmp=l_sizebuf(buf);
	void *mem=l_membuf(buf,0);
	if(buf->msize < size)
	{
		while(buf->msize < size)
			buf->msize *=2;
		l_memfree(&mem,tmp);
		buf->mem = l_malloc0(buf->msize);
		buf->size=size;	
		/*#ifdef L_DEBUG
			l_debug("l_allocbuf:alloc buffer %d byte (new max size %d)",buf->size,buf->msize);
		#endif*/
	}
	else
	{
		l_bzero(mem,tmp);
		buf->size=size;
		/*#ifdef L_DEBUG
			l_debug("l_allocbuf:alloc buffer %d byte",buf->size);
		#endif*/
	}
	return l_membuf(buf,0);	
}

void *l_extbuf(l_buf buf,l_size size)
{
	l_size k=l_sizebuf(buf);
	void *tmp,*mem;
	if(buf->msize<size)
	{
		while(buf->msize<size)
			buf->msize *=2;
		tmp=l_malloc0(buf->msize);
		mem=l_membuf(buf,0);
		l_memcpy(tmp,mem,k);
		l_memfree(&mem,k);
		buf->mem=tmp;
		buf->size=size;
		/*#ifdef L_DEBUG
			l_debug("l_extbuf:extend buffer %d byte (new max size %d)",buf->size,buf->msize);
		#endif*/
	}
	else
	{	
		buf->size=size;
		/*#ifdef L_DEBUG
			l_debug("l_extbuf:extend buffer %d byte",buf->size);
		#endif*/
	}
	return l_membuf(buf,k);
}

/*external functions*/

l_buf l_newbuf()
{
	l_buf ret = l_malloc0(sizeof(struct buffer));
	ret->mem=l_malloc0(LMSIZEBUFFERDEFAULT);
	ret->size=0;
	ret->msize=LMSIZEBUFFERDEFAULT;
	/*#ifdef L_DEBUG
		l_debug("l_newbuf:create buffer");
	#endif*/
	return ret;
}

void l_freebuf(l_buf *pbuf)
{
	void *mem=l_membuf((*pbuf),0);
	l_memfree(&mem,l_sizebuf((*pbuf)));
	l_bzero((*pbuf),sizeof(struct buffer));
	l_free((void **)pbuf);	
}

l_size l_sizebuf(l_buf buf)
{
	return buf->size;
}

void l_resetbuf(l_buf buf)
{
	l_bzero(l_membuf(buf,0),l_sizebuf(buf));
	buf->size=0;
}

l_size l_newsizebuf(l_buf buf,l_size ns)
{
	if(ns < l_sizebuf(buf))
	{
		l_bzero(l_membuf(buf,ns),l_sizebuf(buf)-ns);
		buf->size=ns;
	}
	else if(ns > l_sizebuf(buf))
		l_extbuf(buf,ns);
	return l_sizebuf(buf);
}

l_byte l_bytebuf(l_buf buf,l_num nbyte)
{
	l_byte *ret;
	if(nbyte >= l_sizebuf(buf))
		return '\0';
	ret=l_membuf(buf,nbyte);
	return (*ret);	
}

l_byte l_bitseqbuf(l_buf buf,l_num a,l_num nbits)
{
	l_byte byte=0x00;
	l_num b=a+nbits-1;
	l_num num1=a/8,num2=b/8,num3=a%8,num4=b%8;
	if(nbits <= 8 && b/8<l_sizebuf(buf))
	{
		byte=(l_bytebuf(buf,num1) << num3);
		if(num2==num1)
			byte=byte>>(8-nbits);
		else
			byte=(byte>> (8-nbits)) + (l_bytebuf(buf,num2) >> (7-num4));	
	}		
	return byte;	
}


l_size l_writebuf(l_buf buf,l_num point,void *mem,l_size len)
{
	l_size tlen=point+len;
	if(l_sizebuf(buf) < tlen)
		l_extbuf(buf,tlen);
	l_memcpy(l_membuf(buf,point),mem,len);
	/*#ifdef L_DEBUG
		l_debug("l_writebuf:write %d byte in buffer",len);
	#endif*/
	return l_sizebuf(buf);
}

l_size l_nwritebuf(l_buf buf,l_num point,void *mem,l_size len)
{
	l_size tlen=point+len;
	l_allocbuf(buf,tlen);
	l_memcpy(l_membuf(buf,point),mem,len);
	/*#ifdef L_DEBUG
		l_debug("l_nwritebuf:write %d byte in buffer",buf->size);
	#endif*/
	return l_sizebuf(buf);	
}

l_size l_cwritebuf(l_buf buf,void *mem,l_size len)
{
	l_size tlen=l_sizebuf(buf)+len;
	l_memcpy(l_extbuf(buf,tlen),mem,len);	
	/*#ifdef L_DEBUG
		l_debug("l_cwritebuf:cat %d byte in buffer",len);
	#endif*/
	return l_sizebuf(buf);
}

l_size l_fwritebuf(l_buf buf,l_num point,const l_str fmt,...)
{
	l_buf tbuf;
	l_split split=l_newsplit(fmt,":");
	l_byte t,bt[8];
	l_word w;
	l_dword dv;
	l_str tmp,tmp2;
	l_size n=l_nsplit(split),i,len;
	va_list args;
	va_start(args,n);
	tbuf=l_newbuf();
	for(i=0;i<n;i++)
	{
		tmp=l_readsplit(split,i);
		if(l_strcmp(tmp,"b") == 0)
		{	
			t=(l_byte)va_arg(args,int);
			l_cwritebuf(tbuf,&t,1);
		}	
		else if(l_strcmp(tmp,"w") == 0)
		{	
			w=(l_word)va_arg(args,int);
			bt[0]= (l_byte)(w>>8);
			bt[1]=(l_byte)(w&0xFF);
			l_cwritebuf(tbuf,bt,2);
		}	
		else if(l_strcmp(tmp,"dw") == 0)
		{
			dv=(l_dword)va_arg(args,int);
			bt[0]=(l_byte) (dv >> 24);
			bt[1]=(l_byte) (dv >> 16);
			bt[2]=(l_byte) (dv >> 8);
			bt[3]=(l_byte)(dv&0xFF);
			l_cwritebuf(tbuf,bt,4);
		}
		else if(l_strcmp(tmp,"s") == 0)
		{	
			tmp2=(l_str)va_arg(args,unsigned char *);
			len=l_strlen(tmp2);
			l_cwritebuf(tbuf,tmp2,len);
		}
		else	
		{
			l_bzero(bt,8);
			l_freebuf(&tbuf);
			l_freesplit(&split);
			va_end(args);
			return l_sizebuf(buf);
		}
	}
	l_copymembuf(buf,point,tbuf,0,l_sizebuf(tbuf));
	l_bzero(bt,8);
	l_freebuf(&tbuf);
	l_freesplit(&split);
	va_end(args);
	return l_sizebuf(buf);	
}

l_size l_freadbuf(l_buf buf,l_num point,const l_str fmt,...)
{
	l_split split=l_newsplit(fmt,":"),split2;
	l_num n=l_nsplit(split),i;
	l_int32 n2;
	l_size db,t=point;
	l_byte *tb;
	l_word *tw;
	l_dword *tdw;
	l_str tmp,tmp2,*ts;
	va_list args;
	va_start(args,n);
	for(i=0;i<n;i++)
	{
		tmp=l_readsplit(split,i);
		if(l_strcmp(tmp,"b") == 0)
		{	
			tb=(l_byte *)va_arg(args,int *);
			(*tb)=l_bytebuf(buf,t++);
		}
		else if(l_strcmp(tmp,"w") == 0)
		{	
			tw = (l_word *)va_arg(args,int *);
			(*tw) = (l_word)l_bytebuf(buf,t++); 
			(*tw) = ((*tw) << 8)+ (l_word) l_bytebuf(buf,t++);
		}
		else if(l_strcmp(tmp,"dw") == 0)
		{
			tdw=(l_dword *)va_arg(args,int *);
			(*tdw) =((l_word)l_bytebuf(buf,t++) << 24);
			(*tdw) += ((l_word) l_bytebuf(buf,t++) << 16);
			(*tdw) += ((l_word) l_bytebuf(buf,t++) << 8);
			(*tdw) += (l_word) l_bytebuf(buf,t++);
		}
		else	
		{
			split2 =l_newsplit(tmp,".");
			n2=l_nsplit(split2);
			if(n2==2)
			{
				tmp2=l_readsplit(split2,0);
				if(l_strcmp(tmp2,"s") == 0)
				{
					tmp2=l_readsplit(split2,1);
					if(l_atoi(tmp2,&n2) == FALSE)
					{
						l_freesplit(&split2);
						va_end(args);
						l_freesplit(&split);
						return (t-point);
					}
					ts=(l_str *)va_arg(args,char *);	
					if((db=l_buftostr(buf,t,ts,n2)) != n2)
					{
						t += db;
						l_freesplit(&split2);
						va_end(args);
						l_freesplit(&split);
						return (t-point);
					}		
					t += n2;
				}		
				else
				{
					l_freesplit(&split2);
					va_end(args);
					l_freesplit(&split);
					return (t-point);
				}
			}
			else
			{
				l_freesplit(&split2);
				va_end(args);
				l_freesplit(&split);
				return (t-point);
			}
		}	
	}
	va_end(args);
	l_freesplit(&split);
	return (t-point);
}

l_size l_copybuf(l_buf dbuf,l_buf sbuf)
{
	l_memcpy(l_allocbuf(dbuf,l_sizebuf(sbuf)),l_membuf(sbuf,0),l_sizebuf(sbuf));
	return l_sizebuf(dbuf);
}

l_size l_catbuf(l_buf dbuf,l_buf sbuf)
{
	l_size tsize=l_sizebuf(dbuf)+l_sizebuf(sbuf);
	l_memcpy(l_extbuf(dbuf,tsize),l_membuf(sbuf,0),l_sizebuf(sbuf));
	return l_sizebuf(dbuf);
}


void l_copymembuf(l_buf dbuf,l_num pd,l_buf sbuf,l_num ps,l_size len)
{
	l_size tolen=pd+len,tslen=ps+len,nbc,tmp;
	if(tolen > l_sizebuf(dbuf))
		l_extbuf(dbuf,tolen);
	if(tslen > (tmp=l_sizebuf(sbuf)))
		nbc=len-(tslen-tmp);
	else
		nbc=len;
	l_memcpy(l_membuf(dbuf,pd),l_membuf(sbuf,ps),nbc);
}

void l_outbuf(l_buf buf)
{
	l_size i,t=l_sizebuf(buf);
	char *tmp=(char *) l_membuf(buf,0);
	for (i=0;i<t;i++)
		l_stdout("%c",tmp[i]);
}

void l_errbuf(l_buf buf)
{
	l_size i,t=l_sizebuf(buf);
	char *tmp=(char *) l_membuf(buf,0);
	for (i=0;i<t;i++)
		l_stderr("%c",tmp[i]);
}

void l_outexabuf(l_buf buf)
{
	l_size i,t=l_sizebuf(buf);
	l_byte *tmp=(l_byte *) l_membuf(buf,0);
	for (i=0;i<t;i++)
		l_stdout("%02x",tmp[i]);	
}

/*end external funcions*/
